/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.analyser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import org.gcube.informationsystem.base.reference.AccessType;
import org.gcube.informationsystem.model.reference.entities.Resource;
import org.gcube.informationsystem.tree.Node;
import org.gcube.informationsystem.tree.Tree;
import org.gcube.informationsystem.types.knowledge.TypesKnowledge;
import org.gcube.informationsystem.types.reference.Type;
import org.gcube.resourcemanagement.analyser.InstanceAnalyser;
import org.gcube.resourcemanagement.analyser.InstanceAnalyserFactory;
import org.gcube.resourcemanagement.resource.Instance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMultipleAnalyserFactory {
    protected static Logger logger = LoggerFactory.getLogger(InstanceMultipleAnalyserFactory.class);
    protected static Map<String, List<InstanceAnalyser<Resource, Instance>>> instances = new HashMap<String, InstanceAnalyser<Resource, Instance>>();
    protected static Map<String, List<InstanceAnalyser<Resource, Instance>>> polymorphicInstances = new HashMap<String, InstanceAnalyser<Resource, Instance>>();

    protected static List<InstanceAnalyser<Resource, Instance>> sortInstanceAnalyserList(List<InstanceAnalyser<Resource, Instance>> list) {
        list.sort((a1, a2) -> a2.getPriority() - a1.getPriority());
        return list;
    }

    protected static void addInstanceAnalyser(String type, InstanceAnalyser<Resource, Instance> analyser, Map<String, List<InstanceAnalyser<Resource, Instance>>> instancesMap) {
        List<InstanceAnalyser<Resource, Instance>> list = instancesMap.get(type);
        if (list == null) {
            list = new ArrayList<InstanceAnalyser<Resource, Instance>>();
            instancesMap.put(type, list);
        }
        list.add(analyser);
        InstanceMultipleAnalyserFactory.sortInstanceAnalyserList(list);
    }

    protected static void addPolymorphicInstanceAnalyser(String type, InstanceAnalyser<Resource, Instance> analyser) {
        if (!analyser.polymorphic()) {
            return;
        }
        TypesKnowledge tk = TypesKnowledge.getInstance();
        Tree resourceTree = tk.getModelKnowledge().getTree(AccessType.RESOURCE);
        Node node = resourceTree.getNodeByIdentifier(type);
        Set descendants = node.getDescendants();
        for (Node child : descendants) {
            String childTypeName = child.getIdentifier();
            if (instances.containsKey(childTypeName)) {
                if (!polymorphicInstances.containsKey(childTypeName)) continue;
                polymorphicInstances.remove(childTypeName);
                continue;
            }
            if (!polymorphicInstances.containsKey(childTypeName)) {
                InstanceMultipleAnalyserFactory.addInstanceAnalyser(childTypeName, analyser, polymorphicInstances);
                continue;
            }
            InstanceMultipleAnalyserFactory.evaluateBestInstanceAnalyser(childTypeName, analyser, (Tree<Type>)resourceTree);
        }
    }

    protected static void evaluateBestInstanceAnalyser(String type, InstanceAnalyser<Resource, Instance> candidatedAnalyser, Tree<Type> resourceTree) {
        String typeOfCandidatedAnalyser;
        List<InstanceAnalyser<Resource, Instance>> currentAnalysers = polymorphicInstances.get(type);
        String typeOfCurrentAnalyser = currentAnalysers.get(0).getType();
        if (typeOfCurrentAnalyser.compareTo(typeOfCandidatedAnalyser = candidatedAnalyser.getType()) == 0) {
            InstanceMultipleAnalyserFactory.addInstanceAnalyser(type, candidatedAnalyser, polymorphicInstances);
        } else if (resourceTree.isChildOf(typeOfCurrentAnalyser, typeOfCandidatedAnalyser)) {
            polymorphicInstances.remove(type);
            InstanceMultipleAnalyserFactory.addInstanceAnalyser(type, candidatedAnalyser, polymorphicInstances);
        }
    }

    protected static void analyseInstanceAnalyser(InstanceAnalyser<Resource, Instance> analyser) {
        try {
            String name = analyser.getName();
            logger.debug("{} {} found", (Object)name, (Object)InstanceAnalyser.class.getSimpleName());
            String type = analyser.getType();
            InstanceMultipleAnalyserFactory.addInstanceAnalyser(type, analyser, instances);
            InstanceMultipleAnalyserFactory.addPolymorphicInstanceAnalyser(type, analyser);
        }
        catch (Exception e) {
            logger.error("{} {} not initialized correctly. It will not be used", (Object)analyser.getName(), (Object)InstanceAnalyser.class.getSimpleName());
        }
    }

    public static List<InstanceAnalyser<Resource, Instance>> getInstanceAnalysers(String type, UUID id) {
        ArrayList<InstanceAnalyser<Resource, Instance>> instanceAnalysers = new ArrayList<InstanceAnalyser<Resource, Instance>>();
        if (instances.containsKey(type)) {
            List<InstanceAnalyser<Resource, Instance>> analysers = instances.get(type);
            for (InstanceAnalyser<Resource, Instance> analyser : analysers) {
                try {
                    Class<?> clz = analyser.getClass();
                    InstanceAnalyser instanceAnalyser = (InstanceAnalyser)clz.getDeclaredConstructor(String.class, UUID.class).newInstance(type, id);
                    instanceAnalysers.add(instanceAnalyser);
                }
                catch (Exception e) {
                    logger.error("Error while creating {} instance", (Object)InstanceAnalyser.class.getSimpleName(), (Object)e);
                }
            }
        }
        InstanceMultipleAnalyserFactory.sortInstanceAnalyserList(instanceAnalysers);
        return instanceAnalysers;
    }

    static {
        ServiceLoader<InstanceAnalyser> serviceLoader = ServiceLoader.load(InstanceAnalyser.class);
        Iterator<Object> iterator = serviceLoader.iterator();
        while (iterator.hasNext()) {
            InstanceAnalyser analyser;
            InstanceAnalyser instanceAnalyser = analyser = iterator.next();
            InstanceMultipleAnalyserFactory.analyseInstanceAnalyser(instanceAnalyser);
        }
        if (logger.isTraceEnabled()) {
            List<InstanceAnalyser<Resource, Instance>> analysers;
            logger.trace("{} initialized with the following {}s:", (Object)InstanceAnalyserFactory.class.getSimpleName(), (Object)InstanceAnalyserFactory.class.getSimpleName());
            for (String type : instances.keySet()) {
                analysers = instances.get(type);
                for (InstanceAnalyser<Resource, Instance> analyser : analysers) {
                    logger.trace("{} will be managed managed by {}", (Object)type, (Object)analyser.getName());
                }
            }
            logger.trace("{} initialized with the following polymorphic {}s:", (Object)InstanceAnalyserFactory.class.getSimpleName(), (Object)InstanceAnalyserFactory.class.getSimpleName());
            for (String type : polymorphicInstances.keySet()) {
                analysers = polymorphicInstances.get(type);
                for (InstanceAnalyser<Resource, Instance> analyser : analysers) {
                    logger.trace("{} will be managed managed by {} because is polymorphic", (Object)type, (Object)analyser.getName());
                }
            }
        }
    }
}

