package org.gcube.resourcemanagement.manager.webapp.rs;

import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

import org.gcube.resourcemanagement.manager.io.rs.*;
import org.gcube.resourcemanagement.manager.webapp.ResourceInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Manuele Simi (ISTI-CNR)
 *
 */
@Path(ContextPath.ROOT)
public class Context {
	
	private static Logger logger = LoggerFactory.getLogger(Context.class);

	public static final String ID_PATH_PARAM = "id";
	public static final String TYPE_PATH_PARAM = "type";
	
	/*
	 * e.g. GET /resource-manager/access/schema/ContactFacet?polymorphic=true
	 */
	@GET
	@Path(ContextPath.SCHEMA_PATH_PART + "/{" + TYPE_PATH_PARAM + "}")
	@Produces(ResourceInitializer.APPLICATION_JSON_CHARSET_UTF_8)
	public String voidMethod(@PathParam(TYPE_PATH_PARAM) String type,
			@QueryParam(ContextPath.POLYMORPHIC_PARAM) @DefaultValue("false") Boolean polymorphic)
		{
		logger.info("Requested Schema for type {}", type);

		return "";
	}
}
