/**
 * 
 */
package org.gcube.resourcemanagement.model.reference.entities.resources;

import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.types.annotations.ResourceSchema;
import org.gcube.informationsystem.types.annotations.ResourceSchemaEntry;
import org.gcube.informationsystem.types.annotations.ResourceSchemaRelatedEntry;
import org.gcube.resourcemanagement.model.impl.entities.resources.ConfigurationTemplateImpl;
import org.gcube.resourcemanagement.model.reference.entities.facets.IdentifierFacet;
import org.gcube.resourcemanagement.model.reference.entities.facets.SimplePropertyFacet;
import org.gcube.resourcemanagement.model.reference.relations.consistsof.IsIdentifiedBy;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.IsConfiguredBy;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.IsCustomizedBy;
import org.gcube.resourcemanagement.model.reference.relations.isrelatedto.IsDerivationOf;

/**
 * @author Luca Frosini (ISTI - CNR)
 * https://wiki.gcube-system.org/gcube/Facet_Based_Resource_Model#Configuration_Template
 */
@JsonDeserialize(as=ConfigurationTemplateImpl.class)
@ResourceSchema(
	facets={
			@ResourceSchemaEntry(relation=IsIdentifiedBy.class, facet=IdentifierFacet.class, min=1),
			@ResourceSchemaEntry(facet=SimplePropertyFacet.class, min=1)
	},
	resources = {
			@ResourceSchemaRelatedEntry(source=Configuration.class, relation=IsDerivationOf.class, target=ConfigurationTemplate.class),
			@ResourceSchemaRelatedEntry(source=Service.class, relation=IsCustomizedBy.class, target=ConfigurationTemplate.class),
			@ResourceSchemaRelatedEntry(source=Software.class, relation=IsConfiguredBy.class, target=ConfigurationTemplate.class),
	}
)
public interface ConfigurationTemplate extends GCubeResource {
	
	public static final String NAME = "ConfigurationTemplate"; //ConfigurationTemplate.class.getSimpleName();
	public static final String DESCRIPTION = "It represents a template for a configuration. It describe how a configuration has to be realized. E.g. Used to define the accounting configuration parameters template.";
	public static final String VERSION = "1.0.0";
	
}