package org.gcube.resourcemanagement.model.reference.entities.facets;

import org.gcube.informationsystem.model.reference.entities.Facet;
import org.gcube.informationsystem.types.annotations.ISProperty;
/**
 * A name property for a {@link Facet}.
 *  
 * @author Manuele Simi (ISTI CNR)
 *
 */
public interface NameProperty {

	public static final String NAME_PROPERTY = "name";

	/**
	 * Gets the name of the facet.
	 * @return the name
	 */
	@ISProperty(name=NAME_PROPERTY, mandatory=true, nullable=false)
	public String getName();

	/**
	 * Sets the name of the facet.
	 * @param name the new name
	 */
	public void setName(String name);	

}
