package org.gcube.resourcemanagement.model.impl.entity.properties;

import org.gcube.resourcemanagement.model.reference.entity.properties.RegexProperty;

import com.fasterxml.jackson.annotation.JsonTypeName;

/**
 * Implementation for {@link RegexProperty}.
 * 
 * @author Manuele Simi (ISTI CNR)
 *
 */
@JsonTypeName(value=RegexProperty.NAME)
public class RegexPropertyImpl implements RegexProperty {

	private static final long serialVersionUID = -8279692341196771526L;

	private String value;
	private String type;
	
	/* (non-Javadoc)
	 * @see org.gcube.informationsystem.model.reference.embedded.TypedProperty#getValue()
	 */
	@Override
	public String getValue() {
		return this.value;
	}

	/* (non-Javadoc)
	 * @see org.gcube.informationsystem.model.reference.embedded.TypedProperty#setValue(java.lang.Object)
	 */
	@Override
	public void setValue(String value) {
		this.value = value;
	}

	/* (non-Javadoc)
	 * @see org.gcube.informationsystem.model.reference.embedded.TypedProperty#getType()
	 */
	@Override
	public String getType() {
		return this.type;
	}

	/* (non-Javadoc)
	 * @see org.gcube.informationsystem.model.reference.embedded.TypedProperty#setType(java.lang.Object)
	 */
	@Override
	public void setType(String type) {
		this.type = type;
	}

}
