package org.gcube.portlets.user.gisviewer.server;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.gcube.common.geoserverinterface.GeoCaller;
import org.gcube.common.geoserverinterface.GeoCaller.FILTER_TYPE;
import org.gcube.common.geoserverinterface.GeonetworkCommonResourceInterface.GeoserverMethodResearch;
import org.gcube.common.geoserverinterface.GeoserverCaller;
import org.gcube.common.geoserverinterface.bean.CoverageTypeRest;
import org.gcube.common.geoserverinterface.bean.CswLayersResult;
import org.gcube.common.geoserverinterface.bean.FeatureTypeRest;
import org.gcube.common.geoserverinterface.bean.GroupRest;
import org.gcube.common.geoserverinterface.bean.LayerCsw;
import org.gcube.common.geoserverinterface.bean.LayerRest;
import org.gcube.portlets.user.gisviewer.client.Constants;
import org.gcube.portlets.user.gisviewer.client.GisViewerService;
import org.gcube.portlets.user.gisviewer.client.commons.beans.BoundsMap;
import org.gcube.portlets.user.gisviewer.client.commons.beans.DataResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.GroupInfo;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItem;
import org.gcube.portlets.user.gisviewer.client.commons.beans.LayerItemsResult;
import org.gcube.portlets.user.gisviewer.client.commons.beans.Property;
import org.gcube.portlets.user.gisviewer.client.commons.beans.WfsTable;
import org.gcube.portlets.user.gisviewer.client.commons.utils.URLMakers;
import org.gcube.portlets.user.gisviewer.server.datafeature.ClickDataParser;
import org.gcube.portlets.user.gisviewer.server.datafeature.FeatureParser;
import org.gcube.portlets.user.gisviewer.server.datafeature.FeatureTypeParser;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

public abstract class GisViewerServiceImpl extends RemoteServiceServlet implements GisViewerService {

	private static final long serialVersionUID = -2481133840394575925L;

	protected static final boolean BASE_LAYER = true;
	protected static final GeoserverMethodResearch researchMethod = GeoserverMethodResearch.MOSTUNLOAD;

//	protected GeoCaller geoCaller = null;
	private Map<String, GeoCaller> geoCallersMap = new HashMap<String, GeoCaller>();
	//private static Bounds defaultBounds = new Bounds(-180, -90, 180, 90);

	protected abstract GisViewerServiceParameters getParameters() throws Exception;

	protected GeoCaller getGeoCaller() throws Exception {		
		GisViewerServiceParameters parameters = getParameters();
		String geoserverUrl = parameters.getGeoServerUrl();
		String geonetworkUrl = parameters.getGeoNetworkUrl();
		String gnUser = parameters.getGeoNetworkUser();
		String gnPwd = parameters.getGeoNetworkPwd();
		String gsUser = parameters.getGeoServerUser();
		String gsPwd = parameters.getGeoServerPwd();

		GeoCaller geoCaller = geoCallersMap.get(geonetworkUrl);
		
		if (geoCaller!=null) {
			System.out.println("-----------GEOCALLER FOUND IN MAP");
			return geoCaller;
		} else {		
			System.out.println("-----------GEOCALLER NOT FOUND IN MAP, ADDED...");
			try {
				geoCaller = new GeoCaller(geonetworkUrl, gnUser, gnPwd, geoserverUrl, gsUser, gsPwd, researchMethod);
				geoCallersMap.put(geonetworkUrl, geoCaller);
				return geoCaller;
			} catch (Exception e) {
				throw new Exception("Error initializing the GeoCaller", e);
			}
		}

		//		if (geoCaller!=null) return geoCaller;
//		try {
//
//			GisViewerServiceParameters parameters = getParameters();
//			String geoserverUrl = parameters.getGeoServerUrl();
//			String geonetworkUrl = parameters.getGeoNetworkUrl();
//			String gnUser = parameters.getGeoNetworkUser();
//			String gnPwd = parameters.getGeoNetworkPwd();
//			String gsUser = parameters.getGeoServerUser();
//			String gsPwd = parameters.getGeoServerPwd();
//
//			geoCaller = new GeoCaller(geonetworkUrl, gnUser, gnPwd, geoserverUrl, gsUser, gsPwd, researchMethod);
//
//			return geoCaller;
//		} catch (Exception e) {
//			throw new Exception("Error initializing the GeoCaller", e);
//		}
	}

	//http://geoserver-dev.d4science-ii.research-infrastructures.eu/geoserver/wfs?service=wfs&version=1.1.0&request=DescribeFeatureType&typeName=aquamaps:depthmean

	public List<DataResult> getDataResult(List<String> urls) {
		List<DataResult> result = new ArrayList<DataResult>();

		for (String url : urls) {
			List<DataResult> oneGeoserverResult = ClickDataParser.getDataResult(url); // TODO adjust url adding wms
			result.addAll(oneGeoserverResult);
		}

		return result;
	}

	public LayerItemsResult getGroupsInfo(String groupName) {
		// search of geoserver that contains the group
		String gsUrl=null;
		try {
			GeoCaller geoCaller = getGeoCaller();
			gsUrl = geoCaller.getGeoServerForGroup(groupName);
			if (gsUrl==null)
				return null;

			String gsGwcUrl = URLMakers.getGeoserverGwcUrl(gsUrl);
			String gsWmsUrl = URLMakers.getGeoserverWmsUrl(gsUrl);

			//FIXME manage the exception
			GisViewerServiceParameters parameters = getParameters();
			String gsUser = parameters.getGeoServerUser();
			String gsPwd = parameters.getGeoServerPwd();

			// connecting to the geoserver found
			GeoserverCaller geoserverCaller = new GeoserverCaller(gsUrl, gsUser, gsPwd);

			GroupRest groupRest = geoserverCaller.getLayerGroup(groupName);

			return getLayersInfo(groupRest.getLayers());
			
		} catch (Exception e) {
			System.out.println("gisViewer EXCEPTION: Error in getGroupInfo. Message=\""+e.getMessage()+"\"");
			System.out.println("geoserver_url="+gsUrl);
			System.out.println("Stacktrace: "+e.getStackTrace());
			e.printStackTrace();
			return null;
		}
	}

	// TO DELETE
//	public GroupInfo getGroupsInfoOld(String groupName) {
//		// search of geoserver that contains the group
//		String gsUrl=null;
//		try {
//			GeoCaller geoCaller = getGeoCaller();
//			gsUrl = geoCaller.getGeoServerForGroup(groupName);
//			if (gsUrl==null)
//				return null;
//		} catch (Exception e) {
//			e.printStackTrace();
//			return null;
//		}		
//
//		try {
//			String gsGwcUrl = URLMakers.getGeoserverGwcUrl(gsUrl);
//			String gsWmsUrl = URLMakers.getGeoserverWmsUrl(gsUrl);
//
//			//FIXME manage the exception
//			GisViewerServiceParameters parameters = getParameters();
//			String gsUser = parameters.getGeoServerUser();
//			String gsPwd = parameters.getGeoServerPwd();
//
//			// connecting to the geoserver found
//			GeoserverCaller geoserverCaller = new GeoserverCaller(gsUrl, gsUser, gsPwd);
//
//			GroupInfo result = new GroupInfo();
//			ArrayList<LayerItem> layerItems = new ArrayList<LayerItem>();
//
//			GroupRest groupRest = geoserverCaller.getLayerGroup(groupName);
//
//			result.setName(groupName);
//			result.setBounds(new BoundsMap(groupRest.getBounds().getMinx(), 
//					groupRest.getBounds().getMiny(), 
//					groupRest.getBounds().getMaxx(), 
//					groupRest.getBounds().getMaxy(),
//					groupRest.getBounds().getCrs()));
//
//			//			if (groupRest.getLayers().size() > 1) {
//
//			List<String> workspaces = new ArrayList<String>();
//			List<String> layerNames = new ArrayList<String>();
//			Boolean visible = true;
//			for (String layerName: groupRest.getLayers()) {
//				LayerRest layerRest = geoserverCaller.getLayer(layerName);
//				// if the layer type is "border" and the border visualization is not activate, the layer is not processed
//				if (!layerRest.getName().equals(Constants.borderLayer) || Constants.isBorderLayerVisible) {
//					LayerItem layerItem = getLayerInfo(layerRest, groupRest, layerName, gsUrl, gsWmsUrl, gsGwcUrl);
//					if (!layerItem.isBaseLayer()) {
//						layerItem.setVisible(visible);
//						visible = false;
//					}
//					layerItems.add(layerItem);
//					workspaces.add(ServerGeoExtCostants.workSpace);
//					layerNames.add(layerRest.getName());
//				}
//			}
//
//
//			// set titles
//			if (Constants.getLayerTitles) {
//				List<String> titles = geoserverCaller.getLayerTitlesByWms(workspaces, layerNames);
//				for (int i=0;i<titles.size();i++)
//					if (titles.get(i)!=null)
//						layerItems.get(i).setTitle(titles.get(i));
//			}
//
//			result.setLayers(layerItems);
//
//			return result;
//		} catch (Exception e) {
//			System.out.println("gisViewer EXCEPTION: Error in getGroupInfo. Message=\""+e.getMessage()+"\"");
//			System.out.println("geoserver_url="+gsUrl);
//			System.out.println("Stacktrace: "+e.getStackTrace());
//			e.printStackTrace();
//			return null;
//		}
//	}

//	private LayerItem getLayerInfo(LayerRest layerRest, GroupRest groupRest, String layerName, String gsUrl, String gsWmsUrl, String gsGwcUrl) {
//		LayerItem layerItem = new LayerItem();
//
//		// set the dataStore
//		layerItem.setDataStore(layerRest.getDatastore());
//
//		layerItem.setDefaultStyle(layerRest.getDefaultStyle());
//		layerItem.setStyle(groupRest.getStyle(layerRest.getName()));
//
//		layerItem.setMaxExtent(groupRest.getBounds().getMinx(), 
//				groupRest.getBounds().getMiny(), 
//				groupRest.getBounds().getMaxx(),
//				groupRest.getBounds().getMaxy(),
//				groupRest.getBounds().getCrs());
//
//		layerItem.setBuffer(2);
//		layerItem.setLayer(ServerGeoExtCostants.workSpace+":" + layerName);
//		layerItem.setName(layerName);
//		layerItem.setTitle(layerName);
//
//		if (layerRest.getType().contentEquals("RASTER")) {
//			layerItem.setHasLegend(false);
//			if (!layerRest.getName().equals(Constants.borderLayer)) {
//				layerItem.setBaseLayer(BASE_LAYER);
//				layerItem.setTrasparent(false);
//			}
//			else {
//				layerItem.setBaseLayer(false);
//				layerItem.setTrasparent(true);
//			}
//			layerItem.setClickData(false);
//			layerItem.setVisible(true);
//		} else {
//			layerItem.setBaseLayer(false);
//			layerItem.setClickData(true);
//			layerItem.setStyles(layerRest.getStyles());
//			layerItem.setHasLegend(true);
//			layerItem.setTrasparent(true);
//		}
//
//		layerItem.setUrl(gsGwcUrl);
//		layerItem.setGeoserverUrl(gsUrl);
//		layerItem.setGeoserverWmsUrl(gsWmsUrl);
//
//		// set layer properties info
//		List<Property> properties = FeatureTypeParser.getProperties(gsUrl, layerItem.getLayer());
//		layerItem.setProperties(properties);
//		return layerItem;
//	}

	public LayerItemsResult getLayersInfo(List<String> layersName) {
		LayerItemsResult layerItemsResult = new LayerItemsResult();
		
		Map<String, GeoserverCaller> geoserverCallers = new HashMap<String, GeoserverCaller>(); 
		int countVisible=0;

		for (String layerName: layersName) {
			try {
				GeoCaller geoCaller = getGeoCaller();

				CswLayersResult cswLayerResult = geoCaller.getLayersFromCsw(null, 1, 1, false, true, FILTER_TYPE.ANY_TEXT, layerName);				
				if (cswLayerResult.getLayers().size()==0)
					layerItemsResult.addStatusMessage("- Layer \""+layerName+"\" not found.");
				else {
					LayerCsw layerCsw = cswLayerResult.getLayers().get(0);
					String gsUrl = URLMakers.getGeoserverUrlFromWmsUrl(layerCsw.getGeoserverUrl());
					String gsGwcUrl = URLMakers.getGeoserverGwcUrl(gsUrl);
					String gsWmsUrl = URLMakers.getGeoserverWmsUrl(gsUrl);

					GeoserverCaller geoserverCaller;
					if ((geoserverCaller = geoserverCallers.get(gsUrl))==null) {
						GisViewerServiceParameters parameters = getParameters();
						String gsUser = parameters.getGeoServerUser();
						String gsPwd = parameters.getGeoServerPwd();
						geoserverCaller = new GeoserverCaller(gsUrl, gsUser, gsPwd);
						geoserverCallers.put(gsUrl, geoserverCaller);
					}

					LayerItem layerItem = new LayerItem();
					layerItem.setName(layerName);
					layerItem.setTitle(layerCsw.getTitle());
					layerItem.setVisible((countVisible++)<2);
					layerItem.setUrl(gsGwcUrl);
					layerItem.setGeoserverUrl(gsUrl);
					layerItem.setGeoserverWmsUrl(gsWmsUrl);

					LayerRest layerRest = geoserverCaller.getLayer(layerName);

					// set the dataStore
					layerItem.setDataStore(layerRest.getDatastore());

					layerItem.setDefaultStyle(layerRest.getDefaultStyle());
					layerItem.setStyle(layerRest.getDefaultStyle());

					layerItem.setBuffer(2);
					layerItem.setLayer(ServerGeoExtCostants.workSpace+":" + layerName);
					if (layerRest.getType().contentEquals("RASTER")) {

						CoverageTypeRest coverageTypeRest = geoserverCaller.getCoverageType(
								layerRest.getWorkspace(), 
								layerRest.getCoveragestore(), 
								layerName);

						layerItem.setMaxExtent(coverageTypeRest.getLatLonBoundingBox().getMinx(), 
								coverageTypeRest.getLatLonBoundingBox().getMiny(), 
								coverageTypeRest.getLatLonBoundingBox().getMaxx(),
								coverageTypeRest.getLatLonBoundingBox().getMaxy(),
								coverageTypeRest.getLatLonBoundingBox().getCrs());
						layerItem.setHasLegend(false);
						layerItem.setBaseLayer(BASE_LAYER);
						layerItem.setTrasparent(false);
						layerItem.setClickData(false);
					} else {
						FeatureTypeRest featureTypeRest = geoserverCaller.getFeatureType(layerRest.getWorkspace(), 
								layerRest.getDatastore(), 
								layerName);

						layerItem.setMaxExtent(featureTypeRest.getLatLonBoundingBox().getMinx(), 
								featureTypeRest.getLatLonBoundingBox().getMiny(), 
								featureTypeRest.getLatLonBoundingBox().getMaxx(),
								featureTypeRest.getLatLonBoundingBox().getMaxy(),
								featureTypeRest.getLatLonBoundingBox().getCrs());

						layerItem.setBaseLayer(false);
						layerItem.setClickData(true);
						layerItem.setStyles(layerRest.getStyles());
						layerItem.setHasLegend(true);

						layerItem.setTrasparent(true);
					}

					layerItemsResult.addLayerItem(layerItem);
					
					// set layer properties info
					List<Property> properties = FeatureTypeParser.getProperties(gsUrl, layerItem.getLayer());
					layerItem.setProperties(properties);

				}
			} catch (Exception e) {
				e.printStackTrace();
				layerItemsResult.addStatusMessage("- Layer \""+layerName+"\" not found.");
			}
		}
		
		boolean isBaseLayer = false;
		for (LayerItem l: layerItemsResult.getLayerItems()) {
			if (!isBaseLayer) isBaseLayer = l.isBaseLayer();
		}
		if (!isBaseLayer && layerItemsResult.getLayerItemsSize() > 0) {
			layerItemsResult.getLayerItems().get(0).setBaseLayer(BASE_LAYER);
		}

		return layerItemsResult;
	}



	/* (non-Javadoc)
	 * @see org.gcube.portlets.user.gisviewer.client.GisViewerService#getLayersInfoByLayerItems(java.util.List)
	 */
	@Override
	public LayerItemsResult getLayersInfoByLayerItems(List<LayerItem> layerItems) {
		LayerItemsResult layerItemsResult = new LayerItemsResult();

		int countVisible=0;
		for (LayerItem layerItem: layerItems) {
			String gsUrl = layerItem.getGeoserverUrl();
			String layerName = layerItem.getName();
			try {
				if (gsUrl==null)
					throw new Exception();
				
				GeoserverCaller geoserverCaller;
				GisViewerServiceParameters parameters = getParameters();
				String gsUser = parameters.getGeoServerUser();
				String gsPwd = parameters.getGeoServerPwd();

				geoserverCaller = new GeoserverCaller(gsUrl, gsUser, gsPwd);

				String gsGwcUrl = URLMakers.getGeoserverGwcUrl(gsUrl);
				String gsWmsUrl = URLMakers.getGeoserverWmsUrl(gsUrl);
				layerItem.setUrl(gsGwcUrl);
				layerItem.setGeoserverWmsUrl(gsWmsUrl);

				layerItem.setVisible((countVisible++)<2);

				LayerRest layerRest = geoserverCaller.getLayer(layerName);

				// set the dataStore MIO
				layerItem.setDataStore(layerRest.getDatastore());

				layerItem.setDefaultStyle(layerRest.getDefaultStyle());
				layerItem.setStyle(layerRest.getDefaultStyle());

				layerItem.setBuffer(2);
				layerItem.setLayer(ServerGeoExtCostants.workSpace+":" + layerName);
				if (layerRest.getType().contentEquals("RASTER")) {
					CoverageTypeRest coverageTypeRest = geoserverCaller.getCoverageType(
							layerRest.getWorkspace(), 
							layerRest.getCoveragestore(), 
							layerName);

					layerItem.setMaxExtent(coverageTypeRest.getLatLonBoundingBox().getMinx(), 
							coverageTypeRest.getLatLonBoundingBox().getMiny(), 
							coverageTypeRest.getLatLonBoundingBox().getMaxx(),
							coverageTypeRest.getLatLonBoundingBox().getMaxy(),
							coverageTypeRest.getLatLonBoundingBox().getCrs());
					layerItem.setHasLegend(false);
					layerItem.setBaseLayer(BASE_LAYER);
					layerItem.setTrasparent(false);
					layerItem.setClickData(false);
				} else {
					FeatureTypeRest featureTypeRest = geoserverCaller.getFeatureType(layerRest.getWorkspace(), 
							layerRest.getDatastore(), 
							layerName);

					layerItem.setMaxExtent(featureTypeRest.getLatLonBoundingBox().getMinx(), 
							featureTypeRest.getLatLonBoundingBox().getMiny(), 
							featureTypeRest.getLatLonBoundingBox().getMaxx(),
							featureTypeRest.getLatLonBoundingBox().getMaxy(),
							featureTypeRest.getLatLonBoundingBox().getCrs());

					layerItem.setBaseLayer(false);
					layerItem.setClickData(true);
					layerItem.setStyles(layerRest.getStyles());
					layerItem.setHasLegend(true);

					layerItem.setTrasparent(true);
				}
				layerItemsResult.addLayerItem(layerItem);
				
				// set layer properties info
				List<Property> properties = FeatureTypeParser.getProperties(gsUrl, layerItem.getLayer());
				layerItem.setProperties(properties);

			} catch (Exception e) {
				e.printStackTrace();
				layerItemsResult.addStatusMessage("- Layer \""+layerName+"\" not found.");
			}
		} // for

		// set eventually base layer
		boolean isBaseLayer = false;
		for (LayerItem l: layerItemsResult.getLayerItems())
			if (!isBaseLayer) isBaseLayer = l.isBaseLayer();

		if (!isBaseLayer && layerItemsResult.getLayerItemsSize() > 0) {
			layerItemsResult.getLayerItems().get(0).setBaseLayer(BASE_LAYER);
		}

		return layerItemsResult;
	}


	/**
	 * {@inheritDoc}
	 */
	@Override
	public String getTransectUrl() {
		try {
			return getParameters().getTransectUrl();
		} catch (Exception e) {
			// FIXME to complete
			e.printStackTrace();
			return null;
		}
	}

	@Override
	public List<WfsTable> getDataResult(List<LayerItem> layerItems, String bbox) {
		List<WfsTable> result = FeatureParser.getDataResults(layerItems, bbox);
		return result;
	}
}
