package org.gcube.portlets.user.gisviewer.client.commons.beans;

import java.util.ArrayList;
import java.util.List;

import com.google.gwt.user.client.rpc.IsSerializable;

public class LayerItem implements IsSerializable, Cloneable {
	
	private String name;
	private String url;
	private String layer;
	private String style;
	private boolean isTrasparent=false;
	private boolean isBaseLayer=true;
	private boolean isBorderLayer=false;
	private boolean wrapDateLine=true;
	private int buffer = 0;
	private boolean hasLegend=false;
	private boolean isVisible=true;
	private boolean isOnMap=true;
	private boolean clickData=true;
	private BoundsMap maxExtent = null;
	private String defaultStyle = "";
	private double opacity = 0.0;
	private ArrayList<String> styles = new ArrayList<String>();
	private String title=null;

	private List<Property> properties = new ArrayList<Property>();
	private String dataStore = "";
	private String geoserverUrl;
	private String geoserverWmsUrl;
	private String cqlFilter = ""; 
	private long id;
	private long order;
	private boolean isExternal = false;
	public static final String FLOAT_TYPE = "xsd:float";
	public static final String INT_TYPE = "xsd:int";
	public static long ID_COUNTER = 0;


	public LayerItem() {
		super();
		this.id = (ID_COUNTER++);
	}
	
	public LayerItem(boolean isExternal) {
		this();
		this.setExternal(isExternal);
	}
	
	public boolean isHasLegend() {
		return hasLegend;
	}

	public void setHasLegend(boolean hasLegend) {
		this.hasLegend = hasLegend;
	}

	public BoundsMap getMaxExtent() {
		return maxExtent;
	}

	public void setMaxExtent(BoundsMap maxExtent) {
		this.maxExtent = maxExtent;
	}

	public void setMaxExtent(double lowerLeftX,
								double lowerLeftY,
								double upperRightX,
								double upperRightY,
								String crs) {
		
		this.maxExtent = new BoundsMap(lowerLeftX, lowerLeftY, upperRightX, upperRightY, crs);
	}

	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	public String getLayer() {
		return layer;
	}
	public void setLayer(String layer) {
		this.layer = layer;
	}
	public String getStyle() {
		return style;
	}
	public void setStyle(String style) {
		this.style = style;
	}
	public boolean isTrasparent() {
		return isTrasparent;
	}
	public void setTrasparent(boolean isTrasparent) {
		this.isTrasparent = isTrasparent;
	}
	public boolean isBaseLayer() {
		return isBaseLayer;
	}
	public void setBaseLayer(boolean isBaseLayer) {
		this.isBaseLayer = isBaseLayer;
	}
	public boolean isWrapDateLine() {
		return wrapDateLine;
	}
	public void setWrapDateLine(boolean wrapDateLine) {
		this.wrapDateLine = wrapDateLine;
	}
	public int getBuffer() {
		return buffer;
	}
	public void setBuffer(int buffer) {
		this.buffer = buffer;
	}
	public boolean isVisible() {
		return isVisible;
	}
	public void setVisible(boolean isVisible) {
		this.isVisible = isVisible;
	}
	public boolean isOnMap() {
		return isOnMap;
	}
	public void setOnMap(boolean isOnMap) {
		this.isOnMap = isOnMap;
	}
	public boolean isClickData() {
		return clickData;
	}
	public void setClickData(boolean clickData) {
		this.clickData = clickData;
	}
	public String getDefaultStyle() {
		return defaultStyle;
	}
	public void setDefaultStyle(String defaultStyle) {
		this.defaultStyle = defaultStyle;
	}
	public ArrayList<String> getStyles() {
		return styles;
	}
	public void setStyles(ArrayList<String> styles) {
		this.styles = styles;
	}
	public double getOpacity() {
		return opacity;
	}

	public void setOpacity(double opacity) {
		this.opacity = opacity;
	}
	
	public LayerItem clone() {
		LayerItem ele = new LayerItem();
		
		ele.setBaseLayer(this.isBaseLayer);
		ele.setClickData(this.clickData);
		ele.setBuffer(this.buffer);
		ele.setDefaultStyle(this.defaultStyle);
		ele.setHasLegend(this.hasLegend);
		ele.setLayer(this.layer);
		ele.setMaxExtent(maxExtent);
		ele.setName(this.name);
		ele.setOnMap(this.isOnMap);
		ele.setOpacity(this.opacity);
		ele.setStyle(this.style);
		ele.setStyles(this.styles);
		ele.setTrasparent(this.isTrasparent);
		ele.setUrl(this.url);
		ele.setVisible(this.isVisible);
		ele.setWrapDateLine(this.wrapDateLine);
		ele.setProperties(this.getProperties());
		
		return ele;
	}
	
	public List<Property> getProperties() {
		return properties;
	}
	
	public void setProperties(List<Property> properties) {
		this.properties = properties;
	}
	
	// added by ceras
	// search a float property in the layer's feature type
	public boolean containsProperty(String propertyName) {
		boolean contains = false;
		for (Property p : properties) {
			if (p.getName().equals(propertyName) && (p.getType().equals(FLOAT_TYPE) || p.getType().equals(INT_TYPE)))
				contains=true;
		}
		return contains;
	}
	
	// added by ceras
	// search a property in the layer's feature type, giving property name and property type
	public boolean containsProperty(String propertyName, String propertyType) {
		if (properties==null)
			return false;

		boolean contains = false;
		for (Property p : properties) {
			if (p.getName().equals(propertyName) && p.getType().equals(propertyType))
				contains=true;
		}
		return contains;
	}
	
	// added by ceras
	// search a property in the layer's feature type, giving a property object
	public boolean containsProperty(Property property) {
		if (properties==null)
			return false;

		boolean contains = false;
		for (Property p : properties) {
			if (p.getName().equals(property.getName()) && p.getType().equals(property.getType()))
				contains=true;
		}
		return contains;
	}
	
	// added by ceras
	// search for float Property objects belongs to the layer 
	public List<Property> getAllFloatProperties() {
		if (properties==null)
			return null;

		List<Property> floatProperties = new ArrayList<Property>();
		for (Property p : properties) {
			if (p.getType().equals(FLOAT_TYPE))
				floatProperties.add(p);
		}
		return floatProperties;
	}

	// added by ceras
	// search for float Property names belongs to the layer 
	public List<String> getAllFloatPropertyNames() {
		if (properties==null)
			return null;

		List<String> floatPropertyNames = new ArrayList<String>();
		for (Property p : properties) {
			if (p.getType().equals(FLOAT_TYPE))
				floatPropertyNames.add(p.getName());
		}
		
		return floatPropertyNames;
	}
	
	
	// added by ceras
	// get the first float Property names belongs to the layer 
	public String getFirstFloatPropertyName() {
		if (properties==null)
			return null;
		
		for (Property p : properties) {
			if (p.getType().equals(FLOAT_TYPE))
				return p.getName();
		}
		
		return null;
	}

	// added by ceras
	public void setDataStore(String dataStore) {
		this.dataStore  = dataStore;
	}
	
	// added by ceras
	public String getDataStore() {
		return dataStore;
	}
	
	// added by ceras
	public void setBorderLayer(boolean isBorderLayer) {
		this.isBorderLayer = isBorderLayer;
	}
	
	// added by ceras
	public boolean isBorderLayer() {
		return isBorderLayer;
	}

	// added by ceras
	public void setGeoserverUrl(String geoserverUrl) {
		this.geoserverUrl = geoserverUrl;
	}
	
	// added by ceras
	public String getGeoserverUrl() {
		return geoserverUrl;
	}
	
	// added by ceras
	public void setGeoserverWmsUrl(String geoserverWmsUrl) {
		this.geoserverWmsUrl = geoserverWmsUrl;
	}
	
	// added by ceras
	public String getGeoserverWmsUrl() {
		return geoserverWmsUrl;
	}
	
	public void setTitle(String title) {
		this.title = title;
	}
	
	public String getTitle() {
		return title;
	}
	
	public long getId() {
		return id;
	}
	
	public void setId(long id) {
		this.id = id;
	}

	public void setOrder(long order) {
		this.order = order;
	}
	
	public long getOrder() {
		return order;
	}
	
	public String getCqlFilter() {
		return cqlFilter;
	}
	
	public void setCqlFilter(String cqlFilter) {
		this.cqlFilter = cqlFilter;
	}

	/**
	 * @return
	 */
	public boolean isExternal() {
		return isExternal;
	}
	
	/**
	 * @param isExternal the isExternal to set
	 */
	public void setExternal(boolean isExternal) {
		this.isExternal = isExternal;
	}
}
