package org.gcube.portlets.user.gisviewer.client.commons.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Vector;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.OptGroupElement;
import com.google.gwt.dom.client.OptionElement;
import com.google.gwt.dom.client.SelectElement;
import com.google.gwt.user.client.ui.ListBox;

public class ODLListBox extends ListBox {
	
	ArrayList<String> ITEMS= new ArrayList<String>();
	ArrayList<String> VALUES= new ArrayList<String>();
	ArrayList<String> GROUP= new ArrayList<String>();
	
	@SuppressWarnings("unchecked")
	public void addOptionsGroup(String group, Map<String, String> items) {
		SelectElement select = getSelectElement();
	    OptGroupElement grp = Document.get().createOptGroupElement();
	    grp.setLabel(group);
	    
	    Vector v = new Vector(items.keySet());
	    Collections.sort(v);
	    
	    // Display (sorted) hashtable.
	    for (Enumeration e = v.elements(); e.hasMoreElements();) {
			String key = (String)e.nextElement();
			String val = (String)items.get(key);
			ITEMS.add(key);
			VALUES.add(val);
			GROUP.add(group);
			//System.out.println("Key: " + key + "     Val: " + val);
	      
	      	OptionElement option = Document.get().createOptionElement();
			option.setText(key);
			option.setValue(val);
			grp.appendChild(option);
	      
	    }
	    select.appendChild(grp);
	}
	
	private SelectElement getSelectElement() {
		return getElement().cast();
	}
	
	public void addItem(String item, String value) {
		super.addItem(item, value);
		ITEMS.add(item);
		VALUES.add(value);
		GROUP.add("");
	}
	
	public String getValue(int index) {
		return VALUES.get(index);
	}
	
	public String getItemText(int index) {
		return ITEMS.get(index);
	}
	
	public String getGroup(int index) {
		return GROUP.get(index);
	}
}
