package org.gcube.portlets.widgets.sessionchecker.server;

import java.util.Date;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.widgets.sessionchecker.client.SessionCheckerService;
import org.gcube.portlets.widgets.sessionchecker.shared.SessionInfoBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.service.UserLocalServiceUtil;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class SessionCheckerServiceImpl extends RemoteServiceServlet implements  SessionCheckerService {

	private static final Logger _log = LoggerFactory.getLogger(SessionCheckerServiceImpl.class);

	private static final String FIRST_TIME = "FIRST_TIME_DEV_MODE";

	/**
	 * the current ASLSession
	 * @return .
	 */
	private ASLSession getASLSession() {	
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		System.out.println("***SessionCheckerServiceImpl USER = " + user + " ID = " + sessionID);
		SessionManager manager = SessionManager.getInstance();
		ASLSession toReturn = manager.getASLSession(sessionID, user);
		return toReturn;		
	}

	@Override
	public SessionInfoBean checkSession() {
		System.out.println("***Trying Liferay");
		UserLocalServiceUtil.getService();
		
		if (isFirstTime() == null) 
			setFirstTimeCheck(true);

		ASLSession session = getASLSession();
		if (session == null) {
			UserLocalServiceUtil.getService();
			
			return new SessionInfoBean("","");
		}

		String user = session.getUsername();
		String scope = session.getScope();

		//check devMode
		if (user == null && isFirstTime()) {
			_log.warn("Stopping session polling as you are in dev mode (I think, am I wrong?)");		
			return new SessionInfoBean("","", true); //tells that you are in development mode (you must be unless you're session expires in less than a minute)	
		}		
		//else
		setFirstTimeCheck(false);
		_log.trace("Session check OK for " + user + " at " + new Date());
		if (user == null || user.compareTo("") == 0) {
			_log.warn("User is null at " + new Date());			
		}
		if (scope == null || scope.compareTo("") == 0) {
			_log.warn("Scope is null at " + new Date());
		}
		return new SessionInfoBean(session.getUsername(), session.getScope());
	}

	private void setFirstTimeCheck(boolean isFirstTime) {
		ASLSession session = getASLSession();
		_log.trace("setFirstTimeCheck " + isFirstTime);
		if (session != null) {
			session.setAttribute(FIRST_TIME, isFirstTime);
			if (isFirstTime) {
				long expiryTime = session.increaseSessionTimeout(350000, true); //bit more than 5 minutes
				_log.trace("asl timeout increased by 5 minutes, ASL to expire at " +  new Date(new Date().getTime()+expiryTime));
			}
		}
	}

	private Boolean isFirstTime() {
		Boolean toReturn =  (Boolean) getASLSession().getAttribute(FIRST_TIME);
		_log.trace("isFirstTime() " + toReturn);
		return toReturn;
	}
}
