package org.gcube.portlets.widgets.sessionchecker.server;

import java.util.Date;

import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.portal.custom.scopemanager.scopehelper.ScopeHelper;
import org.gcube.portlets.widgets.sessionchecker.client.SessionCheckerService;
import org.gcube.portlets.widgets.sessionchecker.shared.SessionInfoBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;

/**
 * The server side implementation of the RPC service.
 */
@SuppressWarnings("serial")
public class SessionCheckerServiceImpl extends RemoteServiceServlet implements  SessionCheckerService {
	
	private static final Logger _log = LoggerFactory.getLogger(SessionCheckerServiceImpl.class);
	/**
	 * the current ASLSession
	 * @return .
	 */
	private ASLSession getASLSession() {	
		System.out.println("\n\n\n*****+ ASL checksession");
		String sessionID = this.getThreadLocalRequest().getSession().getId();
		String user = (String) this.getThreadLocalRequest().getSession().getAttribute(ScopeHelper.USERNAME_ATTRIBUTE);
		
		System.out.println("ASL checksession ID = " +sessionID);
		return SessionManager.getInstance().getASLSession(sessionID, user);
	}
	
	@Override
	public SessionInfoBean checkSession() {
		ASLSession session = getASLSession();
		String user = session.getUsername();
		String scope = session.getScope();
		_log.trace("Session checked for " + user + " at " + new Date());
		if (user == null || user.compareTo("") == 0) {
			_log.warn("User is null at " + new Date());
		}
		if (scope == null || scope.compareTo("") == 0) {
			_log.warn("Scope is null at " + new Date());
		}
		return new SessionInfoBean(session.getUsername(), session.getScope());
	}
	
  
}
