package org.gcube.portlets.widgets.sessionchecker.client;

import org.gcube.portlets.widgets.sessionchecker.shared.SessionInfoBean;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;

public class CheckSession {
	private final int MILLI_SECONDS = 60 * 1000; //60 seconds
	/**
	 * Create a remote service proxy to talk to the server-side Greeting service.
	 */
	private final SessionCheckerServiceAsync checkerService = GWT.create(SessionCheckerService.class);

	private String username;
	private String scope;
	private Timer t;
	
	private static CheckSession singleton;
	
	public static CheckSession getInstance() {
		if (singleton == null)
			singleton = new CheckSession();
		return singleton;
	}
	
	private CheckSession() {		
		t = new Timer() {			
			@Override
			public void run() {
				checkerService.checkSession(new AsyncCallback<SessionInfoBean>() {					
					@Override
					public void onSuccess(SessionInfoBean result) {
						if (result != null) {
							username = result.getUsername();
							scope = result.getScope();
							boolean userValid = ( username != null) ? true : false;
							boolean scopeValid = (scope != null) ? true : false;
							
							if (! (userValid && scopeValid) ) {
								Window.alert("Session Expired");
							}
						}				
					}					
					@Override
					public void onFailure(Throwable caught) { }
				});
			}
		};	
	}
	

	public String getUsername() {
		return username;
	}

	public String getScope() {
		return scope;
	}	
	/**
	 * use to start checking if the session expired
	 */
	public void startPolling() {
		t.scheduleRepeating(MILLI_SECONDS);	
	}
	/**
	 * use to stop checking if the session expired
	 */
	public void stopPolling() {
		t.cancel();
	}	
}
