package org.gcube.portlets.widget.collectionsindexedwords.client;


import java.util.Map;
import gr.uoa.di.madgik.visualisations.WordCloudGroup.client.WordCloudGroup;
import com.google.gwt.user.client.ui.FlowPanel;

public class IndexVisualisationPanel extends FlowPanel {
	
	private String width,height;
	
	/**
	 * A sample jsonVisData is: 
	 * 
	 * @param jsonVisData 
	 * @param width
	 * @param height
	 */
	public IndexVisualisationPanel(int width, int height, String elementID){
		this.width = String.valueOf(width);
		this.height = String.valueOf(height);
		this.setSize(this.width, this.height);
		if( (elementID!=null) && (!elementID.isEmpty()) )
			this.getElement().setId(elementID);
	}

	
	/**
	 * Visualise Collections and Words of collections
	 * If collectionKeyValues is null, it visualises only the words in a wordcloud
	 * 
	 * @param collectionKeyValues should contain (collection_name, a_number) pairs
	 * @param wordcloudKeyValues should contain (a_word, number_of_occurrences) pairs
	 */
	public void visualiseData(Map<String,String> collectionKeyValues, Map<String,String> wordcloudKeyValues){
		
		String jsonWordCloud="", jsonColls="";
		
//		final String col = "{\"name\":\"flare\",\"children\":[{\"name\":\"CategoryA\",\"size\":100},{\"name\":\"CategoryB\",\"size\":100},{\"name\":\"CategoryC\",\"size\":100},{\"name\":\"CategoryD\",\"size\":100},{\"name\":\"CategoryE\",\"size\":100},{\"name\":\"CategoryF\",\"size\":100}]}";
		
		if(collectionKeyValues!=null){
			StringBuilder jsonCollsSB = new StringBuilder("{\"name\":\"flare\",\"children\":[");
			for(String key: collectionKeyValues.keySet())
				jsonCollsSB.append("{\"name\":\""+key+"\",\"size\":"+collectionKeyValues.get(key)+"},");
			jsonColls = jsonCollsSB.toString().substring(0, jsonCollsSB.length()-1)+"]}";
		}
//		final String wor = "[{\"key\":\"cat\",\"value\":100},{\"key\":\"mouse\",\"value\":170},{\"key\":\"elephant\",\"value\":67},{\"key\":\"girraffe\",\"value\":92},{\"key\":\"dog\",\"value\":123},{\"key\":\"crocodile\",\"value\":80},{\"key\":\"fish\",\"value\":176}]";
		
		StringBuilder jsonWordCloudSB = new StringBuilder("[");
		for(String key: wordcloudKeyValues.keySet())
			jsonWordCloudSB.append("{\"key\":\""+key+"\",\"value\":"+wordcloudKeyValues.get(key)+"},");
		jsonWordCloud = jsonWordCloudSB.toString().substring(0, jsonWordCloudSB.length()-1)+"]";
		
//		Window.alert("jsonColls= "+jsonColls);
//		Window.alert("jsonWordCloud= "+jsonWordCloud);
		
		WordCloudGroup wcg = new WordCloudGroup();
		if((collectionKeyValues == null) || collectionKeyValues.isEmpty()){
			wcg.createWordcloud(this.getElement().getId(),  width, height);
			wcg.visualiseWordcloud(jsonWordCloud, width, height);
		}
		else{
			wcg.createVisualisations(this.getElement().getId(), width, height);
			wcg.visualiseCollections(jsonColls, jsonWordCloud, width, height);
		}
		
	}
	

	
	
	

}
