package org.gcube.datacatalogue.grsf_manage_widget.shared;

import java.io.Serializable;


/**
 * Connect the current record with another record
 * @author Costantino Perciante at ISTI-CNR (costantino.perciante@isti.cnr.it)
 */
public class ConnectedBean implements Serializable{

	private static final long serialVersionUID = -4863776727351488790L;
	private String sourceKnowledgeBaseId;
	private String sourceDomain; // i.e. Stock or Fishery 
	private String destShortName;
	private String destSemanticIdentifier;
	private String destKnowledgeBaseId; // the dest indentifier of a Fishery or Stock (the link is from a Stock to a Fishery and viceversa)
	private String url;
	private boolean isExtra;
	private boolean toBeKept = true;

	public ConnectedBean() {
		super();
	}

	/**
	 * 
	 * @param sourceKnowledgeBaseId
	 * @param sourceDomain
	 * @param destShortName
	 * @param destSemanticIdentifier
	 * @param destKnowledgeBaseId
	 * @param url
	 */
	public ConnectedBean(String sourceKnowledgeBaseId, String sourceDomain,
			String destShortName, String destSemanticIdentifier,
			String destKnowledgeBaseId, String url) {
		super();
		this.sourceKnowledgeBaseId = sourceKnowledgeBaseId;
		this.sourceDomain = sourceDomain;
		this.destShortName = destShortName;
		this.destSemanticIdentifier = destSemanticIdentifier;
		this.destKnowledgeBaseId = destKnowledgeBaseId;
		this.url = url;

	}

	public String getDestShortName() {
		return destShortName;
	}

	public void setDestShortName(String destShortName) {
		this.destShortName = destShortName;
	}

	public String getDestSemanticIdentifier() {
		return destSemanticIdentifier;
	}

	public void setDestSemanticIdentifier(String destSemanticIdentifier) {
		this.destSemanticIdentifier = destSemanticIdentifier;
	}
	public String getSourceKnowledgeBaseId() {
		return sourceKnowledgeBaseId;
	}

	public void setSourceKnowledgeBaseId(String sourceKnowledgeBaseId) {
		this.sourceKnowledgeBaseId = sourceKnowledgeBaseId;
	}

	public String getDestKnowledgeBaseId() {
		return destKnowledgeBaseId;
	}

	public void setDestKnowledgeBaseId(String destKnowledgeBaseId) {
		this.destKnowledgeBaseId = destKnowledgeBaseId;
	}

	public String getSourceDomain() {
		return sourceDomain;
	}
	public void setSourceDomain(String sourceDomain) {
		this.sourceDomain = sourceDomain;
	}

	public boolean isToBeKept() {
		return toBeKept;
	}

	public void setToBeKept(boolean toBeKept) {
		this.toBeKept = toBeKept;
	}

	public boolean isExtra() {
		return isExtra;
	}

	public void setExtra(boolean isExtra) {
		this.isExtra = isExtra;
	}
	
	public String getUrl() {
		return url;
	}
	public void setUrl(String url) {
		this.url = url;
	}
	@Override
	public String toString() {
		return "ConnectedBean [sourceKnowledgeBaseId=" + sourceKnowledgeBaseId
				+ ", sourceDomain=" + sourceDomain + ", destShortName="
				+ destShortName + ", destSemanticIdentifier="
				+ destSemanticIdentifier + ", destKnowledgeBaseId="
				+ destKnowledgeBaseId + ", url=" + url + ", isExtra=" + isExtra
				+ ", toBeKept=" + toBeKept + "]";
	}
}
