package org.gcube.portlets.widgets.fileupload.client.view;

import org.gcube.portlets.user.gcubewidgets.client.popup.GCubeDialog;
import org.gcube.portlets.widgets.fileupload.client.bundle.ProgressBarCssAndImages;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.CellPanel;
import com.google.gwt.user.client.ui.HasAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
/**
 * @author Massimiliano Assante, ISTI-CNR
 *
 */
public class UploadProgressDialog extends GCubeDialog {

	private static final int WIDTH = 400;
	
	static {
		ProgressBarCssAndImages.INSTANCE.css().ensureInjected();
	}

	private CellPanel mainPanel = new VerticalPanel();
	private HorizontalPanel bottomPanel = new HorizontalPanel();
	private UploadProgressView uploadView ;

	public UploadProgressDialog(String headerText, HandlerManager eventBus) {
		setText(headerText);
		this.uploadView = new UploadProgressView(this, eventBus);		

		mainPanel.setPixelSize(WIDTH, 80);
		bottomPanel.setPixelSize(WIDTH, 25);

		mainPanel.add(uploadView);
		mainPanel.add(bottomPanel);

		bottomPanel.setHorizontalAlignment(HasAlignment.ALIGN_RIGHT);
		Button close = new Button("Cancel");
		bottomPanel.add(close);
		close.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hide();				
			}
		});		
		mainPanel.setCellHeight(bottomPanel, "25px");
		setWidget(mainPanel);
	}


	public void showRegisteringResult(boolean result) {
		uploadView.showRegisteringResult(result);
	}

	protected void hideCloseButton() {
		bottomPanel.clear();
	}

	protected void showFinalCloseButton() {
		bottomPanel.clear();
		Button close = new Button("Close");
		bottomPanel.add(close);
		close.addClickHandler(new ClickHandler() {
			@Override
			public void onClick(ClickEvent event) {
				hide();				
			}
		});
	}
}
