package org.gcube.portlets.widgets.dataminermanagerwidget.client.experiments;


import org.gcube.data.analysis.dataminermanagercl.shared.data.computations.ComputationId;

import com.allen_sauer.gwt.log.client.Log;
import com.sencha.gxt.widget.core.client.Dialog;
import com.sencha.gxt.widget.core.client.container.BoxLayoutContainer.BoxLayoutPack;
import com.sencha.gxt.widget.core.client.form.TextArea;

/**
 * 
 * @author Giancarlo Panichi email: <a
 *         href="mailto:g.panichi@isti.cnr.it">g.panichi@isti.cnr.it</a>
 *
 */
public class EquivalentRequestDialog extends Dialog {
	private ComputationId computationId;

	public EquivalentRequestDialog(ComputationId computationId) {
		super();
		Log.debug("EquivalentRequestDialog: " + computationId);
		this.computationId = computationId;
		init();
		create();
	}

	private void init() {
		setModal(true);
		setClosable(true);
		setHeadingText("Equivalent Get Request");
		setBodyBorder(true);
		setHideOnButtonClick(true);
		setPredefinedButtons(PredefinedButton.CLOSE);
		getButtonBar().setPack(BoxLayoutPack.CENTER);
	}

	private void create() {
		TextArea equivalentRequestArea = new TextArea();
		equivalentRequestArea.setHeight(200);
		equivalentRequestArea.setWidth(640);
		equivalentRequestArea.setValue(computationId.getEquivalentRequest());
		equivalentRequestArea.setReadOnly(true);
		add(equivalentRequestArea);
	}

}
