package org.gcube.portlets.widgets.ckan2zenodopublisher.shared.wrapped;

import java.io.Serializable;

import org.gcube.portlets.widgets.ckan2zenodopublisher.shared.ZenodoLicense;

/**
 * A license bean like the ckan's one.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR (francesco.mangiacrapa@isti.cnr.it)
 * 
 * Jan 13, 2020
 */
public class LicenseBean implements Serializable, ZenodoLicense{

	/**
	 * 
	 */
	private static final long serialVersionUID = 6618784269251750489L;
	private String id;
	private String title;
	private String url;
	
	/**
	 * Instantiates a new license bean.
	 */
	public LicenseBean() {
		super();
	}


	/**
	 * Instantiates a new license bean.
	 *
	 * @param id the id
	 * @param title the title
	 * @param url the url
	 */
	public LicenseBean(String id, String title, String url) {
		super();
		this.id = id;
		this.title = title;
		this.url = url;
	}

	
	
	public String getTitle() {
		return title;
	}


	public void setTitle(String title) {
		this.title = title;
	}


	public String getUrl() {
		return url;
	}


	public void setUrl(String url) {
		this.url = url;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}


	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		return obj.getClass().equals(this.getClass()) && ((LicenseBean)obj).getTitle().equals(this.title);
	}


	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("LicenseBean [id=");
		builder.append(id);
		builder.append(", title=");
		builder.append(title);
		builder.append(", url=");
		builder.append(url);
		builder.append("]");
		return builder.toString();
	}

}
