/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.widgets.fileupload.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.ProgressListener;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.fileupload.util.Streams;
import org.gcube.portlets.widgets.fileupload.server.UploadProgress;
import org.gcube.portlets.widgets.fileupload.server.UploadProgressInputStream;
import org.gcube.portlets.widgets.fileupload.server.UploadProgressListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UploadServlet
extends HttpServlet {
    private static final Logger _log = LoggerFactory.getLogger(UploadServlet.class);
    private static String UPLOAD_LOCATION = System.getProperty("java.io.tmpdir");

    public void init() {
        if (System.getenv("CATALINA_TMPDIR") != null && System.getenv("CATALINA_TMPDIR").compareTo("") != 0) {
            UPLOAD_LOCATION = System.getenv("CATALINA_TMPDIR");
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            this.uploadFile(request);
        }
        catch (FileUploadException fue) {
            throw new ServletException((Throwable)fue);
        }
    }

    private void uploadFile(HttpServletRequest request) throws FileUploadException, IOException {
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)request)) {
            throw new FileUploadException("ERROR: multipart request not found");
        }
        DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
        ServletFileUpload servletFileUpload = new ServletFileUpload((FileItemFactory)fileItemFactory);
        FileItemIterator fileItemIterator = servletFileUpload.getItemIterator(request);
        HttpSession session = request.getSession();
        UploadProgress uploadProgress = UploadProgress.getUploadProgress((HttpSession)session);
        while (fileItemIterator.hasNext()) {
            FileItemStream fileItemStream = fileItemIterator.next();
            String filePath = fileItemStream.getName();
            String fileName = filePath.substring(filePath.lastIndexOf(File.separator) + 1);
            File theRandomDir = new File(String.valueOf(UPLOAD_LOCATION) + File.separator + UUID.randomUUID().toString());
            theRandomDir.mkdir();
            _log.debug("Created temp upload directory in: " + theRandomDir);
            File file = new File(theRandomDir, fileName);
            UploadProgressListener uploadProgressListener = new UploadProgressListener(fileName, uploadProgress, file.getAbsolutePath());
            UploadProgressInputStream inputStream = new UploadProgressInputStream(fileItemStream.openStream(), (long)request.getContentLength());
            inputStream.addListener((ProgressListener)uploadProgressListener);
            Streams.copy((InputStream)inputStream, (OutputStream)new FileOutputStream(file), (boolean)true);
            _log.info("uploaded file " + file.getAbsolutePath());
        }
    }
}

