package org.gcube.portlets.widgets.fileupload.client.view;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;

public class ProgressBar extends Composite {
	
	private static final double COMPLETE_PERECENTAGE = 100d;
	private static final double START_PERECENTAGE = 0d;
	
	private static FancyProgressBarUiBinder uiBinder = GWT
			.create(FancyProgressBarUiBinder.class);

	interface FancyProgressBarUiBinder extends
	UiBinder<Widget, ProgressBar> {
	}

	public ProgressBar() {
		initWidget(uiBinder.createAndBindUi(this));
	}

	public void update(final int percentage) {
		if (percentage < START_PERECENTAGE || percentage > COMPLETE_PERECENTAGE) {
			throw new IllegalArgumentException("invalid value for percentage");
		}
		
		DOM.getElementById("upload-percent").setAttribute("style", "width: "+percentage+"%");
		DOM.getElementById("upload-percent-number").setInnerText(percentage+"%");
	
	}
}
