package org.gcube.portlets.user.vreappintegration.constants;

/**
 * Constants for VRE App Integration Portlet
 * 
 * ✅ Liferay 7.4 Best Practice:
 * - Centralized constants for portlet names and keys
 * - Used in OSGi component registration
 * - Follows Liferay 7.4 naming conventions
 */
public class VREAppIntegrationPortletKeys {

    /**
     * Portlet name constant used in OSGi component registration
     */
    public static final String VREAPPINTEGRATION = "org_gcube_portlets_user_vreappintegration_VREAppIntegrationPortlet";
    
    /**
     * Configuration action class name
     */
    public static final String CONFIGURATION_ACTION = "org.gcube.portlets.user.vreappintegration.action.VREAppConfigurationAction";
    
    /**
     * Default preferences keys
     */
    public static final String PREF_APP_URL = "appURL";
    public static final String PREF_APP_URL_TOKEN_PARAM = "appURLTokenParam";
    public static final String PREF_IFRAME_HEIGHT = "iFrameHeightParam";
    public static final String PREF_NEW_AUTH_VERSION = "newAuthVersionPreference";
    public static final String PREF_NEW_WINDOW = "newWindowPreference";
    public static final String PREF_APPLICATION_NAME = "applicationNameParam";
    
    /**
     * Default values
     */
    public static final String DEFAULT_IFRAME_HEIGHT = "1000";
    public static final String DEFAULT_APPLICATION_NAME = "the Application";
    public static final String DEFAULT_NEW_AUTH_VERSION = "false";
    public static final String DEFAULT_NEW_WINDOW = "false";
    public static final String DEFAULT_APP_URL_TOKEN_PARAM = "gcube-token";

}