/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.vremembers.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.bean.BeanLocatorException;
import com.liferay.portal.model.User;
import com.liferay.portal.service.UserLocalServiceUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.application.framework.core.session.SessionManager;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.portal.custom.communitymanager.OrganizationsUtil;
import org.gcube.portlets.user.vremembers.client.MembersService;
import org.gcube.portlets.user.vremembers.shared.BelongingUser;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.liferay.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.UserModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MembersServiceImpl
extends RemoteServiceServlet
implements MembersService {
    private static final Logger _log = LoggerFactory.getLogger(MembersServiceImpl.class);

    private ASLSession getASLSession() {
        String sessionID = this.getThreadLocalRequest().getSession().getId();
        String user = (String)this.getThreadLocalRequest().getSession().getAttribute("username");
        if (user == null) {
            _log.warn("USER IS NULL setting test.user and Running OUTSIDE PORTAL");
            user = this.getDevelopmentUser();
            SessionManager.getInstance().getASLSession(sessionID, user).setScope("/gcube");
        }
        return SessionManager.getInstance().getASLSession(sessionID, user);
    }

    public String getDevelopmentUser() {
        String user = "test.user";
        return user;
    }

    private boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (BeanLocatorException ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public ArrayList<BelongingUser> getOrganizationUsers() {
        ArrayList<BelongingUser> portalUsers = new ArrayList<BelongingUser>();
        String scope = this.getASLSession().getScope();
        if (scope == null) {
            return portalUsers;
        }
        try {
            if (this.isWithinPortal()) {
                LiferayUserManager um = new LiferayUserManager();
                LiferayGroupManager gm = new LiferayGroupManager();
                ScopeBean sb = new ScopeBean(scope);
                List users = null;
                if (sb.is(ScopeBean.Type.INFRASTRUCTURE)) {
                    users = um.listUsersByGroup(gm.getRootVO().getGroupId());
                } else if (sb.is(ScopeBean.Type.VRE)) {
                    String orgName = scope.substring(scope.lastIndexOf("/") + 1, scope.length());
                    users = um.listUsersByGroup(gm.getGroupId(orgName));
                } else {
                    _log.error("Error, you must be in SCOPE VRE OR INFRASTURCTURE, you are in VO SCOPE returning no users");
                    return portalUsers;
                }
                for (UserModel user : users) {
                    if (user.getScreenName().compareTo("test.user") == 0) continue;
                    String thumbnailURL = "";
                    User lifeUser = UserLocalServiceUtil.getUserByScreenName((long)OrganizationsUtil.getCompany().getCompanyId(), (String)user.getScreenName());
                    thumbnailURL = lifeUser.isMale() ? "/image/user_male_portrait?img_id=" + lifeUser.getPortraitId() : "/image/user_female_portrait?img_id=" + lifeUser.getPortraitId();
                    portalUsers.add(new BelongingUser(user.getScreenName(), user.getFullname(), thumbnailURL, lifeUser.getJobTitle(), lifeUser.getOpenId(), this.getUserProfileLink(user.getScreenName()), lifeUser.getPortraitId() != 0L));
                }
            } else {
                portalUsers.add(new BelongingUser("massimiliano.assante", "Test User #1", "1111", "headline", "isti", "", false));
                portalUsers.add(new BelongingUser("pino.assante", "Test Second User #2", "1111", "headline1", "istitution complex", "", false));
                portalUsers.add(new BelongingUser("pino.pino", "With Photo Third User", "1111", "hard worker", "acme Ltd", "", true));
                portalUsers.add(new BelongingUser("giorgi.giorgi", "Test Fourth User", "1111", "hard worker 3", "isti3", "", false));
                portalUsers.add(new BelongingUser("pinetti.giorgi", "Test Fifth User", "1111", "hard worker 4", "super acme Inc.", "", false));
                portalUsers.add(new BelongingUser("massimiliano.pinetti", "Test Sixth User", "1111", "hard worker the5th", "istiw", "", false));
                portalUsers.add(new BelongingUser("giorgi.assante", "Ninth Testing User", "1111", "hard worker the9th", "istiw9", "", false));
                portalUsers.add(new BelongingUser("massimiliano.giorgi", "Eighth Testing User", "1111", "hard worker the8th", "istiw56", "", false));
                portalUsers.add(new BelongingUser("giogio.giorgi", "Seventh Test User", "1111", "hard worker the7th", "istiw7", "", false));
                portalUsers.add(new BelongingUser("pino.pinetti", "Tenth Testing User Photoed", "1111", "hard worker the10th", "istiw777", "", true));
            }
        }
        catch (Exception e) {
            _log.error("Error in server get all contacts ", (Throwable)e);
        }
        Collections.sort(portalUsers);
        return portalUsers;
    }

    private String getUserProfileLink(String username) {
        return username.compareTo(this.getASLSession().getUsername()) != 0 ? "profile?" + new String(Base64.encodeBase64((byte[])"userIdentificationParameter".getBytes())) + "=" + new String(Base64.encodeBase64((byte[])username.getBytes())) : "/group/data-e-infrastructure-gateway/profile";
    }
}

