package org.gcube.portlets.user.uriresolvermanager.entity;

import java.util.Map;

/**
 * The Interface Resolver.
 *
 * @author Francesco Mangiacrapa at ISTI-CNR francesco.mangiacrapa@isti.cnr.it
 * 
 *         Nov 5, 2021
 */
public interface Resolver {

	/**
	 * Gets the resource name.
	 *
	 * @return the resource name
	 */
	public String getResourceName();

	/**
	 * Gets the entry name.
	 *
	 * @return the entry name
	 */
	public String getEntryName();

	/**
	 * Gets the link.
	 *
	 * @param baseURI the base URI
	 * @param parameters the parameters
	 * @return the link
	 * @throws Exception the exception
	 */
	public String getLink(String baseURI, Map<String, String> parameters) throws Exception;

}
