/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.uriresolvermanager.entity.ServiceParameter;
import org.gcube.portlets.user.uriresolvermanager.exception.IllegalArgumentException;
import org.gcube.portlets.user.uriresolvermanager.exception.UriResolverMapException;
import org.gcube.portlets.user.uriresolvermanager.readers.RuntimeResourceReader;
import org.gcube.portlets.user.uriresolvermanager.readers.UriResolverMapReader;
import org.gcube.portlets.user.uriresolvermanager.util.UrlEncoderUtil;
import org.gcube.portlets.user.urlshortener.UrlShortener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriResolverManager {
    public static int RESET_DELAY;
    public static int RESET_TIME;
    private UriResolverMapReader uriResolverMapReader;
    private Map<String, String> applicationTypes;
    private String scope;
    private String applicationType;
    private RuntimeResourceReader reader;
    private int usingReader = 0;
    public static final Logger logger;

    public synchronized void lockReader() {
        ++this.usingReader;
    }

    public synchronized void releaseReader() {
        --this.usingReader;
    }

    public synchronized int countReaders() {
        return this.usingReader;
    }

    public UriResolverManager(String applicationType) throws UriResolverMapException, IllegalArgumentException {
        try {
            this.scope = ScopeProvider.instance.get();
            if (this.scope == null) {
                throw new UriResolverMapException("Scope is null, set scope provider!");
            }
            this.uriResolverMapReader = new UriResolverMapReader(this.scope);
            this.applicationTypes = this.uriResolverMapReader.getApplicationTypes();
        }
        catch (Exception e) {
            throw new UriResolverMapException("Map Application Type - Resources not found in IS");
        }
        if (!this.applicationTypes.containsKey(applicationType)) {
            throw new IllegalArgumentException("Application type '" + applicationType + "' not found in Application Types: " + this.getApplicationTypes());
        }
        this.applicationType = applicationType;
        this.reloadRuntimeResourceParameter(RESET_DELAY, RESET_TIME);
    }

    public String getLink(Map<String, String> parameters, boolean shortLink) throws IllegalArgumentException, UriResolverMapException {
        String link;
        String resourceName = this.applicationTypes.get(this.applicationType);
        if (parameters == null) {
            throw new IllegalArgumentException("Input Map parameters is null");
        }
        try {
            this.lockReader();
            if (this.reader == null) {
                logger.info("Runtime Resource Reader is null, istancing...");
                ScopeProvider.instance.set(this.scope);
                this.reader = new RuntimeResourceReader(this.scope, resourceName);
            }
            List<ServiceParameter> resourceParameters = this.reader.getServiceParameters();
            for (ServiceParameter serviceParameter : resourceParameters) {
                if (!serviceParameter.isMandatory() || parameters.containsKey(serviceParameter.getKey())) continue;
                throw new IllegalArgumentException("Mandatory service key (parameter) '" + serviceParameter.getKey() + "' not found into input map");
            }
            String baseURI = this.reader.getServiceBaseURI();
            this.releaseReader();
            String params = UrlEncoderUtil.encodeQuery(parameters);
            link = baseURI + "?" + params;
            logger.info("Created HTTP URI request (link): " + link);
            if (shortLink) {
                try {
                    logger.info("Shortner start..");
                    UrlShortener shortener = new UrlShortener(this.scope);
                    link = shortener.shorten(link);
                    logger.info("Shorted link is: " + link);
                }
                catch (Exception e) {
                    logger.warn("An error occurred on shortener the link ", (Throwable)e);
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error("Uri Resolver error: ", (Throwable)e);
            throw new UriResolverMapException("Uri Resolver error: " + e.getMessage());
        }
        return link;
    }

    public Set<String> getApplicationTypes() {
        return this.applicationTypes.keySet();
    }

    public Map<String, String> getCapabilities() {
        return this.applicationTypes;
    }

    public void reloadRuntimeResourceParameter(long delay, long period) {
        Timer timer = new Timer(true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                logger.info("Timer Reset Runtime Resource running..");
                int counters = UriResolverManager.this.countReaders();
                if (counters == 0) {
                    logger.info("Reader not locked, resetting");
                    UriResolverManager.this.reader = null;
                } else {
                    logger.info("Reader locked, counters is/are:" + counters + ", skipping");
                }
            }
        }, delay, period);
    }

    static {
        RESET_TIME = RESET_DELAY = 600000;
        logger = LoggerFactory.getLogger(UriResolverManager.class);
    }
}

