/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.uriresolvermanager.readers;

import java.util.ArrayList;
import java.util.List;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.resources.gcore.utils.Group;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.portlets.user.uriresolvermanager.entity.ServiceParameter;
import org.gcube.portlets.user.uriresolvermanager.util.ScopeUtil;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuntimeResourceReader {
    public static final Logger logger = LoggerFactory.getLogger(RuntimeResourceReader.class);
    public List<ServiceParameter> serviceParameters;
    private String resourceName;
    private String scope;
    private String serviceBaseURI;

    public RuntimeResourceReader(String scope, String resourceName) throws Exception {
        this.scope = scope;
        this.resourceName = resourceName;
        this.readResource(scope, resourceName);
    }

    protected String readResource(String scope, String resourceName) throws Exception {
        try {
            logger.info("Tentative read resource: " + resourceName + ", scope: " + scope);
            this.resourceName = resourceName;
            this.scope = scope;
            String infraName = ScopeUtil.getInfrastructureNameFromScope(scope);
            logger.info("Instancing root scope: " + infraName);
            ScopeProvider.instance.set(infraName);
            XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
            query.addCondition("$resource/Profile/Name/string() eq '" + resourceName + "'");
            DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
            List r = client.submit((Query)query);
            if (r == null || r.isEmpty()) {
                throw new Exception("Cannot retrieve the runtime resource: " + resourceName);
            }
            ServiceEndpoint se = (ServiceEndpoint)r.get(0);
            if (se.profile() == null) {
                throw new Exception("IS profile is null for resource: " + resourceName);
            }
            Group accessPoints = se.profile().accessPoints();
            if (accessPoints.size() == 0) {
                throw new Exception("Accesspoint in resource " + resourceName + " not found");
            }
            ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)accessPoints.iterator().next();
            Group properties = ap.properties();
            if (properties.size() == 0) {
                logger.warn("Properties in resource " + resourceName + " not found");
            } else {
                this.serviceParameters = new ArrayList<ServiceParameter>(properties.size());
                for (ServiceEndpoint.Property prop : properties) {
                    this.serviceParameters.add(new ServiceParameter(prop.value(), true));
                }
            }
            logger.info("returning URI: " + ap.address());
            this.serviceBaseURI = ap.address();
            return this.serviceBaseURI;
        }
        catch (Exception e) {
            logger.error("Sorry, an error occurred on reading the resource " + resourceName + "Runtime Reosurces", (Throwable)e);
            throw new Exception("Sorry, an error occurred on reading the resource " + resourceName + "Runtime Reosurces");
        }
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public List<ServiceParameter> getServiceParameters() {
        return this.serviceParameters;
    }

    public String getServiceBaseURI() {
        return this.serviceBaseURI;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RuntimeResourceReader [serviceParameters=");
        builder.append(this.serviceParameters);
        builder.append(", resourceName=");
        builder.append(this.resourceName);
        builder.append(", scope=");
        builder.append(this.scope);
        builder.append(", serviceBaseURI=");
        builder.append(this.serviceBaseURI);
        builder.append("]");
        return builder.toString();
    }
}

