/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.templates.client.presenter;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.RichTextArea;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.d4sreporting.common.client.uicomponents.ReportUIComponent;
import org.gcube.portlets.d4sreporting.common.client.uicomponents.richtext.RichTextToolbar;
import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.shared.Metadata;
import org.gcube.portlets.d4sreporting.common.shared.Model;
import org.gcube.portlets.user.templates.client.HeaderBar;
import org.gcube.portlets.user.templates.client.Templates;
import org.gcube.portlets.user.templates.client.TitleBar;
import org.gcube.portlets.user.templates.client.WorkspacePanel;
import org.gcube.portlets.user.templates.client.components.AttributeArea;
import org.gcube.portlets.user.templates.client.components.AttributeDialog;
import org.gcube.portlets.user.templates.client.components.BasicTextArea;
import org.gcube.portlets.user.templates.client.components.ClientRepeatableSequence;
import org.gcube.portlets.user.templates.client.components.CommentArea;
import org.gcube.portlets.user.templates.client.components.Coords;
import org.gcube.portlets.user.templates.client.components.D4sRichTextarea;
import org.gcube.portlets.user.templates.client.components.DefaultArea;
import org.gcube.portlets.user.templates.client.components.DoubleColumnPanel;
import org.gcube.portlets.user.templates.client.components.DroppingArea;
import org.gcube.portlets.user.templates.client.components.FakeTextArea;
import org.gcube.portlets.user.templates.client.components.GenericTable;
import org.gcube.portlets.user.templates.client.components.GroupingDelimiterArea;
import org.gcube.portlets.user.templates.client.components.GroupingInnerArea;
import org.gcube.portlets.user.templates.client.components.ImageArea;
import org.gcube.portlets.user.templates.client.components.InstructionArea;
import org.gcube.portlets.user.templates.client.dialogs.RepeatSequenceDialog;
import org.gcube.portlets.user.templates.client.dialogs.TablePropertyDialog;
import org.gcube.portlets.user.templates.client.dialogs.ToolboxDialog;
import org.gcube.portlets.user.templates.client.model.TemplateComponent;
import org.gcube.portlets.user.templates.client.model.TemplateModel;
import org.gcube.portlets.user.templates.client.model.TemplateSection;
import org.gcube.portlets.user.templates.client.presenter.CommonCommands;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

public class Presenter {
    private WorkspacePanel wp;
    private HeaderBar header;
    private TitleBar titleBar;
    private String currentUser;
    private String currentScope;
    int counter = 1;
    private CommonCommands commonCommands;
    private TemplateModel model;
    private int currFocus;
    RichTextToolbar currentSelectedToolbar;
    RichTextArea currentSelectedTextArea;
    private ToolboxDialog tbPanel;
    private ReportUIComponent selectedComponent;

    public Presenter(TemplateModel model) {
        this.model = model;
        this.wp = new WorkspacePanel(this.model, this);
        1 callback = new /* Unavailable Anonymous Inner Class!! */;
        model.getModelService().getUserAndScope((AsyncCallback)callback);
        this.commonCommands = new CommonCommands(this);
        this.showToolbox();
    }

    public void showToolbox() {
        this.tbPanel = new ToolboxDialog(this, 800, this.wp.getAbsoluteTop() + 50);
        this.tbPanel.show();
    }

    private HashMap<String, Command> getCommands() {
        HashMap<String, Command> toReturn = new HashMap<String, Command>();
        2 newTemplate = new /* Unavailable Anonymous Inner Class!! */;
        toReturn.put("save", this.commonCommands.saveTemplate);
        toReturn.put("newdoc", (Command)newTemplate);
        toReturn.put("open_template", this.commonCommands.openTemplate);
        toReturn.put("importing", this.commonCommands.importTemplateCommand);
        toReturn.put("insertImage", this.commonCommands.insertImage);
        toReturn.put("pickColor", this.commonCommands.pickColor);
        return toReturn;
    }

    public void addNewPage() {
        this.seekLastPage();
        this.cleanWorkspace();
        this.model.insertNewPage();
        this.titleBar.setPageDisplayer(this.model.getCurrentPage(), this.model.getTotalPages());
        this.titleBar.hideNextButton();
        this.titleBar.showPrevButton();
        this.setCurrCursorPos(-1);
        this.addFakeTextArea(0, false);
    }

    public void seekLastPage() {
        while (this.model.getCurrentPage() != this.model.getTotalPages()) {
            this.nextPageButtonClicked();
        }
    }

    public void seekSection(int sect2Seek) {
        this.loadFirstSection();
        while (this.model.getCurrentPage() != sect2Seek) {
            this.nextPageButtonClicked();
        }
    }

    public void addTextToolBar() {
        RichTextToolbar rtbar = new RichTextToolbar(new RichTextArea(), false, this.getCommands(), false);
        SimplePanel deco = new SimplePanel();
        rtbar.setEnabled(false);
        deco.add((Widget)rtbar);
        deco.setSize("100%", "25");
        rtbar.setWidth("100%");
        Templates.get().getToolbarPanel().add((Widget)deco);
    }

    public void changeTemplateName(String newName) {
        this.model.setTemplateName(newName);
        Templates.get().getTitleHeader().setTemplateName(newName);
    }

    public void setEditedOnBy(Date date, String username) {
        Templates.get().getTitleHeader().setEditedOnBy(date, username);
    }

    public TitleBar getTitleBar() {
        return this.titleBar;
    }

    public void setTitleBar(TitleBar titleBar) {
        this.titleBar = titleBar;
    }

    public void cleanAll() {
        this.model = new TemplateModel();
        this.header.setModel(this.model);
        this.wp.setModel(this.model);
        this.cleanWorkspace();
        this.titleBar.hideNextButton();
        this.titleBar.hidePrevButton();
        this.titleBar.setTemplateName(this.model.getTemplateName());
        this.titleBar.setPageDisplayer(this.model.getCurrentPage(), this.model.getTotalPages());
        this.titleBar.clearEditedOnBy();
    }

    public void cleanWorkspace() {
        this.wp.getMainLayout().clear();
        Templates.get().getScrollerPanel().setScrollPosition(0);
    }

    public void discardCurrentSection() {
        if (this.model.getTotalPages() == 1) {
            Window.alert((String)"Cannot discard section, need ad least 2");
        } else {
            boolean result = Window.confirm((String)("Are you sure you want to discard section number " + this.model.getCurrentPage() + "?"));
            if (result) {
                TemplateSection removed = this.model.discardSection(this.model.getCurrentPage());
                if (removed == null) {
                    GWT.log((String)"REMOVED NOTHING", null);
                } else {
                    GWT.log((String)("REMOVED " + removed.getAllComponents().size()), null);
                }
                this.loadFirstSection();
            }
        }
    }

    public void enableTextToolBar(RichTextArea d4sArea) {
        RichTextToolbar rtbar;
        this.currentSelectedToolbar = rtbar = new RichTextToolbar(d4sArea, false, this.getCommands(), false);
        this.currentSelectedTextArea = d4sArea;
        rtbar.setEnabled(true);
        Templates.get().getToolbarPanel().clear();
        SimplePanel deco = new SimplePanel();
        deco.add((Widget)rtbar);
        deco.setSize("100%", "25");
        rtbar.setWidth("100%");
        Templates.get().getToolbarPanel().add((Widget)deco);
    }

    public void importSection(Model toLoad, int sectionNoToimport, int beforeSection, boolean asLastSection) {
        this.model.importSectionInModel(this, toLoad, sectionNoToimport, beforeSection, asLastSection);
        if (asLastSection) {
            this.seekLastPage();
        } else {
            this.seekSection(beforeSection);
        }
        Window.alert((String)"Importing Complete");
    }

    private int generateRandom() {
        return (int)(Math.random() * 10000.0) + 1;
    }

    public HeaderBar getHeader() {
        return this.header;
    }

    public TemplateModel getModel() {
        return this.model;
    }

    public WorkspacePanel getWp() {
        return this.wp;
    }

    public void openGroupingDialog() {
        RepeatSequenceDialog dlg = new RepeatSequenceDialog(this);
        dlg.show();
        dlg.center();
    }

    public void insertGroup(ComponentType ... types) {
        Coords start = this.getInsertionPoint();
        ClientRepeatableSequence repSeq = new ClientRepeatableSequence(this, this.model, types);
        start = this.getInsertionPoint();
        int index = this.wp.addComponentToLayout((Widget)repSeq, false);
        TemplateComponent repSequence = new TemplateComponent(this.model, start.getX(), start.getY(), 700, repSeq.getHeight(), this.model.getCurrentPage(), repSeq.getType(), "", (Widget)repSeq);
        this.model.addComponentToModel(repSequence, index);
        start = this.getInsertionPoint();
        int height = 30;
        this.addFakeTextArea(start.getY() + height, false);
        this.model.storeInSession();
    }

    public TemplateComponent getGroupInnerArea() {
        Coords start = this.getInsertionPoint();
        GroupingInnerArea spacer = new GroupingInnerArea();
        return new TemplateComponent(this.model, 0, start.getY(), 750, 25, this.model.getCurrentPage(), ComponentType.REPEAT_SEQUENCE_INNER, "", (Widget)spacer);
    }

    public TemplateComponent createDroppingArea(ComponentType type, int width, int height, boolean hideControls) {
        Coords start = this.getInsertionPoint();
        DroppingArea imageDropping = new DroppingArea(this, start.getX(), start.getY(), width, height, false);
        if (hideControls) {
            imageDropping.hideCloseButton();
        }
        String paramName = "image-" + this.generateRandom();
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), ComponentType.DYNA_IMAGE, paramName, (Widget)imageDropping);
        return toAdd;
    }

    public void insertDroppingArea(ComponentType type, int width, int height) {
        TemplateComponent toAdd = this.createDroppingArea(type, width, height, false);
        ReportUIComponent droppingImage = (ReportUIComponent)toAdd.getContent();
        int toInsert = this.wp.addComponentToLayout((Widget)droppingImage, false);
        this.model.addComponentToModel(toAdd, toInsert);
        Coords start = this.getInsertionPoint();
        this.addFakeTextArea(start.getY() + height, false);
    }

    public TemplateComponent addPageBreak() {
        Coords start = this.getInsertionPoint();
        int width = 700;
        int height = 30;
        DefaultArea imgToPlace = new DefaultArea(ComponentType.PAGEBREAK, this, start.getX(), start.getY(), width, height);
        imgToPlace.addStyleName("pagebreak");
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), ComponentType.PAGEBREAK, "", (Widget)imgToPlace, false);
        int toInsert = this.wp.addComponentToLayout((Widget)imgToPlace, false);
        this.model.addComponentToModel(toAdd, toInsert);
        this.addFakeTextArea(start.getY() + height, false);
        return toAdd;
    }

    public TemplateComponent createStaticTextArea(ComponentType type, int width, int height, boolean hideControls) {
        Coords start = this.getInsertionPoint();
        Object textArea = null;
        textArea = type != ComponentType.BODY ? new BasicTextArea(type, this, start.getX(), start.getY(), width, height) : new D4sRichTextarea(type, this, start.getX(), start.getY(), width, height);
        if (hideControls) {
            textArea.hideCloseButton();
        }
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), type, "", (Widget)textArea);
        return toAdd;
    }

    public void insertStaticTextArea(ComponentType type, int width, int height) {
        TemplateComponent toAdd = this.createStaticTextArea(type, width, height, false);
        ReportUIComponent textArea = (ReportUIComponent)toAdd.getContent();
        int index = this.wp.addComponentToLayout((Widget)textArea, false);
        this.model.addComponentToModel(toAdd, index);
        Coords start = this.getInsertionPoint();
        this.addFakeTextArea(start.getY() + height, false);
    }

    public TemplateComponent createTable(ComponentType type, int rows, int cols, boolean hideControls) {
        Coords start = this.getInsertionPoint();
        GenericTable table = new GenericTable(rows, cols, type, this, start.getX(), start.getY(), 700, 200, hideControls);
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), 700, 50, this.model.getCurrentPage(), type, "", (Widget)table);
        return toAdd;
    }

    public void insertTable(ComponentType type, int rows, int cols) {
        Coords start = this.getInsertionPoint();
        TemplateComponent toAdd = this.createTable(type, rows, cols, false);
        ReportUIComponent table = (ReportUIComponent)toAdd.getContent();
        int index = this.wp.addComponentToLayout((Widget)table, false);
        this.model.addComponentToModel(toAdd, index);
        this.addFakeTextArea(start.getY() + table.getOffsetHeight(), false);
    }

    public TemplateComponent addCommentArea(int width, int height, boolean isGrouped) {
        Coords start = this.getInsertionPoint();
        CommentArea ca = new CommentArea(this, start.getX(), start.getY(), width, height);
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), ca.getType(), "", (Widget)ca);
        int index = this.wp.addComponentToLayout((Widget)ca, false);
        ca.selectText();
        this.model.addComponentToModel(toAdd, index);
        this.addFakeTextArea(start.getY() + height, false);
        return toAdd;
    }

    public TemplateComponent addInstructionArea(int width, int height, boolean isGrouped) {
        Coords start = this.getInsertionPoint();
        InstructionArea ca = new InstructionArea(this, start.getX(), start.getY(), width, height);
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), ca.getType(), "", (Widget)ca);
        int index = this.wp.addComponentToLayout((Widget)ca, false);
        ca.selectText();
        this.model.addComponentToModel(toAdd, index);
        this.addFakeTextArea(start.getY() + height, false);
        return toAdd;
    }

    public TemplateComponent createAttributArea(int width, int height, String name, String[] values, boolean useCheckBox, boolean displayBlock, boolean hideControls) {
        Coords start = this.getInsertionPoint();
        AttributeArea ca = null;
        ca = useCheckBox ? new AttributeArea(this, start.getX(), start.getY(), width, height, name, values, ComponentType.ATTRIBUTE_MULTI) : new AttributeArea(this, start.getX(), start.getY(), width, height, name, values, ComponentType.ATTRIBUTE_UNIQUE);
        Metadata mdDisplay = new Metadata();
        mdDisplay.setAttribute("display");
        mdDisplay.setValue(displayBlock ? "block" : "inline");
        ArrayList<Metadata> toPass = new ArrayList<Metadata>();
        toPass.add(mdDisplay);
        if (hideControls) {
            ca.hideCloseButton();
        }
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), ca.getType(), "", (Widget)ca, toPass);
        ca.setComponent(toAdd);
        return toAdd;
    }

    public void addAttributArea(int width, int height, String name, String[] values, boolean useCheckBox, boolean displayBlock) {
        TemplateComponent toAdd = this.createAttributArea(width, height, name, values, useCheckBox, displayBlock, false);
        AttributeArea ca = (AttributeArea)toAdd.getContent();
        int index = this.wp.addComponentToLayout((Widget)ca, false);
        this.model.addComponentToModel(toAdd, index);
        Coords start = this.getInsertionPoint();
        this.addFakeTextArea(start.getY() + height, false);
    }

    public void openAttributeDialog(int width, int height, boolean useCheckBox) {
        AttributeDialog dialog = new AttributeDialog(this, width, height, useCheckBox);
        dialog.show();
    }

    public void updateWidgetIndicesInModel(FlowPanel widgetContainer) {
        int widgetsNo = widgetContainer.getWidgetCount();
        for (int i = 0; i < widgetsNo; ++i) {
            Widget toUpdate = widgetContainer.getWidget(i);
            this.model.updateModelComponentIndex(toUpdate, i);
        }
    }

    public void insertStaticImage(Coords start, int width, int height, ImageArea imgToPlace, boolean isDoubleColLayout) {
        GWT.log((String)("Adding IMAGE " + start.getX() + " y=" + start.getY()), null);
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), ComponentType.STATIC_IMAGE, "", (Widget)imgToPlace, isDoubleColLayout);
        int index = this.wp.addComponentToLayout((Widget)imgToPlace, false);
        this.model.addComponentToModel(toAdd, index);
        this.addFakeTextArea(start.getY() + height, false);
    }

    public void insertPlaceHolder(ComponentType type, int width, int height) {
        Coords start = this.getInsertionPoint();
        DefaultArea imgToPlace = new DefaultArea(type, this, start.getX(), start.getY(), width, height);
        if (type == ComponentType.TOC) {
            imgToPlace.addStyleName("tocArea");
        } else if (type == ComponentType.TIME_SERIES) {
            imgToPlace.addStyleName("timeseriesArea");
        } else if (type == ComponentType.BODY_TABLE_IMAGE) {
            imgToPlace.addStyleName("text-table-image");
        } else {
            imgToPlace.addStyleName("biblioArea");
        }
        TemplateComponent toAdd = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), type, "", (Widget)imgToPlace, false);
        int index = this.wp.addComponentToLayout((Widget)imgToPlace, false);
        this.model.addComponentToModel(toAdd, index);
        this.addFakeTextArea(start.getY() + height, false);
    }

    public void showTablePopup(ComponentType type, int width, int height) {
        TablePropertyDialog dlg = new TablePropertyDialog(this);
        dlg.show();
    }

    public int getSelectedIndex() {
        return this.currFocus;
    }

    public void setCurrCursorPos(int index) {
        this.currFocus = index;
    }

    public Coords getInsertionPoint() {
        int y = this.getSelectedIndex();
        return new Coords(25, y);
    }

    public Widget addFakeTextArea(int y, boolean doubleInsterted) {
        GWT.log((String)("Setting on" + y), null);
        FakeTextArea toAdd = new FakeTextArea(this.counter++, this);
        TemplateComponent tc = new TemplateComponent(this.model, 0, y, 750, 25, this.model.getCurrentPage(), ComponentType.FAKE_TEXTAREA, "", (Widget)toAdd);
        int index = this.wp.addComponentToLayout((Widget)toAdd, true);
        if (doubleInsterted) {
            this.model.addComponentToModel(tc, index + 1);
        } else {
            this.model.addComponentToModel(tc, index);
        }
        this.model.storeInSession();
        return toAdd;
    }

    public Widget addGroupingStart(int y) {
        GWT.log((String)("Setting on" + y), null);
        FakeTextArea toAdd = new FakeTextArea(this.counter++, this);
        TemplateComponent tc = new TemplateComponent(this.model, 0, y, 750, 25, this.model.getCurrentPage(), ComponentType.REPEAT_SEQUENCE_DELIMITER, "", (Widget)toAdd);
        int index = this.wp.addComponentToLayout((Widget)toAdd, true);
        this.model.addComponentToModel(tc, index);
        this.model.storeInSession();
        return toAdd;
    }

    public void insertDoubleColumnItems(ReportUIComponent leftItem, ReportUIComponent rightItem) {
        Coords start = this.getInsertionPoint();
        int width = 700;
        int height = 100;
        TemplateComponent toAddLeft = new TemplateComponent(this.model, start.getX(), start.getY(), width, height, this.model.getCurrentPage(), leftItem.getType(), "", (Widget)leftItem, true);
        TemplateComponent toAddRight = new TemplateComponent(this.model, start.getX() + 500, start.getY(), width, height, this.model.getCurrentPage(), rightItem.getType(), "", (Widget)rightItem, true);
        DoubleColumnPanel toAdd = new DoubleColumnPanel((Widget)leftItem, (Widget)rightItem);
        int index = this.wp.addComponentToLayout((Widget)toAdd, false);
        this.model.addComponentToModel(toAddLeft, index);
        index = this.wp.addComponentToLayout((Widget)new HTML(), false);
        this.model.addComponentToModel(toAddRight, index);
        this.addFakeTextArea(start.getY() + height, false);
    }

    public void moveWidget(Widget toMove, int left, int top) {
        this.wp.moveWidget(toMove, left, top);
    }

    public void nextPageButtonClicked() {
        this.cleanWorkspace();
        this.model.setCurrentPage(this.model.getCurrentPage() + 1);
        this.titleBar.setPageDisplayer(this.model.getCurrentPage(), this.model.getTotalPages());
        this.placeTemplatePageElements(this.model.getCurrentPage());
        if (this.model.getCurrentPage() == this.model.getTotalPages()) {
            this.titleBar.hideNextButton();
        } else {
            this.titleBar.showNextButton();
        }
        if (this.model.getCurrentPage() == 1) {
            this.titleBar.hidePrevButton();
        } else {
            this.titleBar.showPrevButton();
        }
    }

    public void openTemplate(String templateToOpen, String TemplateObjectID) {
        this.model.getModelService().readModel(templateToOpen, TemplateObjectID, false, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadModel(Model toLoad) {
        this.cleanAll();
        this.model.loadModel(toLoad, this);
        this.wp.setModel(this.model);
        this.titleBar.setTemplateName(this.model.getTemplateName());
        this.titleBar.setPageDisplayer(this.model.getCurrentPage(), this.model.getTotalPages());
        this.setEditedOnBy(this.model.getLastEdit(), this.model.getLastEditBy());
        int currPage = this.model.getCurrentPage();
        GWT.log((String)("READ CURR PAGE" + currPage), null);
        this.placeTemplatePageElements(currPage);
        if (currPage < this.model.getTotalPages()) {
            this.titleBar.showNextButton();
        }
        if (currPage > 1) {
            this.titleBar.showPrevButton();
        }
    }

    private void loadFirstSection() {
        this.cleanWorkspace();
        this.titleBar.hideNextButton();
        this.titleBar.hidePrevButton();
        this.model.setCurrentPage(1);
        this.wp.getMainLayout().setStyleName("templateFrame");
        this.wp.getMainLayout().addStyleName("position-relative");
        this.titleBar.setTemplateName(this.model.getTemplateName());
        this.titleBar.setPageDisplayer(this.model.getCurrentPage(), this.model.getTotalPages());
        int currPage = this.model.getCurrentPage();
        GWT.log((String)("READ CURR PAGE" + currPage), null);
        this.placeTemplatePageElements(currPage);
        if (currPage < this.model.getTotalPages()) {
            this.titleBar.showNextButton();
        }
        if (currPage > 1) {
            this.titleBar.showPrevButton();
        }
    }

    public void placeTemplatePageElements(int pageNo) {
        this.setCurrCursorPos(-1);
        if (this.model.getSectionComponent(pageNo) != null) {
            List pageElems = this.model.getSectionComponent(pageNo);
            for (TemplateComponent component : pageElems) {
                GWT.log((String)("Reading component.. " + component.getType() + " locked?" + component.isLocked()), null);
                int uiX = component.getX();
                int uiY = component.getY();
                switch (4.$SwitchMap$org$gcube$portlets$d4sreporting$common$shared$ComponentType[component.getType().ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        BasicTextArea textArea = (BasicTextArea)component.getContent();
                        textArea.get().setTop(uiY);
                        textArea.get().setLeft(uiX);
                        this.wp.addComponentToLayoutSystem((Widget)textArea, component.isDoubleColLayout());
                        break;
                    }
                    case 8: {
                        D4sRichTextarea textArea2 = (D4sRichTextarea)component.getContent();
                        textArea2.get().setTop(uiY);
                        textArea2.get().setLeft(uiX);
                        this.wp.addComponentToLayoutSystem((Widget)textArea2, component.isDoubleColLayout());
                        break;
                    }
                    case 9: {
                        ImageArea imgToPlace = (ImageArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)imgToPlace, component.isDoubleColLayout());
                        break;
                    }
                    case 10: {
                        DroppingArea imageDropping = (DroppingArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)imageDropping, component.isDoubleColLayout());
                        break;
                    }
                    case 11: {
                        FakeTextArea toAdd = (FakeTextArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)toAdd, component.isDoubleColLayout());
                        break;
                    }
                    case 12: {
                        DefaultArea dp = (DefaultArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)dp, component.isDoubleColLayout());
                        break;
                    }
                    case 13: {
                        DefaultArea bo = (DefaultArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)bo, component.isDoubleColLayout());
                        break;
                    }
                    case 14: {
                        DefaultArea dp2 = (DefaultArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)dp2, component.isDoubleColLayout());
                    }
                    case 15: {
                        DefaultArea dp3 = (DefaultArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)dp3, component.isDoubleColLayout());
                        break;
                    }
                    case 16: {
                        DefaultArea dp5 = (DefaultArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)dp5, component.isDoubleColLayout());
                        break;
                    }
                    case 17: {
                        GenericTable gt = (GenericTable)component.getContent();
                        GWT.log((String)("Reading TABLE rows: " + gt.getRowsNo() + " cols: " + gt.getCols()));
                        this.wp.addComponentToLayoutSystem((Widget)gt, component.isDoubleColLayout());
                        break;
                    }
                    case 18: {
                        CommentArea ca = (CommentArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)ca, false);
                        break;
                    }
                    case 19: 
                    case 20: 
                    case 21: {
                        AttributeArea at = (AttributeArea)component.getContent();
                        at.setComponent(component);
                        this.wp.addComponentToLayoutSystem((Widget)at, false);
                        break;
                    }
                    case 22: {
                        InstructionArea in = (InstructionArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)in, false);
                        break;
                    }
                    case 23: {
                        GroupingDelimiterArea gpa = (GroupingDelimiterArea)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)gpa, component.isDoubleColLayout());
                        break;
                    }
                    case 24: {
                        ClientRepeatableSequence rps = (ClientRepeatableSequence)component.getContent();
                        this.wp.addComponentToLayoutSystem((Widget)rps, component.isDoubleColLayout());
                    }
                }
            }
        }
    }

    public void prevPageButtonClicked() {
        this.cleanWorkspace();
        this.model.setCurrentPage(this.model.getCurrentPage() - 1);
        this.titleBar.setPageDisplayer(this.model.getCurrentPage(), this.model.getTotalPages());
        this.placeTemplatePageElements(this.model.getCurrentPage());
        if (this.model.getCurrentPage() == this.model.getTotalPages()) {
            this.titleBar.hideNextButton();
        } else {
            this.titleBar.showNextButton();
        }
        if (this.model.getCurrentPage() == 1) {
            this.titleBar.hidePrevButton();
        } else {
            this.titleBar.showPrevButton();
        }
    }

    public boolean removeTemplateComponent(Widget toRemove) {
        GWT.log((String)"removeTemplateComponent");
        TemplateComponent toCheck = this.checkIfDoubleColLayout(toRemove);
        if (toCheck.isDoubleColLayout()) {
            if (Window.confirm((String)"This will remove both area, do you want to proceed?")) {
                TemplateComponent comp = this.model.removeComponentFromModel(toRemove);
                DoubleColumnPanel dpanel = (DoubleColumnPanel)this.wp.getMainLayout().getWidget(this.wp.getMainLayout().getWidgetIndex(toRemove.getParent()));
                Widget otherOne = dpanel.getTheOtherOne(toRemove);
                this.model.removeComponentFromModel(otherOne);
                boolean w = this.wp.removeComponentFromLayout(toRemove.getParent());
                return w;
            }
            return false;
        }
        TemplateComponent comp = this.model.removeComponentFromModel(toRemove);
        boolean w = this.wp.removeComponentFromLayout(toRemove);
        return w;
    }

    public TemplateComponent checkIfDoubleColLayout(Widget toRemove) {
        int tcPage = this.model.getCurrentPage();
        List templateElements = this.model.getSectionComponent(tcPage);
        TemplateComponent toReturn = null;
        for (int i = 0; i < templateElements.size(); ++i) {
            TemplateComponent tc = (TemplateComponent)templateElements.get(i);
            if (!tc.getContent().equals(toRemove)) continue;
            return tc;
        }
        return toReturn;
    }

    public void storeChangeInSession(Widget toChange) {
        this.model.storeInSession();
    }

    public void repositionModelComponents(Widget toRepos, int newX, int newY) {
        this.model.repositionModelComponent(toRepos, newX, newY);
    }

    public void resizeTemplateComponent(Widget toResize, int newWidth, int newHeight) {
        this.wp.resizeWidget(toResize, newWidth, newHeight);
        this.model.resizeModelComponent(toResize, newWidth, newHeight);
    }

    public void resizeTemplateComponentInView(Widget toResize, int newWidth, int newHeight) {
        this.wp.resizeWidget(toResize, newWidth, newHeight);
    }

    public void lockComponent(Widget toLock, boolean locked) {
        this.model.lockComponent(toLock, locked);
    }

    public void resizeTemplateComponentInModel(Widget toResize, int newWidth, int newHeight) {
        this.model.resizeModelComponent(toResize, newWidth, newHeight);
    }

    public void saveTemplate(String basketidToSaveIn) {
        this.model.serializeModel(basketidToSaveIn);
    }

    public void setHeader(HeaderBar header) {
        this.header = header;
    }

    public void setModel(TemplateModel templateModel) {
        this.model = templateModel;
    }

    public void setWp(WorkspacePanel wp) {
        this.wp = wp;
    }

    public String getCurrentScope() {
        return this.currentScope;
    }

    public String getCurrentUser() {
        return this.currentUser;
    }

    public WorkspacePanel getWorkSpacePanel() {
        return this.wp;
    }

    public RichTextToolbar getCurrentSelected() {
        return this.currentSelectedToolbar;
    }

    public RichTextArea getCurrentSelectedTextArea() {
        return this.currentSelectedTextArea;
    }

    public ReportUIComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public void setSelectedComponent(ReportUIComponent selectedComponent) {
        this.selectedComponent = selectedComponent;
    }

    static /* synthetic */ String access$002(Presenter x0, String x1) {
        x0.currentUser = x1;
        return x0.currentUser;
    }

    static /* synthetic */ String access$102(Presenter x0, String x1) {
        x0.currentScope = x1;
        return x0.currentScope;
    }

    static /* synthetic */ void access$200(Presenter x0, Model x1) {
        x0.loadModel(x1);
    }

    static /* synthetic */ WorkspacePanel access$300(Presenter x0) {
        return x0.wp;
    }
}

