package org.gcube.portlets.user.templates.client;




import org.gcube.portlets.user.guidedtour.client.GCUBEGuidedTour;
import org.gcube.portlets.user.guidedtour.client.GuidedTourResourceProvider;
import org.gcube.portlets.user.guidedtour.resources.client.GuidedTourResource;
import org.gcube.portlets.user.templates.client.model.TemplateModel;
import org.gcube.portlets.user.templates.client.presenter.Presenter;
import org.gcube.portlets.user.templates.client.resources.TourResources;

import com.google.gwt.core.client.EntryPoint;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.RunAsyncCallback;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.dom.client.KeyCodes;
import com.google.gwt.event.dom.client.KeyUpEvent;
import com.google.gwt.event.dom.client.KeyUpHandler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;

/**
 * Entry point classes define <code>onModuleLoad()</code>.
 */
public class Templates implements EntryPoint {

	/**
	 * 
	 */
	public static final int HEADER_HEIGHT = 25;
	/**
	 * 
	 */
	public static final int PAGE_LEFT = 5;
	/**
	 * 
	 */
	public static final int TOOLBOX_LEFT = 15;
	/**
	 * 
	 */
	public static final int TEMPLATE_LEFT = 25;
	/**
	 * 
	 */
	public static final int TEMPLATE_TOP = HEADER_HEIGHT + 90;
	/**
	 * 
	 */	
	public static Templates singleton = null;
	/**
	 * 
	 * @return .
	 */
	public static Templates get() {
		return singleton;
	}

	/**
	 * the controller
	 */
	private Presenter presenter;

	private VerticalPanel mainLayout = new VerticalPanel();

	private TitleBar titlebar;

	private HeaderBar header;

	private ScrollPanel bottomScrollerPanel = new ScrollPanel();

	private VerticalPanel bottomPanel = new VerticalPanel();

	private VerticalPanel toolbarPanel = new VerticalPanel();

	private HTML divHidden = new HTML(); 

	private TemplateModel model;


	/**
	 * This is the entry point method.
	 */
	public void onModuleLoad() {

		singleton = this;
		model = new TemplateModel();


		mainLayout.setWidth("90%");
		mainLayout.setHeight("100%");

		presenter = new Presenter(model);

		titlebar = new TitleBar(presenter);
		header = new HeaderBar(presenter);

		mainLayout.add(titlebar);
		mainLayout.add(header);
		mainLayout.add(toolbarPanel);


		toolbarPanel.setWidth("90%");
		toolbarPanel.setHeight("25px");
		//		bottomScrollerPanel.setStyleName("border");
		//		bottomPanel.setStyleName("border");

		bottomScrollerPanel.add(bottomPanel);

		mainLayout.add(bottomScrollerPanel);


		presenter.addTextToolBar();


		bottomPanel.setWidth("90%");
		bottomPanel.setHeight("100%");



		bottomPanel.add(presenter.getWorkSpacePanel());
		divHidden.setStyleName("border");
		divHidden.setWidth("500");
		divHidden.setStyleName("d4sRichTextArea");
		divHidden.addStyleName("setVisibilityOff");
		bottomPanel.add(divHidden);

		presenter.setHeader(header);
		presenter.setTitleBar(titlebar);

		// Add image and button to the RootPanel
		RootPanel.get("TemplateGeneratorDIV").add(mainLayout);


		int scrollerHeight = Window.getClientHeight() - bottomScrollerPanel.getAbsoluteTop();

		bottomScrollerPanel.setPixelSize(Window.getClientWidth()- 150, scrollerHeight);

		Window.addResizeHandler(new ResizeHandler() {
			@Override
			public void onResize(ResizeEvent event) {
				int scrollerHeight = event.getHeight() - bottomScrollerPanel.getAbsoluteTop();
				bottomScrollerPanel.setPixelSize(Window.getClientWidth()- 150, scrollerHeight);			
			}
		});
		checkTour();
	}
	
	private void checkTour() {
		showGuidedTour();
	}

	private void showGuidedTour() {
		GWT.runAsync(GCUBEGuidedTour.class, new RunAsyncCallback() {
			public void onSuccess() {
				GCUBEGuidedTour.showTour(Templates.class.getName(), new GuidedTourResourceProvider() {
					@Override
					public GuidedTourResource getResource() {
						TourResources resources = GWT.create(TourResources.class);
						return resources.quickTour();
					}
				});
			}
			public void onFailure(Throwable caught) {
				Window.alert("Could not check show tour");
			}
		});
	}

	/**
	 * 
	 * @return .
	 */
	public VerticalPanel getMainLayout() {
		return mainLayout;
	}

	/**
	 * 
	 * @return .
	 */
	public HeaderBar getHeader() {
		return header;
	}

	/**
	 * 
	 * @return .
	 */
	public TitleBar getTitleHeader() {
		return titlebar;
	}



	/**
	 * 
	 * @return .
	 */
	public VerticalPanel getToolbarPanel() {
		return toolbarPanel;
	}

	public HTML getDivHidden() {
		return divHidden;
	}

	public void setDivHidden(HTML divHidden) {
		this.divHidden = divHidden;
	}

	public ScrollPanel getScrollerPanel() {
		return bottomScrollerPanel;
	}
}
