package org.gcube.portlets.user.templates.client.components;

import java.util.ArrayList;

import org.gcube.portlets.user.templates.client.TGenConstants;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

import com.extjs.gxt.ui.client.Style.Scroll;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.TextBox;

public class AttributeDialog extends Dialog {

	ArrayList<TextBox> values;
	FlexTable grid;

	HTML name = new HTML("Attribute Name: ");
	TextBox nameValue = new TextBox();			


	public AttributeDialog(final Presenter presenter, final int width, final int height) {
		super();		  
		this.setHeading("Add Attribute");  
		this.setButtons(Dialog.OKCANCEL);
		this.setBodyStyleName("gridAttribute");  
		values = new ArrayList<TextBox>();
		grid = getContent();
		this.add(grid);

		this.setScrollMode(Scroll.AUTO);  
		this.setHideOnButtonClick(true);

		ButtonBar buttons = this.getButtonBar();

		Button okbutton = (Button) buttons.getItem(0);
		setHideOnButtonClick(false);

		okbutton.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				if (validate()) {
					String[] values2Pass = new String[values.size()];
					for (int i=0; i < values.size(); i++) 
						values2Pass[i] = values.get(i).getText();

					presenter.addAttributArea(width, height, nameValue.getText(), values2Pass);
					hide();
				} else
					Info.display("Error", "All fields must be filled");  
			}  
		});  
		
		Button cancelbutton = (Button) buttons.getItem(1);

		cancelbutton.addSelectionListener( new SelectionListener<ButtonEvent>() {  
			public void componentSelected(ButtonEvent ce) {  
				hide();
			}  
		});  
		
	}

	/**
	 * check not null in textfields
	 * @return
	 */
	private boolean validate() {
		if (nameValue.getText().compareTo("") == 0)
			return false;
		for (TextBox value : values) {
			if (value.getText().compareTo("") == 0)
				return false;
		}
		return true;
	}

	private FlexTable getContent() {
		FlexTable grid = new FlexTable();
		grid.setWidth("100%");
		grid.setStyleName("gridAttribute");
		name = new HTML("Attribute Name: ");
		HTML value1 = new HTML("Value 1: ");

		name.setStyleName("dialogText");
		value1.setStyleName("dialogText");

		grid.setWidget(0, 0,name);
		grid.setWidget(1, 0,value1);

		nameValue = new TextBox();			
		TextBox firstValue = new TextBox();

		values.add(firstValue);

		nameValue.setWidth("130px");
		firstValue.setWidth("130px");
		nameValue.setText("");
		firstValue.setText("");

		Image plus = new Image(TGenConstants.ADD_STATIC_IMAGE);
		plus.setStyleName("selectable");
		plus.addClickHandler(plusHandler);

		grid.setWidget(0, 1,nameValue);
		grid.setWidget(1, 1,firstValue);
		grid.setWidget(1, 2,plus);
		return grid;
	}

	ClickHandler plusHandler = new ClickHandler() {

		@Override
		public void onClick(ClickEvent event) {
			int i = values.size();
			i++;
			HTML valueLabel = new HTML("Value " + i + ": ");
			valueLabel.setStyleName("dialogText");
			TextBox valueBox = new TextBox();
			valueBox.setWidth("130px");
			values.add(valueBox);

			grid.setWidget(i, 0, valueLabel);
			grid.setWidget(i, 1, valueBox);

		}
	};
}
