package org.gcube.portlets.user.templates.client.components;

import org.gcube.portlets.d4sreporting.common.shared.ComponentType;
import org.gcube.portlets.d4sreporting.common.client.uicomponents.ReportUIComponent;
import org.gcube.portlets.user.templates.client.presenter.Presenter;

import com.google.gwt.event.dom.client.MouseOutEvent;
import com.google.gwt.event.dom.client.MouseOutHandler;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
/**
 * <code> AttributeArea </code> class 
 *
 * @author Massimiliano Assante, ISTI-CNR - massimiliano.assante@isti.cnr.it
 * @version April 2011 (1.0) 
 */
public class AttributeArea extends ReportUIComponent {
	private TextArea textArea = new TextArea();
	private VerticalPanel myPanel;
	private Presenter presenter;
	/**
	 * 
	 * @param presenter .
	 * @param left .
	 * @param top .
	 * @param width .
	 * @param height .
	 * @param attrName .
	 * @param values .
	 */
	public AttributeArea(final Presenter presenter, int left, int top, int width,  final int height, String attrName, String[] values) {
		super(ComponentType.ATTRIBUTE, left, top, width, height);
		myPanel = getResizablePanel();
		this.presenter = presenter;
		String toDisplay = attrName+": ";
		for (int i = 0; i < values.length; i++) {
			toDisplay += values[i];
			if (i != values.length-1)
				toDisplay += " | ";
		}
		textArea.setText(toDisplay);
		textArea.setPixelSize(width+15, height-15);
		textArea.setReadOnly(true);
		textArea.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				presenter.storeChangeInSession((Widget) event.getSource());				
			}
		});
		myPanel.add(textArea);
		myPanel.setTitle("Attribute Area");
		
		//repositionMyPanel(0, 15);
		myPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		myPanel.setPixelSize(width, height);
		textArea.setStyleName("attributeArea");
		setStyleName("d4sFrame");
	}

	public AttributeArea(final Presenter presenter, int left, int top, int width,  final int height, String textToDisplay) {
		super(ComponentType.ATTRIBUTE, left, top, width, height);
		this.presenter = presenter;
		myPanel = getResizablePanel();
		
		textArea.setPixelSize(width, height-15);
		textArea.setReadOnly(true);
		textArea.addMouseOutHandler(new MouseOutHandler() {
			
			@Override
			public void onMouseOut(MouseOutEvent event) {
				presenter.storeChangeInSession((Widget) event.getSource());				
			}
		});
		myPanel.add(textArea);
		myPanel.setTitle("Attribute Area");
		textArea.setText(textToDisplay);
		//repositionMyPanel(0, 15);
		myPanel.setVerticalAlignment(HasVerticalAlignment.ALIGN_BOTTOM);
		myPanel.setPixelSize(width, height);
		textArea.setStyleName("attributeArea");
		setStyleName("d4sFrame");
	}

	/**
	 * 
	 * @return .
	 */
	public TextArea getTextArea() {
		return textArea;
	}

	public ComponentType getType() {
		return ComponentType.ATTRIBUTE;
	}

	@Override
	public void lockComponent(ReportUIComponent toLock, boolean locked) {
		presenter.lockComponent(this, locked);
	}

	@Override
	public void removeTemplateComponent(ReportUIComponent toRemove) {
		presenter.removeTemplateComponent(this);		
	}
}
