/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.session.FetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;

public abstract class AbstractDaoBuffer<T extends FetchingElement>
implements FetchingBuffer<T> {
    protected Logger logger = Logger.getLogger(AbstractDaoBuffer.class);
    protected AbstractPersistence<T> dao;

    public AbstractDaoBuffer(AbstractPersistence<T> dao) {
        this.dao = dao;
    }

    public void add(T item) throws Exception {
        try {
            this.dao.insert(item);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in add item: " + e), (Throwable)e);
        }
    }

    public int size() throws Exception {
        return this.dao.countItems();
    }

    public List<T> getList() throws Exception {
        return this.dao.getList();
    }

    public List<T> getList(int startIndex, int offset) throws Exception {
        return this.dao.getList(startIndex, offset);
    }

    public List<T> getList(Map<String, String> filterANDMap, int startIndex, int offset) throws Exception {
        return this.dao.getList(filterANDMap, startIndex, offset);
    }
}

