/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.stream;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.gcube.data.spd.model.KeyValue;
import org.gcube.data.spd.model.PointInfo;
import org.gcube.data.streams.Stream;
import org.gcube.portlets.user.speciesdiscovery.shared.Occurrence;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class IteratorPointInfo
implements Stream<PointInfo> {
    protected Logger logger = Logger.getLogger(IteratorPointInfo.class);
    private Iterator<Occurrence> iterator;

    public IteratorPointInfo(Iterator<Occurrence> iterator) {
        this.iterator = iterator;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public PointInfo next() {
        Occurrence occrs = (Occurrence)this.iterator.next();
        PointInfo pointInfo = null;
        if (occrs != null) {
            this.logger.trace((Object)("get occurences id " + occrs.getServiceId()));
            Double decimalLatitude = null;
            Double decimalLongitude = null;
            try {
                decimalLatitude = Double.valueOf(occrs.getDecimalLatitude());
                decimalLongitude = Double.valueOf(occrs.getDecimalLongitude());
            }
            catch (Exception e) {
                this.logger.error((Object)"error in get coordinate return null");
                return null;
            }
            pointInfo = new PointInfo(decimalLongitude.doubleValue(), decimalLatitude.doubleValue());
            ArrayList<KeyValue> listMetaData = new ArrayList<KeyValue>();
            listMetaData.add(new KeyValue("basisOfRecord", NormalizeString.validateUndefined((String)occrs.getBasisOfRecord())));
            listMetaData.add(new KeyValue("catalogueNumber", NormalizeString.validateUndefined((String)occrs.getCatalogueNumber())));
            listMetaData.add(new KeyValue("citation", NormalizeString.validateUndefined((String)occrs.getCitation())));
            listMetaData.add(new KeyValue("collectionCode", NormalizeString.validateUndefined((String)occrs.getCollectionCode())));
            listMetaData.add(new KeyValue("coordinateUncertaintyInMeters", NormalizeString.validateUndefined((String)occrs.getCoordinateUncertaintyInMeters())));
            listMetaData.add(new KeyValue("country", NormalizeString.validateUndefined((String)occrs.getCountry())));
            listMetaData.add(new KeyValue("dataProvider", NormalizeString.validateUndefined((String)occrs.getDataProvider())));
            listMetaData.add(new KeyValue("dataSet", NormalizeString.validateUndefined((String)occrs.getDataSet())));
            listMetaData.add(new KeyValue("scientificNameAuthorship", NormalizeString.validateUndefined((String)occrs.getScientificNameAuthorship())));
            listMetaData.add(new KeyValue("lsid", NormalizeString.validateUndefined((String)occrs.getLsid())));
            listMetaData.add(new KeyValue("credits", NormalizeString.validateUndefined((String)occrs.getCredits())));
            listMetaData.add(new KeyValue("dataSource", NormalizeString.validateUndefined((String)occrs.getDataSource())));
            listMetaData.add(new KeyValue("eventDate", NormalizeString.validateUndefined((String)occrs.getEventDate())));
            listMetaData.add(new KeyValue("family", NormalizeString.validateUndefined((String)occrs.getFamily())));
            listMetaData.add(new KeyValue("id", NormalizeString.validateUndefined((String)("" + occrs.getId()))));
            listMetaData.add(new KeyValue("institutionCode", NormalizeString.validateUndefined((String)occrs.getInstitutionCode())));
            listMetaData.add(new KeyValue("locality", NormalizeString.validateUndefined((String)occrs.getLocality())));
            listMetaData.add(new KeyValue("maxDepth", NormalizeString.validateUndefined((String)occrs.getMaxDepth())));
            listMetaData.add(new KeyValue("minDepth", NormalizeString.validateUndefined((String)occrs.getMinDepth())));
            listMetaData.add(new KeyValue("modified", NormalizeString.validateUndefined((String)occrs.getModified())));
            listMetaData.add(new KeyValue("recordedBy", NormalizeString.validateUndefined((String)occrs.getRecordedBy())));
            listMetaData.add(new KeyValue("scientificName", NormalizeString.validateUndefined((String)occrs.getScientificName())));
            listMetaData.add(new KeyValue("decimalLatitude", decimalLatitude + ""));
            listMetaData.add(new KeyValue("decimalLongitude", decimalLongitude + ""));
            pointInfo.setPropertiesList(listMetaData);
            this.logger.trace((Object)("create new object point info lat: " + decimalLatitude + " long: " + decimalLongitude));
            return pointInfo;
        }
        this.logger.trace((Object)"get occurences null - return null");
        return null;
    }

    public void remove() {
        this.iterator.remove();
    }

    public Iterator<PointInfo> iterator() {
        return this;
    }

    public void close() {
    }

    public URI locator() throws IllegalStateException {
        return null;
    }

    public boolean isClosed() {
        return false;
    }
}

