/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.filterresult;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.gcube.portlets.user.speciesdiscovery.client.filterresult.ResultFilterPanelEnum;
import org.gcube.portlets.user.speciesdiscovery.client.filterresult.ResultFilterPanelInterface;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;

public class RankFilter
implements ResultFilterPanelInterface {
    private ContentPanel rankFilterPanel = new ContentPanel();
    private VerticalPanel vp = new VerticalPanel();
    private HashMap<String, Button> hashButton = new HashMap();
    private EventBus eventBus;

    public RankFilter() {
        this.setHeaderTitle();
        this.vp.setStyleAttribute("margin-left", "5px");
        this.rankFilterPanel.setScrollMode(Style.Scroll.AUTO);
        this.rankFilterPanel.add((Widget)this.vp);
        this.createToolBar();
    }

    public ContentPanel getPanel() {
        return this.rankFilterPanel;
    }

    public String getName() {
        return ResultFilterPanelEnum.RANK.getLabel();
    }

    public void setHeaderTitle() {
        this.rankFilterPanel.setHeading(this.getName());
    }

    public void loadDataSource(HashMap<String, Integer> result) {
        for (String key : result.keySet()) {
            Button butt = (Button)this.hashButton.get(key);
            Integer counter = result.get(key);
            if (butt != null) {
                String oldText = butt.getText();
                int start = oldText.indexOf("(");
                String description = oldText.substring(0, start);
                butt.setText(description + " (" + counter + ")");
                butt.setData("counter", (Object)counter);
                continue;
            }
            butt = new Button(key + " (" + counter + ")");
            butt.setStyleAttribute("margin", "5px");
            butt.setData("counter", (Object)counter);
            butt.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            butt.setStyleName("button-hyperlink");
            butt.setId(key);
            this.hashButton.put(key, butt);
            this.vp.add((Widget)butt);
        }
        this.vp.layout();
    }

    public void reset() {
        this.hashButton.clear();
        this.vp.removeAll();
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public void reloadDataSort() {
        this.vp.removeAll();
        if (!this.hashButton.isEmpty()) {
            ArrayList listKey = new ArrayList(this.hashButton.keySet());
            Collections.sort(listKey);
            for (String key : listKey) {
                this.vp.add((Widget)this.hashButton.get(key));
            }
        }
        this.vp.layout(true);
    }

    public void createToolBar() {
        ToolBar toolbar = new ToolBar();
        Button butt = new Button("Sort results");
        butt.setStyleName("button-noimage");
        butt.setWidth(100);
        butt.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getSortIcon()));
        butt.setToolTip("Sort filter in alphabetical order (from A to Z)");
        butt.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbar.add((Component)butt);
        toolbar.add((Component)new FillToolItem());
        Button buttonReload = new Button("");
        buttonReload.setStyleName("button-noimage");
        buttonReload.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getReload()));
        buttonReload.setToolTip("Reload filter");
        buttonReload.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        toolbar.add((Component)buttonReload);
        toolbar.setStyleName("toolbar-filter");
        this.rankFilterPanel.setTopComponent((Component)toolbar);
    }

    static /* synthetic */ EventBus access$000(RankFilter x0) {
        return x0.eventBus;
    }
}

