/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.stream.aggregation;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.speciesdiscovery.client.model.ClassificationModel;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Aggregator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.aggregation.TaxonomyClassificationAggregator;
import org.gcube.portlets.user.speciesdiscovery.shared.MainTaxonomicRankEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyInterface;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyProvider;

public class TaxonomyClassificationAggregator<T extends TaxonomyProvider>
implements Aggregator<T, EnumMap<MainTaxonomicRankEnum, HashMap<String, ClassificationModel>>> {
    public static final String NAME = "ClassificationAggregator";
    public static final String TAXONOMYUNKNOWN = "Unknown";
    public static final String BASETAXONOMY = "Kingdom";
    public static final String UNK = "Unk";
    public static final String UNDEFINED = "Undefined";
    public static final Map<String, MainTaxonomicRankEnum> RANKS = new HashMap();
    protected EnumMap<MainTaxonomicRankEnum, HashMap<String, ClassificationModel>> aggregations = new EnumMap(MainTaxonomicRankEnum.class);

    public String getName() {
        return NAME;
    }

    public void aggregate(TaxonomyProvider row) {
        List matchingTaxon = row.getParents();
        if (matchingTaxon == null || matchingTaxon.size() == 0) {
            return;
        }
        EnumMap groupedTaxon = this.groupTaxonByRank(matchingTaxon);
        for (MainTaxonomicRankEnum aggregationRank : MainTaxonomicRankEnum.values()) {
            String unknownRank;
            String taxonId;
            TaxonomyInterface taxon = (TaxonomyInterface)groupedTaxon.get(aggregationRank);
            if (taxon != null && taxon.getName() != null) {
                taxonId = this.addTaxonToAggregation(aggregationRank, taxon, row.getBaseTaxonValue(), row.getBaseTaxonValue(), taxon.getRank());
                this.setClassification(row, aggregationRank, taxonId);
                continue;
            }
            String string = unknownRank = ((TaxonomyInterface)matchingTaxon.get(0)).getRank() != null ? ((TaxonomyInterface)matchingTaxon.get(0)).getRank() : TAXONOMYUNKNOWN;
            if (!row.getBaseTaxonValue().equalsIgnoreCase(TAXONOMYUNKNOWN)) {
                taxonId = this.addTaxonToAggregation(aggregationRank, (TaxonomyInterface)row.getParents().get(0), row.getBaseTaxonValue(), row.getBaseTaxonValue(), unknownRank);
                this.setClassification(row, aggregationRank, taxonId);
                continue;
            }
            String haskKey = "[Unk " + aggregationRank + "]" + " " + unknownRank;
            String unkName = ((TaxonomyInterface)matchingTaxon.get(0)).getName() != null ? ((TaxonomyInterface)matchingTaxon.get(0)).getName() : TAXONOMYUNKNOWN;
            taxonId = this.addTaxonToAggregation(aggregationRank, haskKey, unkName, row.getBaseTaxonValue(), row.getBaseTaxonValue(), unknownRank);
            this.setClassification(row, aggregationRank, taxonId);
        }
    }

    protected void setClassification(TaxonomyProvider input, MainTaxonomicRankEnum rank, String value) {
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$MainTaxonomicRankEnum[rank.ordinal()]) {
            case 1: {
                input.setClassID(value);
                break;
            }
            case 2: {
                input.setFamilyID(value);
                break;
            }
            case 3: {
                input.setGenusID(value);
                break;
            }
            case 4: {
                input.setKingdomID(value);
                break;
            }
            case 5: {
                input.setOrderID(value);
                break;
            }
            case 6: {
                input.setPhylumID(value);
                break;
            }
            case 7: {
                input.setSpeciesID(value);
            }
        }
    }

    protected EnumMap<MainTaxonomicRankEnum, TaxonomyInterface> groupTaxonByRank(List<? extends TaxonomyInterface> listTaxonomyInteface) {
        EnumMap<MainTaxonomicRankEnum, TaxonomyInterface> groupedTaxon = new EnumMap<MainTaxonomicRankEnum, TaxonomyInterface>(MainTaxonomicRankEnum.class);
        for (TaxonomyInterface taxonomyInterface : listTaxonomyInteface) {
            MainTaxonomicRankEnum rank;
            if (taxonomyInterface.getRank() == null || (rank = (MainTaxonomicRankEnum)RANKS.get(taxonomyInterface.getRank().toLowerCase())) == null) continue;
            groupedTaxon.put(rank, taxonomyInterface);
        }
        return groupedTaxon;
    }

    protected String addTaxonToAggregation(MainTaxonomicRankEnum aggregationRank, TaxonomyInterface taxon, String baseTaxonId, String baseTaxonValue, String classificationRank) {
        String taxonName = taxon.getName().toLowerCase();
        return this.addTaxonToAggregation(aggregationRank, taxonName, taxonName, baseTaxonId, baseTaxonValue, classificationRank);
    }

    protected String addTaxonToAggregation(MainTaxonomicRankEnum aggregationRank, String taxonId, String classificationName, String baseTaxonId, String baseTaxonValue, String classificationRank) {
        HashMap aggregation = this.getAggregation(aggregationRank);
        ClassificationModel classification = (ClassificationModel)aggregation.get(taxonId);
        if (classification == null) {
            classification = new ClassificationModel(taxonId, classificationName, classificationRank.toLowerCase(), baseTaxonId, baseTaxonValue, true, 1);
            aggregation.put(taxonId, classification);
        } else {
            classification.incrCountOf();
        }
        return taxonId;
    }

    protected HashMap<String, ClassificationModel> getAggregation(MainTaxonomicRankEnum rank) {
        HashMap aggregation = (HashMap)this.aggregations.get(rank);
        if (aggregation == null) {
            aggregation = new HashMap();
            this.aggregations.put(rank, aggregation);
        }
        return aggregation;
    }

    public EnumMap<MainTaxonomicRankEnum, HashMap<String, ClassificationModel>> getAggregation() {
        return this.aggregations;
    }

    static {
        for (MainTaxonomicRankEnum rank : MainTaxonomicRankEnum.values()) {
            RANKS.put(rank.getLabel().toLowerCase(), rank);
        }
    }
}

