/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.util.stream;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.store.Store;
import com.extjs.gxt.ui.client.store.StoreEvent;
import com.extjs.gxt.ui.client.store.StoreListener;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.util.ExtendedTimer;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSource;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.EditListener;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamPagingLoader;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamPagingLoaderListener;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamState;
import org.gcube.portlets.user.speciesdiscovery.shared.filter.ResultFilter;

public class StreamPagingLoader {
    protected static final int STREAM_STATUS_POLL_DELAY = 2000;
    protected static final int STREAM_FILL_POLL_DELAY = 1000;
    protected ListStore<ModelData> store;
    protected EditListener editListener;
    protected DataSource dataSource;
    protected List<StreamPagingLoaderListener> listeners;
    protected int pageSize;
    protected int currentPage;
    protected int currentStartItem;
    protected int currentEndItem;
    protected int streamSize;
    protected boolean streamComplete = false;
    protected boolean isFilteredStream = false;
    private int limitOnDataFilter = 0;
    protected Timer streamSizePoller;
    protected ExtendedTimer storeFiller;
    protected boolean pageComplete = false;
    private ResultFilter activeFilterObject = null;
    private int itemsLoaded = 0;
    private boolean reloadWithoutFilter;
    private int start = 0;
    private int oldStartItem = 0;
    private int oldLimit = 0;
    private int limit = 0;
    private boolean isNewPage = true;
    private boolean isOccurrences = false;

    public StreamPagingLoader(int pageSize) {
        this.pageSize = pageSize;
        this.listeners = new ArrayList(1);
        this.initialize();
    }

    public void setEditListener(EditListener editListener) {
        this.editListener = editListener;
    }

    public void addListener(StreamPagingLoaderListener listener) {
        this.listeners.add(listener);
    }

    protected void initialize() {
        this.store = new ListStore();
        this.store.addStoreListener((StoreListener)new /* Unavailable Anonymous Inner Class!! */);
        this.streamSizePoller = new /* Unavailable Anonymous Inner Class!! */;
        this.storeFiller = new /* Unavailable Anonymous Inner Class!! */;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void reset() {
        this.currentPage = 0;
        this.currentStartItem = 0;
        this.start = 0;
        this.oldStartItem = 0;
        this.oldLimit = 0;
        this.limit = 0;
        this.isNewPage = false;
        this.isOccurrences = false;
        this.currentEndItem = 0;
        this.streamComplete = false;
        this.streamSizePoller.cancel();
        this.storeFiller.cancel();
        this.pageComplete = false;
        this.itemsLoaded = 0;
    }

    public void startLoading(boolean isOccurrences) {
        this.isFilteredStream = false;
        this.limitOnDataFilter = 0;
        this.isOccurrences = isOccurrences;
        Log.trace((String)("start loading set is occurrences " + isOccurrences));
        this.fireStreamStartLoading();
        this.pollStreamState();
        this.streamSizePollerStart();
        this.nextPage();
    }

    public void streamSizePollerStart() {
        this.streamSizePoller.scheduleRepeating(2000);
    }

    public ListStore<ModelData> getStore() {
        return this.store;
    }

    public void pollStreamState() {
        this.dataSource.getStreamState((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void setPageComplete(boolean bool) {
        this.pageComplete = bool;
    }

    protected boolean getPageCompleted() {
        return this.pageComplete;
    }

    protected void setStreamState(StreamState state) {
        Log.trace((String)("setStreamState state: " + state));
        this.streamSize = state.getSize();
        this.streamComplete = state.isComplete();
        this.fireStreamUpdate();
    }

    protected void streamComplete() {
        5 t = new /* Unavailable Anonymous Inner Class!! */;
        t.schedule(500);
    }

    public void setPage(int page) {
        int maxPage = this.streamSize / this.pageSize + 1;
        this.currentPage = Math.min(page, maxPage);
        this.currentPage = Math.max(this.currentPage, 1);
        this.setIsNewPage(true);
        this.startFilling();
    }

    public void nextPage() {
        ++this.currentPage;
        this.setPageComplete(false);
        this.setIsNewPage(true);
        this.startFilling();
    }

    public void prevPage() {
        --this.currentPage;
        this.setPageComplete(false);
        this.setIsNewPage(true);
        this.startFilling();
    }

    public void reloadPageForFiltering(int limitFilter, boolean isFirstStart) {
        this.isFilteredStream = true;
        if (limitFilter != -1) {
            this.limitOnDataFilter = limitFilter;
        }
        if (isFirstStart) {
            this.reset();
            this.currentPage = 1;
            this.setIsNewPage(true);
        }
        this.currentStartItem = (this.currentPage - 1) * this.pageSize;
        if (this.currentStartItem < 0) {
            this.currentStartItem = 0;
        }
        if (this.limit > 0) {
            this.oldStartItem = this.start;
            this.oldLimit = this.limit;
        }
        this.start = this.currentStartItem;
        this.limit = Math.min(this.limitOnDataFilter - this.currentStartItem, this.pageSize);
        Log.trace((String)(" OLD START: " + this.oldStartItem + "  OLD LIMIT:  " + this.oldLimit + "  START: " + this.start + "  LIMIT: " + this.limit + " LIMIT ON DATA: " + this.limitOnDataFilter));
        if (this.oldStartItem == this.start && !this.isNewPage() && this.limit >= this.oldLimit && !this.isOccurrences) {
            Log.trace((String)"NOT FILL PAGE - CONDITION oldStartItem==start is true, check page complete");
            if (this.pageComplete) {
                this.pageComplete();
            }
        } else {
            if (this.limit > 0) {
                this.setIsNewPage(false);
            }
            Log.trace((String)("reloadPageForFiltering startFilling  currentPage: " + this.currentPage + " currentStartItem: " + this.currentStartItem + " pageSize: " + this.pageSize + " limitOnDataFilter: " + this.limitOnDataFilter));
            this.store.removeAll();
            Log.trace((String)"Firing BeforeDataChanged");
            this.store.fireEvent(Store.BeforeDataChanged, (BaseEvent)new StoreEvent((Store)this.store));
            Log.trace((String)"Fired BeforeDataChanged");
            Log.trace((String)("reloadPageForFiltering fillPage start: " + this.start + " limit: " + this.limit));
            if (this.limit >= 0) {
                long startTime = System.currentTimeMillis();
                this.dataSource.getData(this.start, this.limit, this.activeFilterObject, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                Log.trace((String)"There is no data to download, skipping");
            }
        }
    }

    public void resetFilters() {
        this.setActiveFilterObject(null);
        this.isFilteredStream = false;
    }

    public void reloadPageWithoutFiltering() {
        this.reset();
        this.resetFilters();
        this.reloadWithoutFilter = true;
        this.currentStartItem = (this.currentPage - 1) * this.pageSize;
        if (this.currentStartItem < 0) {
            this.currentStartItem = 0;
        }
        Log.trace((String)("reloadPageWithoutFiltering currentPage: " + this.currentPage + " currentStartItem: " + this.currentStartItem + " pageSize: " + this.pageSize + " streamSize: " + this.streamSize + " store.getCount(): " + this.store.getCount()));
        Log.trace((String)"Firing BeforeDataChanged");
        this.store.fireEvent(Store.BeforeDataChanged, (BaseEvent)new StoreEvent((Store)this.store));
        Log.trace((String)"Fired BeforeDataChanged");
        this.pollingState();
        this.setPage(0);
    }

    public void pollingState() {
        if (!this.streamComplete) {
            this.streamSizePoller.scheduleRepeating(2000);
        } else {
            this.pollStreamState();
        }
    }

    protected void startFilling() {
        if (!this.isFilteredStream) {
            this.currentStartItem = (this.currentPage - 1) * this.pageSize;
            Log.trace((String)("startFilling currentPage: " + this.currentPage + " currentStartItem: " + this.currentStartItem));
            this.store.removeAll();
            Log.trace((String)"Firing BeforeDataChanged");
            this.store.fireEvent(Store.BeforeDataChanged, (BaseEvent)new StoreEvent((Store)this.store));
            Log.trace((String)"Fired BeforeDataChanged");
            this.fillPage();
            this.storeFiller.scheduleRepeating(1000);
        } else {
            this.reloadPageForFiltering(-1, false);
        }
    }

    protected void fillPage() {
        if (this.limit > 0) {
            this.oldStartItem = this.start;
            this.oldLimit = this.limit;
        }
        this.start = this.currentStartItem + this.store.getCount();
        this.limit = Math.min(this.pageSize - this.store.getCount(), this.streamSize - this.start);
        Log.trace((String)(" OLD START: " + this.oldStartItem + "  OLD LIMIT:  " + this.oldLimit + "  START: " + this.start + "  LIMIT: " + this.limit + " IS NEW PAGE: " + this.isNewPage()));
        if (this.oldStartItem == this.start && !this.isNewPage() && this.limit >= this.oldLimit && !this.isOccurrences) {
            Log.trace((String)"NOT FILL PAGE - CONDITION oldStartItem==start is true, check page complete");
            if (this.pageComplete) {
                this.pageComplete();
            }
        } else {
            Log.trace((String)("fillPage currentPage: " + this.currentPage + " currentStartItem: " + this.currentStartItem + " pageSize: " + this.pageSize + " streamSize: " + this.streamSize + " store.getCount(): " + this.store.getCount()));
            Log.trace((String)("fillPage start: " + this.start + " limit: " + this.limit));
            if (this.limit > 0) {
                this.setIsNewPage(false);
            }
            if (this.limit >= 0) {
                long startTime = System.currentTimeMillis();
                this.dataSource.getData(this.start, this.limit, this.activeFilterObject, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                Log.trace((String)"Limit is < 0 - there is no data to download, skipping");
                this.checkPageComplete();
            }
        }
    }

    public boolean exceedPage(int storeSize) {
        boolean cond;
        int currentEnd = this.store.getCount() + storeSize;
        if (this.streamComplete) {
            int expectedPageSize = Math.min(this.pageSize, this.streamSize - this.currentStartItem);
            int calc = (this.currentPage - 1) * this.pageSize + (this.streamSize - this.currentStartItem);
            int expectedEndElements = Math.min(this.currentPage * this.pageSize, calc);
            Log.trace((String)"Exceed Page - stream completed: true ");
            Log.trace((String)("expectedPageSize: " + expectedPageSize));
            Log.trace((String)("expectedEndElements: " + expectedEndElements));
            Log.trace((String)("currentEnd: " + currentEnd));
            Log.trace((String)(" store.getCount(): " + this.store.getCount()));
            Log.trace((String)(" streamSize: " + this.streamSize));
            cond = currentEnd > expectedEndElements;
        } else {
            cond = currentEnd > this.currentPage * this.pageSize;
        }
        Log.trace((String)("Exceed Page cond: " + cond + " pageSize: " + this.pageSize + " currentEnd: " + currentEnd));
        return cond;
    }

    protected void loadData(List<ModelData> data) {
        int prevStoreCount = this.store.getCount();
        for (ModelData row : data) {
            this.store.add(row);
        }
        if (prevStoreCount == 0 && data.size() > 0) {
            this.store.fireEvent(Store.DataChanged, (BaseEvent)new StoreEvent((Store)this.store));
        }
        this.checkPageComplete();
    }

    protected void checkPageComplete() {
        this.updateCurrentValues();
        if (!this.pageComplete) {
            this.setPageComplete(this.isPageComplete());
        }
        if (this.pageComplete) {
            this.pageComplete();
        }
    }

    protected void pageComplete() {
        Log.trace((String)"page complete");
        this.store.fireEvent(Store.DataChanged, (BaseEvent)new StoreEvent((Store)this.store));
        this.storeFiller.cancel();
    }

    protected void updateCurrentValues() {
        this.currentEndItem = this.currentStartItem + this.store.getCount();
        Log.trace((String)("updateCurrentValues currentPage: " + this.currentPage + " currentStartItem: " + this.currentStartItem + " currentEndItem: " + this.currentEndItem));
        this.fireStreamUpdate();
    }

    protected boolean isPageComplete() {
        Log.trace((String)("checking if the page is complete loaded (store count: " + this.store.getCount() + ")"));
        Log.trace((String)("streamComplete: " + this.streamComplete));
        if (this.streamComplete) {
            int expectedPageSize = Math.min(this.pageSize, this.streamSize - this.currentStartItem);
            return this.store.getCount() == expectedPageSize;
        }
        boolean cond = this.store.getCount() == this.pageSize;
        return cond;
    }

    protected void fireStreamUpdate() {
        for (StreamPagingLoaderListener listener : this.listeners) {
            listener.onStreamUpdate(this.streamSize, this.currentStartItem, this.currentEndItem);
        }
    }

    protected void fireStreamLoadingComplete() {
        for (StreamPagingLoaderListener listener : this.listeners) {
            listener.onStreamLoadingComplete();
        }
    }

    protected void fireStreamStartLoading() {
        for (StreamPagingLoaderListener listener : this.listeners) {
            listener.onStreamStartLoading();
        }
    }

    public ResultFilter getActiveFilterObject() {
        return this.activeFilterObject;
    }

    public void setActiveFilterObject(ResultFilter activeFilterObject) {
        this.activeFilterObject = activeFilterObject;
    }

    public boolean isStreamComplete() {
        return this.streamComplete;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public boolean isNewPage() {
        return this.isNewPage;
    }

    public void setIsNewPage(boolean isNewPage) {
        this.isNewPage = isNewPage;
    }

    static /* synthetic */ void access$0(StreamPagingLoader streamPagingLoader, int n) {
        streamPagingLoader.itemsLoaded = n;
    }
}

