/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.advancedsearch;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.button.ButtonBar;
import com.extjs.gxt.ui.client.widget.button.ToggleButton;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.MultiField;
import com.extjs.gxt.ui.client.widget.form.NumberField;
import com.extjs.gxt.ui.client.widget.form.TextArea;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelEnum;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.AdvancedSearchPanelInterface;
import org.gcube.portlets.user.speciesdiscovery.client.advancedsearch.ColumnContainer;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;

public class BoundsFilter
extends ColumnContainer
implements AdvancedSearchPanelInterface {
    private NumberField upperBoundLatitudeField;
    private NumberField upperBoundLongitudeField;
    private NumberField lowerBoundLatitudeField;
    private NumberField lowerBoundLongitudeField;
    private ArrayList<DataSourceModel> availablePlugin;
    private ContentPanel boundsPanel = new ContentPanel();
    private Button btnResetAllFilters = new Button("Reset Filters");
    private TextArea txtAreaInfo = new TextArea();

    public BoundsFilter() {
        this.initBoundsPanel();
        this.btnResetAllFilters.setStyleName("button-hyperlink");
        this.availablePlugin = new ArrayList();
    }

    public ContentPanel getPanel() {
        return this.boundsPanel;
    }

    private void initBoundsPanel() {
        this.boundsPanel.setHeaderVisible(false);
        this.boundsPanel.setBodyBorder(false);
        this.upperBoundLatitudeField = new NumberField();
        this.upperBoundLatitudeField.setPropertyEditorType(Float.class);
        this.upperBoundLatitudeField.setEmptyText("Latitude");
        this.upperBoundLongitudeField = new NumberField();
        this.upperBoundLongitudeField.setPropertyEditorType(Float.class);
        this.upperBoundLongitudeField.setEmptyText("Longitude");
        MultiField uppertBound = new MultiField("Upper Bound", new Field[]{this.upperBoundLatitudeField, this.upperBoundLongitudeField});
        uppertBound.setSpacing(5);
        this.left.add((Widget)uppertBound);
        this.lowerBoundLatitudeField = new NumberField();
        this.lowerBoundLatitudeField.setPropertyEditorType(Float.class);
        this.lowerBoundLatitudeField.setEmptyText("Latitude");
        this.lowerBoundLongitudeField = new NumberField();
        this.lowerBoundLongitudeField.setPropertyEditorType(Float.class);
        this.lowerBoundLongitudeField.setEmptyText("Longitude");
        MultiField lowerBound = new MultiField("Lower Bound", new Field[]{this.lowerBoundLatitudeField, this.lowerBoundLongitudeField});
        lowerBound.setSpacing(5);
        this.left.add((Widget)lowerBound);
        this.left.add((Widget)uppertBound);
        this.btnResetAllFilters.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        ContentPanel cp = new ContentPanel();
        ButtonBar buttonBar = new ButtonBar();
        ToggleButton toggleInfo = new ToggleButton("");
        toggleInfo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        toggleInfo.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getInfoIcon()));
        toggleInfo.toggle(false);
        buttonBar.add((Component)toggleInfo);
        cp.setVisible(false);
        cp.setHeading("Bounds");
        cp.setBodyBorder(false);
        this.txtAreaInfo.setReadOnly(true);
        this.txtAreaInfo.setValue((Object)"Bounds filters (lower-upper) are available with following plug-in: \n");
        cp.setLayout((Layout)new FitLayout());
        cp.add((Widget)this.txtAreaInfo);
        cp.setWidth(300);
        cp.setHeight(50);
        cp.setScrollMode(Style.Scroll.AUTOY);
        cp.setHeaderVisible(false);
        HorizontalPanel hp = new HorizontalPanel();
        cp.setWidth(310);
        cp.setStyleAttribute("margin-left", "5px");
        cp.setStyleAttribute("margin-top", "2px");
        toggleInfo.setStyleAttribute("margin-left", "5px");
        toggleInfo.setStyleAttribute("margin-top", "2px");
        hp.add((Widget)this.btnResetAllFilters);
        hp.add((Widget)cp);
        hp.add((Widget)toggleInfo);
        this.right.add((Widget)hp);
        this.boundsPanel.add((Widget)this.columnContainer);
    }

    public String getName() {
        return AdvancedSearchPanelEnum.BOUNDS.getLabel();
    }

    public void resetAdvancedFields() {
        this.upperBoundLatitudeField.reset();
        this.upperBoundLongitudeField.reset();
        this.lowerBoundLatitudeField.reset();
        this.lowerBoundLongitudeField.reset();
    }

    public NumberField getUpperBoundLatitudeField() {
        return this.upperBoundLatitudeField;
    }

    public NumberField getUpperBoundLongitudeField() {
        return this.upperBoundLongitudeField;
    }

    public NumberField getLowerBoundLatitudeField() {
        return this.lowerBoundLatitudeField;
    }

    public NumberField getLowerBoundLongitudeField() {
        return this.lowerBoundLongitudeField;
    }

    public void addAvailablePlugInfo(DataSourceModel plugin, SpeciesCapability capability) {
        this.availablePlugin.add(plugin);
        String currentValue = (String)this.txtAreaInfo.getValue();
        this.txtAreaInfo.setValue((Object)(String.valueOf(currentValue) + plugin.getName() + " (" + capability.getName() + "); \n"));
    }

    public ArrayList<DataSourceModel> getAvailablePlugIn() {
        return this.availablePlugin;
    }
}

