package org.gcube.portlets.user.speciesdiscovery.client.windowdetail;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

import org.gcube.portlets.user.speciesdiscovery.client.ConstantsSpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.cluster.TablesForResultRow;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchEvent;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.ResultRowDataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;
import org.gcube.portlets.user.speciesdiscovery.shared.cluster.ClusterCommonNameDataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.cluster.ClusterStructuresForResultRow;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.Style.HorizontalAlignment;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.HorizontalPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.TabItem;
import com.extjs.gxt.ui.client.widget.VerticalPanel;
import com.extjs.gxt.ui.client.widget.layout.ColumnData;
import com.extjs.gxt.ui.client.widget.layout.ColumnLayout;
import com.extjs.gxt.ui.client.widget.layout.FormLayout;
import com.extjs.gxt.ui.client.widget.layout.TableData;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Anchor;

public class ResultRowDetailsFiller implements DetailsFiller {

	
	private TabItem tabItemDetails;
	private ToolBar toolbarOccurrences;
	private AbstractImagePrototype imgAttention = AbstractImagePrototype.create(Resources.INSTANCE.getAttention());
	private ContentPanel panelDetails;
	private int width = 900;
	private List<String> lastlistDataSourceFound;
	private CommonDetailComponents common;
	private String lastScientificName;

	public ResultRowDetailsFiller(TabItem tabItemDetails, ToolBar toolbarOccurrences, ContentPanel panelDetails, SearchEvent lastSearchEvent){
		this.tabItemDetails = tabItemDetails;
		this.toolbarOccurrences = toolbarOccurrences;
		this.panelDetails = panelDetails;
		this.common = new CommonDetailComponents(lastSearchEvent);
	}
	
	private void enableToolbarOccurrence(boolean bool){
		toolbarOccurrences.setEnabled(bool);
	}
	
	
	public void loadStructuresAndFillingPage(){
		
			final long startTime = System.currentTimeMillis();
		
			SpeciesDiscovery.taxonomySearchService.loadStructuresForResultRowClustering(new AsyncCallback<ClusterStructuresForResultRow>() {

				@Override
				public void onFailure(Throwable caught) {
					Info.display("Sorry", "Error retriving selected results");
					tabItemDetails.unmask();
					enableToolbarOccurrence(true);
					
				}

				@Override
				public void onSuccess(ClusterStructuresForResultRow result) {
					
					int size = result.getResult().size();

					long returnedTime = System.currentTimeMillis();
					
					long loadTime = returnedTime-startTime;
					
					Log.trace("fillPageDetailsForOccurences: " +size +" cluster result row was loaded in "+  loadTime +" msc");
					
					String items = size>0?"items":"item"; 
					
					String msg = "";
	
					if(result.getTotalRow()>size){
						msg = ConstantsSpeciesDiscovery.ROW_LIMIT_REACHED + " - ";
						tabItemDetails.setIcon(imgAttention);
						tabItemDetails.setToolTip(ConstantsSpeciesDiscovery.THE_MAX_NUMBER_OF_ITEMS_DISPLAYABLE_IS+ConstantsSpeciesDiscovery.LIMIT_ITEM_DETAILS);
					}
					
					msg+= tabItemDetails.getText() + " ("+size +" "+ items+")";
					tabItemDetails.setText(msg);

					createCommonNameDetailsPageForResultRow(result);
					
					enableToolbarOccurrence(true);
					tabItemDetails.unmask();
					
					long avilableTime = System.currentTimeMillis()-returnedTime;
					
					Log.trace("fillPageDetailsForOccurences: " +size +" view details result row are available in "+  avilableTime +" msc");
					
			}


		});
			
	}
	
	private void createCommonNameDetailsPageForResultRow(ClusterStructuresForResultRow result) {

		HashMap<String, ArrayList<String>> hashResultRowIdTables = result.getHashClusterScientificNameResultRowID();
		HashMap<String, ClusterCommonNameDataSource<ResultRow>> hashClusterCommonNamesDataSources = result.getHashClusterCommonNamesDataSources();
		
		String title = common.getSearchTitle();
		
		panelDetails.add(new Html(title));

		List<String> listKey = new ArrayList<String>(hashResultRowIdTables.keySet());
		Collections.sort(listKey);
		
		final Anchor anchorIndex = new Anchor();
		anchorIndex.setName("indexOfContents");
		
		panelDetails.add(new Html("<p style=\"font-size:12px;\"><b> Index of Contents"+anchorIndex+"</b></p><br/>"));
		panelDetails.add(common.createIndexOfContents(listKey));
		
		panelDetails.add(new Html("<hr><br/>"));
		
		//update last list data source found
		lastlistDataSourceFound = result.getListFoundDataSources();
		
		VerticalPanel verticaPanelAbouts = common.createPanelAbout(SpeciesCapability.RESULTITEM, result.getListFoundDataSources());
		panelDetails.add(verticaPanelAbouts);
		panelDetails.add(new Html("<br/>"));
		
		for (final String scientificName : listKey) {
			
			Anchor anchor = new Anchor("[top index]");
			anchor.setName(scientificName);
			
			anchor.addClickHandler(new ClickHandler() {
			    public void onClick(ClickEvent event) {
			         com.google.gwt.user.client.Window.Location.assign("#indexOfContents");
			    }
			});
			
			LayoutContainer titleContainer = new LayoutContainer();
			titleContainer.setLayout(new ColumnLayout());
			titleContainer.setWidth(width-80);
			
			LayoutContainer left = new LayoutContainer();
		    FormLayout layout = new FormLayout();
		    left.setLayout(layout);
		    
		    LayoutContainer right = new LayoutContainer();
		    layout = new FormLayout();
		    right.setLayout(layout);
	

		    HorizontalPanel hp = new HorizontalPanel();
		    hp.setTableWidth("100%");
		    TableData td = new TableData();
		    td.setHorizontalAlign(HorizontalAlignment.RIGHT);
		    hp.add(anchor, td);
		    

			titleContainer.add(left, new ColumnData(.8));
			titleContainer.add(right, new ColumnData(.2));
			
			this.lastScientificName = scientificName;
			

			left.add(new Html("<p style=\"margin-right:5px; font-size:14px;\"><b>" + ConstantsSpeciesDiscovery.SCIENTIFICNAME + ": " + scientificName + "</b></p>"));
			right.add(hp);
			
			panelDetails.add(titleContainer);
			
			panelDetails.add(new Html("<br/><br/>"));
			
			panelDetails.add(common.createExternalLinks(scientificName));
			
			String commonNamesTitle = "<p style=\"font-size:12px;\"><b>Common Names (Data Source/s)</b></p>";
			panelDetails.add(new Html(commonNamesTitle));
	
			ClusterCommonNameDataSource<ResultRow> cluster = hashClusterCommonNamesDataSources.get(scientificName);

			String tableCommonName = common.createTableWithCheckCommonNameDataSource(cluster.getHashMapCommonNameDataSources(), cluster.getListDataSourcesFound());
			panelDetails.add(new Html("<br/>"+tableCommonName+"<br/><br/>"));
			
			ArrayList<String> arrayRowID = hashResultRowIdTables.get(scientificName);
			
			for(int i=0; i<arrayRowID.size(); i++ ){
				ResultRow row = result.getResultRowByRowID(arrayRowID.get(i));
				Html table = TablesForResultRow.getTableForResultRow(row, ResultRowDataSource.getClassification(row.getParents()));
				panelDetails.add(table);
			}
		}
		
		panelDetails.layout(true);
		
		
	}
	@Override
	public List<String> getLastlistDataSourceFound() {
		return lastlistDataSourceFound;
	}
	
	@Override
	public String getLastScientificName() {
		return lastScientificName;
	}
}
