/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.job;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.Text;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.toolbar.FillToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.SeparatorToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import org.gcube.portlets.user.speciesdiscovery.client.job.occurrence.OccurrenceJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.RenderTextFieldUtil;

public class SpeciesJobPanel
extends ContentPanel {
    protected static final String EMPTY = "Empty";
    protected static final String LAST_QUERY = "Last query: ";
    private ToolBar toolbar = new ToolBar();
    private TaxonomyJobSpeciesPanel taxonomyJobPanelInstance;
    private OccurrenceJobSpeciesPanel occurrenceJobPanelInstance;
    private Button btnTaxonomyJobs;
    private Button btnOccurrenceJobs;
    private int jobOccurrenceCount = 0;
    private int jobTaxonomyCount = 0;
    private TextField<String> lastQuery;

    public SpeciesJobPanel(EventBus eventBus) {
        this.setTopComponent((Component)this.toolbar);
        this.setLayout((Layout)new FitLayout());
        this.setHeaderVisible(false);
        this.taxonomyJobPanelInstance = TaxonomyJobSpeciesPanel.getInstance((EventBus)eventBus);
        this.occurrenceJobPanelInstance = OccurrenceJobSpeciesPanel.getInstance((EventBus)eventBus);
        this.createOccurrencesToolBar();
        this.toolbar.add((Component)new SeparatorToolItem());
        this.createTaxonomyToolBar();
        Text txtLastQuery = new Text(LAST_QUERY);
        txtLastQuery.setStyleAttribute("padding-right", "2px");
        txtLastQuery.setStyleAttribute("color", "gray");
        this.lastQuery = new TextField();
        this.lastQuery.setReadOnly(true);
        this.lastQuery.setWidth(400);
        this.lastQuery.setValue((Object)EMPTY);
        this.toolbar.add((Component)new FillToolItem());
        this.toolbar.add((Component)txtLastQuery);
        this.toolbar.add((Component)this.lastQuery);
        RenderTextFieldUtil.setTextFieldAttr((Field)this.lastQuery, (String)"background", (String)"none");
    }

    private void createOccurrencesToolBar() {
        this.btnTaxonomyJobs = new Button("Species Taxonomy Jobs");
        this.btnTaxonomyJobs.setScale(Style.ButtonScale.MEDIUM);
        this.setIconTaxonomyByCounter(0);
        this.btnTaxonomyJobs.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.add((Component)this.btnTaxonomyJobs);
    }

    private void resetTaxonoyCouter() {
        this.jobTaxonomyCount = 0;
        this.setIconTaxonomyByCounter(0);
    }

    private void createTaxonomyToolBar() {
        this.btnOccurrenceJobs = new Button("Species Occurrence Jobs");
        this.btnOccurrenceJobs.setScale(Style.ButtonScale.MEDIUM);
        this.setIconOccurrenceByCounter(0);
        this.btnOccurrenceJobs.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.add((Component)this.btnOccurrenceJobs);
    }

    public void setLastQuery(String query) {
        this.lastQuery.setValue((Object)query);
    }

    public void setLastQueryAsEmpty() {
        this.lastQuery.setValue((Object)EMPTY);
    }

    private void resetOccurrenceCounter() {
        this.jobOccurrenceCount = 0;
        this.setIconOccurrenceByCounter(0);
    }

    public void setIconOccurrenceByCounter(int count) {
        this.jobOccurrenceCount += count;
        switch (this.jobOccurrenceCount) {
            case 0: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace()));
                break;
            }
            case 1: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace1()));
                break;
            }
            case 2: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace2()));
                break;
            }
            case 3: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace3()));
                break;
            }
            case 4: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace4()));
                break;
            }
            default: {
                this.btnOccurrenceJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace4More()));
            }
        }
        this.toolbar.layout();
    }

    public void setIconTaxonomyByCounter(int count) {
        this.jobTaxonomyCount += count;
        switch (this.jobTaxonomyCount) {
            case 0: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy()));
                break;
            }
            case 1: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy1()));
                break;
            }
            case 2: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy2()));
                break;
            }
            case 3: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy3()));
                break;
            }
            case 4: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy4()));
                break;
            }
            default: {
                this.btnTaxonomyJobs.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getTaxonomy4More()));
            }
        }
        this.toolbar.layout();
    }

    static /* synthetic */ void access$0(SpeciesJobPanel speciesJobPanel) {
        speciesJobPanel.resetTaxonoyCouter();
    }

    static /* synthetic */ TaxonomyJobSpeciesPanel access$1(SpeciesJobPanel speciesJobPanel) {
        return speciesJobPanel.taxonomyJobPanelInstance;
    }

    static /* synthetic */ void access$2(SpeciesJobPanel speciesJobPanel) {
        speciesJobPanel.resetOccurrenceCounter();
    }

    static /* synthetic */ OccurrenceJobSpeciesPanel access$3(SpeciesJobPanel speciesJobPanel) {
        return speciesJobPanel.occurrenceJobPanelInstance;
    }
}

