/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.stream.aggregation;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.portlets.user.speciesdiscovery.client.model.ClassificationModel;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Aggregator;
import org.gcube.portlets.user.speciesdiscovery.shared.MainTaxonomicRankEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyInterface;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyProvider;

public class TaxonomyClassificationAggregator<T extends TaxonomyProvider>
implements Aggregator<T, EnumMap<MainTaxonomicRankEnum, HashMap<String, ClassificationModel>>> {
    public static final String NAME = "ClassificationAggregator";
    public static final String TAXONOMYUNKNOWN = "Unknown";
    public static final String BASETAXONOMY = "Kingdom";
    public static final String UNK = "Unk";
    public static final String UNDEFINED = "Undefined";
    public static final Map<String, MainTaxonomicRankEnum> RANKS = new HashMap();
    protected EnumMap<MainTaxonomicRankEnum, HashMap<String, ClassificationModel>> aggregations = new EnumMap(MainTaxonomicRankEnum.class);
    private static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$MainTaxonomicRankEnum;

    static {
        MainTaxonomicRankEnum[] mainTaxonomicRankEnumArray = MainTaxonomicRankEnum.values();
        int n = mainTaxonomicRankEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            MainTaxonomicRankEnum rank = mainTaxonomicRankEnumArray[n2];
            RANKS.put(rank.getLabel().toLowerCase(), rank);
            ++n2;
        }
    }

    public String getName() {
        return NAME;
    }

    public void aggregate(TaxonomyProvider row) {
        List matchingTaxon = row.getParents();
        if (matchingTaxon == null || matchingTaxon.size() == 0) {
            return;
        }
        EnumMap groupedTaxon = this.groupTaxonByRank(matchingTaxon);
        MainTaxonomicRankEnum[] mainTaxonomicRankEnumArray = MainTaxonomicRankEnum.values();
        int n = mainTaxonomicRankEnumArray.length;
        int n2 = 0;
        while (n2 < n) {
            String taxonId;
            MainTaxonomicRankEnum aggregationRank = mainTaxonomicRankEnumArray[n2];
            TaxonomyInterface taxon = (TaxonomyInterface)groupedTaxon.get(aggregationRank);
            if (taxon != null && taxon.getName() != null) {
                taxonId = this.addTaxonToAggregation(aggregationRank, taxon, row.getBaseTaxonValue(), row.getBaseTaxonValue(), taxon.getRank());
                this.setClassification(row, aggregationRank, taxonId);
            } else {
                String unknownRank;
                String string = unknownRank = ((TaxonomyInterface)matchingTaxon.get(0)).getRank() != null ? ((TaxonomyInterface)matchingTaxon.get(0)).getRank() : TAXONOMYUNKNOWN;
                if (!row.getBaseTaxonValue().equalsIgnoreCase(TAXONOMYUNKNOWN)) {
                    taxonId = this.addTaxonToAggregation(aggregationRank, (TaxonomyInterface)row.getParents().get(0), row.getBaseTaxonValue(), row.getBaseTaxonValue(), unknownRank);
                    this.setClassification(row, aggregationRank, taxonId);
                } else {
                    String haskKey = "[Unk " + aggregationRank + "]" + " " + unknownRank;
                    String unkName = ((TaxonomyInterface)matchingTaxon.get(0)).getName() != null ? ((TaxonomyInterface)matchingTaxon.get(0)).getName() : TAXONOMYUNKNOWN;
                    taxonId = this.addTaxonToAggregation(aggregationRank, haskKey, unkName, row.getBaseTaxonValue(), row.getBaseTaxonValue(), unknownRank);
                    this.setClassification(row, aggregationRank, taxonId);
                }
            }
            ++n2;
        }
    }

    /*
     * Exception decompiling
     */
    protected void setClassification(TaxonomyProvider input, MainTaxonomicRankEnum rank, String value) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected EnumMap<MainTaxonomicRankEnum, TaxonomyInterface> groupTaxonByRank(List<? extends TaxonomyInterface> listTaxonomyInteface) {
        EnumMap<MainTaxonomicRankEnum, TaxonomyInterface> groupedTaxon = new EnumMap<MainTaxonomicRankEnum, TaxonomyInterface>(MainTaxonomicRankEnum.class);
        for (TaxonomyInterface taxonomyInterface : listTaxonomyInteface) {
            MainTaxonomicRankEnum rank;
            if (taxonomyInterface.getRank() == null || (rank = (MainTaxonomicRankEnum)RANKS.get(taxonomyInterface.getRank().toLowerCase())) == null) continue;
            groupedTaxon.put(rank, taxonomyInterface);
        }
        return groupedTaxon;
    }

    protected String addTaxonToAggregation(MainTaxonomicRankEnum aggregationRank, TaxonomyInterface taxon, String baseTaxonId, String baseTaxonValue, String classificationRank) {
        String taxonName = taxon.getName().toLowerCase();
        return this.addTaxonToAggregation(aggregationRank, taxonName, taxonName, baseTaxonId, baseTaxonValue, classificationRank);
    }

    protected String addTaxonToAggregation(MainTaxonomicRankEnum aggregationRank, String taxonId, String classificationName, String baseTaxonId, String baseTaxonValue, String classificationRank) {
        HashMap aggregation = this.getAggregation(aggregationRank);
        ClassificationModel classification = (ClassificationModel)aggregation.get(taxonId);
        if (classification == null) {
            classification = new ClassificationModel(taxonId, classificationName, classificationRank.toLowerCase(), baseTaxonId, baseTaxonValue, true, 1);
            aggregation.put(taxonId, classification);
        } else {
            classification.incrCountOf();
        }
        return taxonId;
    }

    protected HashMap<String, ClassificationModel> getAggregation(MainTaxonomicRankEnum rank) {
        HashMap aggregation = (HashMap)this.aggregations.get(rank);
        if (aggregation == null) {
            aggregation = new HashMap();
            this.aggregations.put(rank, aggregation);
        }
        return aggregation;
    }

    public EnumMap<MainTaxonomicRankEnum, HashMap<String, ClassificationModel>> getAggregation() {
        return this.aggregations;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$MainTaxonomicRankEnum() {
        if ($SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$MainTaxonomicRankEnum != null) {
            return $SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$MainTaxonomicRankEnum;
        }
        int[] nArray = new int[MainTaxonomicRankEnum.values().length];
        try {
            nArray[MainTaxonomicRankEnum.CLASS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MainTaxonomicRankEnum.FAMILY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MainTaxonomicRankEnum.GENUS.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MainTaxonomicRankEnum.KINGDOM.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MainTaxonomicRankEnum.ORDER.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MainTaxonomicRankEnum.PHYLUM.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MainTaxonomicRankEnum.SPECIES.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$gcube$portlets$user$speciesdiscovery$shared$MainTaxonomicRankEnum = nArray;
        return nArray;
    }
}

