/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.stream;

import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Converter;

public class CSVGenerator<I>
implements CloseableIterator<List<String>> {
    protected Logger logger = Logger.getLogger(CSVGenerator.class);
    protected CloseableIterator<I> source;
    protected Converter<I, List<String>> converter;
    protected List<String> header;
    protected boolean writerHeader = true;

    public CSVGenerator(CloseableIterator<I> source, Converter<I, List<String>> converter, List<String> header) {
        this.source = source;
        this.converter = converter;
        this.header = header;
    }

    public boolean hasNext() {
        return this.writerHeader || this.source.hasNext();
    }

    public List<String> next() {
        assert (this.hasNext());
        if (this.writerHeader) {
            this.writerHeader = false;
            return this.header;
        }
        try {
            Object input = this.source.next();
            List output = (List)this.converter.convert(input);
            return output;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error converting element", (Throwable)e);
            return null;
        }
    }

    public void close() throws IOException {
        this.source.close();
    }

    public void remove() {
    }
}

