/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.detail;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.GroupingStore;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.grid.GridGroupRenderer;
import com.extjs.gxt.ui.client.widget.grid.GridView;
import com.extjs.gxt.ui.client.widget.grid.GroupingView;
import com.extjs.gxt.ui.client.widget.layout.FlowLayout;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import org.gcube.portlets.user.speciesdiscovery.client.detail.SpeciesDetail;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.GridField;
import org.gcube.portlets.user.speciesdiscovery.client.util.SpeciesDetailsFields;
import org.gcube.portlets.user.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.portlets.user.speciesdiscovery.client.util.Util;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;

public class SpeciesDetailsPanel
extends ContentPanel {
    private Image image = new Image(Resources.INSTANCE.getNoPictureAvailable());
    private Grid<SpeciesDetail> grid;
    private GroupingStore<SpeciesDetail> store = new GroupingStore();

    public SpeciesDetailsPanel() {
        this.setLayout((Layout)new FlowLayout());
        this.setHeading("Species Details");
        this.setScrollMode(Style.Scroll.AUTO);
        this.image.setTitle("Species picture");
        this.image.setAltText("");
        this.image.setSize(String.valueOf(Resources.INSTANCE.getNoPictureAvailable().getWidth()), String.valueOf(Resources.INSTANCE.getNoPictureAvailable().getHeight()));
        this.add((Widget)this.image);
        this.store.groupBy(SpeciesDetailsFields.GROUP.getId());
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        ColumnConfig name = Util.createColumnConfig((GridField)SpeciesDetailsFields.NAME, (int)100);
        columns.add(name);
        ColumnConfig value = Util.createColumnConfig((GridField)SpeciesDetailsFields.VALUE, (int)100);
        columns.add(value);
        ColumnModel cm = new ColumnModel(columns);
        GroupingView view = new GroupingView();
        view.setShowGroupedColumn(false);
        view.setForceFit(true);
        view.setSortingEnabled(false);
        view.setStartCollapsed(true);
        view.setGroupRenderer((GridGroupRenderer)new /* Unavailable Anonymous Inner Class!! */);
        this.grid = new Grid((ListStore)this.store, cm);
        this.grid.setView((GridView)view);
        this.grid.setBorders(true);
        this.grid.setHeight(318);
        this.add((Component)this.grid);
    }

    public void setSpeciesData(ModelData data) {
        this.mask("Loading details..");
        String scientificName = (String)data.get(SpeciesGridFields.MATCHING_NAME.getId());
        this.setHeading(String.valueOf(scientificName) + " details.");
        String imageUrl = (String)data.get(SpeciesGridFields.IMAGE.getId());
        this.image.setUrl(imageUrl != null ? imageUrl : Resources.INSTANCE.getNoPictureAvailable().getSafeUri().asString());
        this.image.setAltText("Image for " + scientificName);
        this.image.setTitle(scientificName);
        this.image.setPixelSize(Resources.INSTANCE.getNoPictureAvailable().getWidth(), Resources.INSTANCE.getNoPictureAvailable().getHeight());
        ArrayList<SpeciesDetail> details = new ArrayList<SpeciesDetail>();
        ResultRow row = (ResultRow)data.get(SpeciesGridFields.ROW.getId());
        for (CommonName commonName : row.getCommonNames()) {
            details.add(new SpeciesDetail(commonName.getLanguage(), commonName.getName(), SpeciesGridFields.COMMON_NAMES.getName()));
        }
        details.add(new SpeciesDetail(SpeciesGridFields.DATASOURCE.getName(), row.getDataSourceName(), SpeciesGridFields.PROVENANCE.getName()));
        details.add(new SpeciesDetail(SpeciesGridFields.DATAPROVIDER.getName(), row.getDataProviderName(), SpeciesGridFields.PROVENANCE.getName()));
        details.add(new SpeciesDetail(SpeciesGridFields.DATASET.getName(), row.getDataSetName(), SpeciesGridFields.PROVENANCE.getName()));
        details.add(new SpeciesDetail(SpeciesGridFields.DATASET_CITATION.getName(), row.getDataSetCitation(), SpeciesGridFields.PROVENANCE.getName()));
        details.add(new SpeciesDetail(SpeciesGridFields.PRODUCT_OCCURRENCES.getName(), String.valueOf(row.getOccurencesCount()), SpeciesGridFields.PRODUCTS.getName()));
        this.store.removeAll();
        this.store.add(details);
        this.unmask();
    }
}

