/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;

public class TaxonRowPersistence
extends AbstractPersistence<Taxon> {
    public TaxonRowPersistence(EntityManagerFactory factory) {
        super(factory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int removeAll() throws DatabaseServiceException {
        int removed = 0;
        try (EntityManager em = super.createNewManager();){
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM Taxon").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("DELETED FROM Taxon " + removed + " items"));
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Taxon> getList() throws DatabaseServiceException {
        ArrayList<Taxon> listTaxon = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            Query query = em.createQuery("select t from Taxon t");
            listTaxon = query.getResultList();
        }
        return listTaxon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Taxon> getList(int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<Taxon> listTaxon = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            Query query = em.createQuery("select t from Taxon t");
            query.setFirstResult(startIndex);
            query.setMaxResults(offset);
            listTaxon = query.getResultList();
        }
        return listTaxon;
    }

    public int countItems() throws DatabaseServiceException {
        return this.getList().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Taxon getItemByKey(Integer id) throws DatabaseServiceException {
        this.logger.trace((Object)("getItemByKey id:  " + id));
        Taxon row = null;
        try (EntityManager em = super.createNewManager();){
            row = (Taxon)em.getReference(Taxon.class, (Object)id);
        }
        if (row != null) {
            this.logger.trace((Object)("getItemByKey return row id:  " + row.getId()));
        } else {
            this.logger.trace((Object)"getItemByKey return null");
        }
        return row;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Taxon> executeCriteriaQuery(CriteriaQuery<Object> criteriaQuery) throws DatabaseServiceException {
        ArrayList<Taxon> listTaxon = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            TypedQuery query = em.createQuery(criteriaQuery);
            listTaxon = query.getResultList();
        }
        return listTaxon;
    }

    public CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException {
        return this.createNewManager().getCriteriaBuilder();
    }

    public Root<Taxon> rootFrom(CriteriaQuery<Object> cq) {
        return cq.from(Taxon.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Taxon> getList(Map<String, String> filterMap, int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<Taxon> listTaxon = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            String queryString = "select t from Taxon t";
            if (filterMap != null && filterMap.size() > 0) {
                queryString = queryString + " where ";
                for (String param : filterMap.keySet()) {
                    String value = filterMap.get(param);
                    queryString = queryString + " t." + param + "=" + value;
                    queryString = queryString + "AND";
                }
                queryString = queryString.substring(0, queryString.lastIndexOf("AND"));
            }
            Query query = em.createQuery(queryString);
            listTaxon = query.getResultList();
        }
        return listTaxon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Taxon> executeTypedQuery(CriteriaQuery<Object> cq, int startIndex, int offset) throws DatabaseServiceException {
        ArrayList<Taxon> listTaxon = new ArrayList();
        try (EntityManager em = super.createNewManager();){
            TypedQuery typedQuery = em.createQuery(cq);
            if (startIndex > -1) {
                typedQuery.setFirstResult(startIndex);
            }
            if (offset > -1) {
                typedQuery.setMaxResults(offset);
            }
            listTaxon = typedQuery.getResultList();
        }
        return listTaxon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteItemByIdField(String idField) throws DatabaseServiceException {
        int removed = 0;
        try (EntityManager em = super.createNewManager();){
            em.getTransaction().begin();
            removed = em.createQuery("DELETE FROM Taxon t WHERE t.id='" + idField + "'").executeUpdate();
            em.getTransaction().commit();
            this.logger.trace((Object)("Item " + idField + " was deleted from Taxon"));
        }
        return removed;
    }
}

