/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence.dao;

import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;

public abstract class AbstractPersistence<T> {
    protected EntityManagerFactory entityManagerFactory;
    public final String AND = "AND";
    protected Logger logger = Logger.getLogger(AbstractPersistence.class);

    AbstractPersistence(EntityManagerFactory factory) {
        this.entityManagerFactory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insert(T item) throws DatabaseServiceException {
        EntityManager em = this.createNewManager();
        try {
            em.getTransaction().begin();
            em.persist(item);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in insert: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T update(T item) throws DatabaseServiceException {
        EntityManager em = this.createNewManager();
        try {
            em.getTransaction().begin();
            item = em.merge(item);
            em.getTransaction().commit();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in update: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(T item, boolean transaction) throws DatabaseServiceException {
        EntityManager em = this.createNewManager();
        try {
            if (transaction) {
                em.getTransaction().begin();
                em.remove(item);
                em.getTransaction().commit();
            } else {
                em.remove(item);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in remove: " + e.getMessage()), (Throwable)e);
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
        return true;
    }

    public abstract int removeAll() throws DatabaseServiceException;

    public abstract List<T> getList() throws DatabaseServiceException;

    public abstract List<T> getList(int var1, int var2) throws DatabaseServiceException;

    public abstract int countItems() throws DatabaseServiceException;

    public abstract T getItemByKey(Integer var1) throws DatabaseServiceException;

    public abstract List<T> executeCriteriaQuery(CriteriaQuery<Object> var1) throws DatabaseServiceException;

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    public EntityManager createNewManager() throws DatabaseServiceException {
        try {
            if (this.entityManagerFactory != null) {
                return this.entityManagerFactory.createEntityManager();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred in create new entity manager ", (Throwable)e);
            e.printStackTrace();
            throw new DatabaseServiceException("An error occurred in create new entity manager");
        }
        return null;
    }

    public abstract CriteriaBuilder getCriteriaBuilder() throws DatabaseServiceException;

    public abstract List<T> executeTypedQuery(CriteriaQuery<Object> var1, int var2, int var3) throws DatabaseServiceException;

    public abstract Root<T> rootFrom(CriteriaQuery<Object> var1);

    public abstract List<T> getList(Map<String, String> var1, int var2, int var3) throws DatabaseServiceException;

    public abstract int deleteItemByIdField(String var1) throws DatabaseServiceException;
}

