/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.job;

import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.spd.model.service.types.CompleteJobStatus;
import org.gcube.data.spd.model.service.types.JobStatus;
import org.gcube.portlets.user.speciesdiscovery.server.GisInfoServiceImpl;
import org.gcube.portlets.user.speciesdiscovery.server.job.GisLayerJobUtil;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.GisLayerJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.service.SpeciesService;
import org.gcube.portlets.user.speciesdiscovery.server.util.DateUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.GisLayerJob;
import org.gcube.portlets.user.speciesdiscovery.shared.JobGisLayerModel;

/*
 * Exception performing whole class analysis ignored.
 */
public class GisLayerJobUtil {
    protected static Logger logger = Logger.getLogger(GisLayerJobUtil.class);

    public static JobGisLayerModel createGisLayerJobByOccurrenceKeys(List<String> occurrenceKeys, SpeciesService taxonomyService, String layerTitle, String layerDescr, String author, String credits, long totalPoints, GisLayerJobPersistence gisLayerJob) throws Exception {
        try {
            logger.trace((Object)("Generating Map form Occurrence Keys selected: " + occurrenceKeys.size()));
            String jobId = taxonomyService.generateGisLayerFromOccurrenceKeys(occurrenceKeys, layerTitle, layerDescr, author, credits);
            logger.info((Object)("generated gis layer jobID: " + jobId));
            Date submitTime = DateUtil.getDateFormat((Calendar)Calendar.getInstance());
            GisLayerJob gisLJ = new GisLayerJob(jobId, layerTitle, 0L, submitTime.getTime(), 0L, 0L, layerDescr, DownloadState.PENDING.toString(), null, totalPoints, 0L);
            gisLayerJob.insert((Object)gisLJ);
            JobGisLayerModel jobModel = new JobGisLayerModel(jobId, layerTitle, DownloadState.PENDING, null, submitTime, null, null, layerDescr, 0L, totalPoints, null, null);
            logger.info((Object)("Returning job: " + jobModel));
            return jobModel;
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred creating the map", (Throwable)e);
            throw new Exception(e.getMessage());
        }
    }

    public static JobGisLayerModel convertJob(GisLayerJob job, CompleteJobStatus statusResponse, GisLayerJobPersistence gisLayerJobP, SpeciesService taxonomyService, ASLSession aslSession) {
        DownloadState downloadState = null;
        long endTime = 0L;
        JobStatus status = statusResponse.getStatus();
        downloadState = GisLayerJobUtil.getDownloadState((JobStatus)status);
        logger.trace((Object)("gis layer jobId: " + job.getId() + " download state: " + downloadState));
        if (downloadState == null) {
            return null;
        }
        long submitTime = job.getSubmitTime();
        Date submit = DateUtil.millisecondsToDate((long)submitTime);
        boolean changeStatus = false;
        if (downloadState.equals((Object)DownloadState.COMPLETED) && job.getState().compareTo(DownloadState.SAVED.toString()) == 0) {
            downloadState = DownloadState.SAVED;
            changeStatus = true;
        }
        int completedEntries = 0;
        boolean completedEntriesChanged = false;
        if (statusResponse.getCompletedEntries() > 0) {
            completedEntries = statusResponse.getCompletedEntries();
            job.setCompletedEntries((long)completedEntries);
            completedEntriesChanged = true;
        }
        JobGisLayerModel jobGisModel = new JobGisLayerModel(job.getId(), job.getName(), downloadState, (long)completedEntries, job.getTotalPoints());
        jobGisModel.setSubmitTime(submit);
        jobGisModel.setLayerUUID(job.getLayerUUID());
        jobGisModel.setGisViewerAppLink(job.getGisViewerAppLink());
        jobGisModel.setCompletedPoints((long)completedEntries);
        try {
            boolean changeEndTime = false;
            boolean filledAppLink = false;
            if (downloadState.equals((Object)DownloadState.FAILED) || downloadState.equals((Object)DownloadState.COMPLETED)) {
                String layerUUID = taxonomyService.getGisLayerResultLinkByJobId(job.getId());
                if (statusResponse.getEndDate() != null && job.getEndTime() == 0L) {
                    logger.trace((Object)("UPDATE end time first time only - " + downloadState));
                    endTime = statusResponse.getEndDate().getTimeInMillis();
                    job.setLayerUUID(layerUUID);
                    jobGisModel.setLayerUUID(layerUUID);
                    job.setEndTime(endTime);
                    changeEndTime = true;
                }
                if (downloadState.equals((Object)DownloadState.COMPLETED) && jobGisModel.getGisViewerAppLink() == null) {
                    logger.debug((Object)("UUID is " + layerUUID));
                    String gisLink = GisInfoServiceImpl.getPublicLinkByUUID((String)layerUUID);
                    logger.debug((Object)("public link is " + gisLink));
                    job.setGisViewerAppLink(gisLink);
                    jobGisModel.setGisViewerAppLink(gisLink);
                    filledAppLink = true;
                }
            }
            boolean changeStartTime = false;
            long startTime = job.getStartTime();
            if (statusResponse.getStartDate() != null && startTime == 0L) {
                Date start = DateUtil.millisecondsToDate((long)statusResponse.getStartDate().getTimeInMillis());
                jobGisModel.setStartTime(start);
                changeStartTime = true;
            }
            if (completedEntriesChanged || changeStatus || changeEndTime || changeStartTime || filledAppLink) {
                job.setState(downloadState.toString());
                gisLayerJobP.update((Object)job);
            }
        }
        catch (Exception e) {
            logger.error((Object)"An error occurred on update the  occurrencesJobDao ", (Throwable)e);
        }
        endTime = job.getEndTime();
        long elapsedTime = 0L;
        if (endTime != 0L) {
            Date end = DateUtil.millisecondsToDate((long)endTime);
            jobGisModel.setEndTime(end);
            elapsedTime = endTime;
        } else {
            elapsedTime = Calendar.getInstance().getTimeInMillis();
        }
        jobGisModel.setElapsedTime(DateUtil.getDifference((long)submitTime, (long)elapsedTime));
        return jobGisModel;
    }

    public static DownloadState getDownloadState(JobStatus status) {
        if (status != null) {
            switch (1.$SwitchMap$org$gcube$data$spd$model$service$types$JobStatus[status.ordinal()]) {
                case 1: {
                    return DownloadState.COMPLETED;
                }
                case 2: {
                    return DownloadState.FAILED;
                }
                case 3: {
                    return DownloadState.PENDING;
                }
                case 4: {
                    return DownloadState.ONGOING;
                }
            }
            return null;
        }
        return null;
    }

    public static int deleteGisLayerJobById(String jobIdentifier, GisLayerJobPersistence gisLayerJobDao) {
        logger.trace((Object)("Delete gis layer job id: " + jobIdentifier));
        try {
            int removed = gisLayerJobDao.deleteItemByIdField(jobIdentifier);
            return 1;
        }
        catch (Exception e) {
            logger.error((Object)("An error occured deleteGisLayerJobById  jobId: " + jobIdentifier + " exception: " + e), (Throwable)e);
            logger.trace((Object)("job not exists : " + jobIdentifier));
            return 0;
        }
    }

    public static int changetStatusGisLayerJob(String jobId, DownloadState state, GisLayerJobPersistence gisLayerDAO) {
        logger.trace((Object)("Changing status for Gis Layer job id: " + jobId));
        int result = 0;
        try {
            CriteriaBuilder queryBuilder = gisLayerDAO.getCriteriaBuilder();
            CriteriaQuery cq = queryBuilder.createQuery();
            Predicate pr1 = queryBuilder.equal((Expression)gisLayerDAO.rootFrom(cq).get("id"), (Object)jobId);
            cq.where((Expression)pr1);
            Iterator iterator = gisLayerDAO.executeCriteriaQuery(cq).iterator();
            if (!iterator.hasNext()) {
                return 0;
            }
            GisLayerJob job = (GisLayerJob)iterator.next();
            job.setState(state.toString());
            gisLayerDAO.update((Object)job);
        }
        catch (Exception e) {
            logger.error((Object)("An error occured in updating status for jobId: " + jobId + " exception: " + e), (Throwable)e);
        }
        return result;
    }
}

