/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.core.XDOM;
import com.extjs.gxt.ui.client.widget.Info;
import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.DialogBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.OccurrencesWindow;
import org.gcube.portlets.user.speciesdiscovery.client.SearchBorderLayoutPanel;
import org.gcube.portlets.user.speciesdiscovery.client.SearchController;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.event.ActiveFilterOnResultEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ActiveMaskLoadingGrid;
import org.gcube.portlets.user.speciesdiscovery.client.event.CapabilitySelectedEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ChangeFilterClassificationOnResultEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.CompletedLoadDataSourceEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.CreateGisLayerJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.CreateOccurrenceJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.CreateTaxonomyJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.DisableFilterEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.LoadDataSourceEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ReLoadListJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ReSubmitJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SaveItemsEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SaveJobErrorEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SaveJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchStartedEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchTypeSelectedEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SetCommonNamesEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ShowOccurrencesEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ShowOnlySelectedRowEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.StopCurrentSearchEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.StreamEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.UpdateAllRowSelectionEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.UpdateFilterOnResultEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.UpdateRowSelectionEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ViewDetailsOfSelectedEvent;
import org.gcube.portlets.user.speciesdiscovery.client.job.gislayer.GisLayerJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.occurrence.OccurrenceJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSource;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSourceManager;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamPagingLoader;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.Coordinate;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.JobGisLayerModel;
import org.gcube.portlets.user.speciesdiscovery.shared.JobOccurrencesModel;
import org.gcube.portlets.user.speciesdiscovery.shared.JobTaxonomyModel;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesSaveEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.SaveFileFormat;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchByQueryParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResultType;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;
import org.gcube.portlets.user.speciesdiscovery.shared.util.SearchTermValidator;
import org.gcube.portlets.widgets.wsexplorer.client.notification.WorkspaceExplorerSaveNotification;
import org.gcube.portlets.widgets.wsexplorer.client.save.WorkspaceExplorerSaveDialog;

public class SearchController {
    protected static final int PAGE_SIZE = 25;
    public static EventBus eventBus;
    protected StreamPagingLoader streamPagingLoader;
    protected boolean showOnlySelected = false;
    protected boolean isActiveFilterOnResult = false;
    protected int currentPage = 1;
    protected SearchController instance = null;
    private SearchEvent lastSearchEvent = null;
    private SearchBorderLayoutPanel searchBorderLayoutPanel;
    private DataSourceManager dataSourceManager;

    public SearchController(EventBus eventBus, SearchBorderLayoutPanel searchBorderLayoutPanel) {
        SearchController.eventBus = eventBus;
        this.searchBorderLayoutPanel = searchBorderLayoutPanel;
        this.dataSourceManager = DataSourceManager.getInstance();
        this.streamPagingLoader = new StreamPagingLoader(25);
        this.bind();
        this.instance = this;
    }

    protected void switchDataSource(SpeciesCapability resultType) {
        this.setFiltersCriteria();
        DataSource currentDataSource = this.dataSourceManager.getDataSourceByResultType(resultType);
        Log.trace((String)("current data source: " + currentDataSource.getInfo()));
        this.streamPagingLoader.setDataSource(currentDataSource);
    }

    private void setFiltersCriteria() {
        this.dataSourceManager.setActiveFilters(this.isActiveFilterOnResult);
        this.dataSourceManager.setOnlySelected(this.showOnlySelected);
    }

    public StreamPagingLoader getStreamPagingLoader() {
        return this.streamPagingLoader;
    }

    protected void bind() {
        eventBus.addHandler(UpdateFilterOnResultEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(StreamEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(UpdateAllRowSelectionEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ReSubmitJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ReLoadListJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SearchTypeSelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CreateGisLayerJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SearchEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(StopCurrentSearchEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CreateOccurrenceJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ActiveMaskLoadingGrid.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SaveJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SaveJobErrorEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CreateTaxonomyJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CompletedLoadDataSourceEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ChangeFilterClassificationOnResultEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CapabilitySelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(UpdateRowSelectionEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ShowOccurrencesEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SaveItemsEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ShowOnlySelectedRowEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(LoadDataSourceEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ViewDetailsOfSelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ActiveFilterOnResultEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SetCommonNamesEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(DisableFilterEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void resubmitJob(SearchResultType resultType, String jobIdentifier) {
        if (jobIdentifier != null) {
            if (resultType.equals((Object)SearchResultType.OCCURRENCE_POINT)) {
                SpeciesDiscovery.taxonomySearchService.resubmitOccurrencesJob(jobIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else if (resultType.equals((Object)SearchResultType.TAXONOMY_ITEM)) {
                SpeciesDiscovery.taxonomySearchService.resubmitTaxonomyJob(jobIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else if (resultType.equals((Object)SearchResultType.GIS_LAYER_POINT)) {
                SpeciesDiscovery.taxonomySearchService.resubmitGisLayerJob(jobIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else {
            Info.display((String)"Error", (String)"job identifier is wrong");
        }
    }

    protected void activeFilterOnResult(boolean bool) {
        this.isActiveFilterOnResult = bool;
        this.dataSourceManager.setActiveFilters(this.isActiveFilterOnResult);
    }

    protected void disableFilters() {
        this.activeFilterOnResult(false);
        this.streamPagingLoader.resetFilters();
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().setFilterActive(false, "");
    }

    protected void loadDataSourceFromService() {
        SpeciesDiscovery.taxonomySearchService.loadDataSourceList((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void doActiveMaskLoadingGridAndButtonSearch(boolean mask) {
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().setMaskGridPanel(mask);
        if (mask) {
            this.searchBorderLayoutPanel.getSpeciesWestPanel().mask();
        } else {
            this.searchBorderLayoutPanel.getSpeciesWestPanel().unmask();
        }
        this.searchBorderLayoutPanel.getSpeciesNorthPanel().activeButtonSearch(!mask);
    }

    protected void showFilterResults(boolean onlySelected) {
        Log.trace((String)("showFilterResults ******* onlySelected " + onlySelected));
        this.setOnlySelected(onlySelected);
        this.updateOnlySelectedOnManager(onlySelected);
        this.streamPagingLoader.reset();
        this.streamPagingLoader.pollingState();
        if (onlySelected) {
            this.disableFilters();
            this.streamPagingLoader.setPage(0);
        } else {
            Log.trace((String)("currentPage: " + this.currentPage));
            this.currentPage = this.streamPagingLoader.getCurrentPage();
            this.streamPagingLoader.setPage(this.currentPage);
        }
    }

    public void openOccurenceWindow() {
        OccurrencesWindow occurencesWindow = new OccurrencesWindow();
        occurencesWindow.show();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void saveOccurences(SaveFileFormat fileFormat, OccurrencesSaveEnum typeCSV) {
        String fileName = "Occurrences";
        switch (50.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat[fileFormat.ordinal()]) {
            case 1: {
                fileName = fileName + ".csv";
                break;
            }
            case 2: {
                fileName = fileName + ".xml";
            }
        }
        WorkspaceExplorerSaveDialog navigator = new WorkspaceExplorerSaveDialog("Save " + fileFormat.toString() + " As... ", fileName, false);
        32 listener = new /* Unavailable Anonymous Inner Class!! */;
        int topZIndex = this.getTopZIndex();
        if (topZIndex > -1) {
            navigator.setZIndex(topZIndex);
        }
        navigator.addWorkspaceExplorerSaveNotificationListener((WorkspaceExplorerSaveNotification.WorskpaceExplorerSaveNotificationListener)listener);
        navigator.show();
    }

    private int getTopZIndex() {
        int topZIndex = -1;
        try {
            topZIndex = XDOM.getTopZIndex() + 5;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return topZIndex;
    }

    public void saveTaxonomyJobError(JobTaxonomyModel jobTaxonomyModel, String scientificName, List<org.gcube.portlets.user.speciesdiscovery.shared.DataSource> listDataSources, String rank) {
        String dataSourceName = listDataSources.get(0) != null ? listDataSources.get(0).getName() : "no datasource";
        String fileName = "Error file: " + jobTaxonomyModel.getName() + " from " + dataSourceName + ".txt";
        SpeciesDiscovery.taxonomySearchService.isAvailableTaxonomyJobReportError(jobTaxonomyModel.getIdentifier(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void saveTaxonomyJob(JobTaxonomyModel jobTaxonomyModel, String scientificName, List<org.gcube.portlets.user.speciesdiscovery.shared.DataSource> listDataSources, String rank) {
        String dataSourceName = listDataSources.get(0) != null ? listDataSources.get(0).getName() : "no datasource";
        String fileName = jobTaxonomyModel.getName() + " from " + dataSourceName + " - DWCA.zip";
        WorkspaceExplorerSaveDialog navigator = new WorkspaceExplorerSaveDialog("Save DWCA As...", fileName, false);
        34 listener = new /* Unavailable Anonymous Inner Class!! */;
        int topZIndex = this.getTopZIndex();
        if (topZIndex > -1) {
            navigator.setZIndex(topZIndex);
        }
        navigator.addWorkspaceExplorerSaveNotificationListener((WorkspaceExplorerSaveNotification.WorskpaceExplorerSaveNotificationListener)listener);
        navigator.show();
    }

    private void saveOccurencesJobError(JobOccurrencesModel jobOccurrencesModel, String scientificName, List<org.gcube.portlets.user.speciesdiscovery.shared.DataSource> dataSourceList) {
        String dataSourceName = "";
        for (org.gcube.portlets.user.speciesdiscovery.shared.DataSource dataSource : dataSourceList) {
            dataSourceName = dataSourceName + dataSource.getName() + ",";
        }
        if (dataSourceName.endsWith(",")) {
            dataSourceName = dataSourceName.substring(0, dataSourceName.length() - 1);
        }
        String dataSources = dataSourceName;
        String fileName = "Error file: " + jobOccurrencesModel.getJobName() + " from " + dataSourceName + ".txt";
        SpeciesDiscovery.taxonomySearchService.isAvailableOccurrenceJobReportError(jobOccurrencesModel.getJobIdentifier(), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void saveGisLayerJob(JobGisLayerModel jobGisLayer) {
        String fileName = jobGisLayer.getJobName();
        WorkspaceExplorerSaveDialog navigator = new WorkspaceExplorerSaveDialog("Save Gis Layer", fileName, false);
        36 listener = new /* Unavailable Anonymous Inner Class!! */;
        int topZIndex = this.getTopZIndex();
        if (topZIndex > -1) {
            navigator.setZIndex(topZIndex);
        }
        navigator.addWorkspaceExplorerSaveNotificationListener((WorkspaceExplorerSaveNotification.WorskpaceExplorerSaveNotificationListener)listener);
        navigator.show();
    }

    private void saveOccurencesJob(JobOccurrencesModel jobOccurrencesModel, String scientificName, List<org.gcube.portlets.user.speciesdiscovery.shared.DataSource> dataSourceList) {
        String dataSourceName = "";
        for (org.gcube.portlets.user.speciesdiscovery.shared.DataSource dataSource : dataSourceList) {
            dataSourceName = dataSourceName + dataSource.getName() + ",";
        }
        if (dataSourceName.endsWith(",")) {
            dataSourceName = dataSourceName.substring(0, dataSourceName.lastIndexOf(","));
        }
        String extension = "";
        String suffix = "";
        switch (50.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat[jobOccurrencesModel.getFileFormat().ordinal()]) {
            case 1: {
                suffix = "CSV " + jobOccurrencesModel.getCsvType();
                extension = "csv";
                break;
            }
            case 2: {
                extension = "xml";
                suffix = "DwC";
            }
        }
        String fileName = jobOccurrencesModel.getJobName() + " from " + dataSourceName + " - " + suffix + "." + extension;
        String dataSources = dataSourceName;
        WorkspaceExplorerSaveDialog navigator = new WorkspaceExplorerSaveDialog("Save " + jobOccurrencesModel.getFileFormat().toString() + " As...", fileName, false);
        37 listener = new /* Unavailable Anonymous Inner Class!! */;
        int topZIndex = this.getTopZIndex();
        if (topZIndex > -1) {
            navigator.setZIndex(topZIndex);
        }
        navigator.addWorkspaceExplorerSaveNotificationListener((WorkspaceExplorerSaveNotification.WorskpaceExplorerSaveNotificationListener)listener);
        navigator.show();
    }

    public void changeStatusJob(SearchResultType jobType, String jobId, DownloadState state) {
        if (jobType.equals((Object)SearchResultType.OCCURRENCE_POINT)) {
            SpeciesDiscovery.taxonomySearchService.changeStatusOccurrenceJob(jobId, state, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (jobType.equals((Object)SearchResultType.TAXONOMY_ITEM)) {
            SpeciesDiscovery.taxonomySearchService.changeStatusTaxonomyJob(jobId, state, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (jobType.equals((Object)SearchResultType.GIS_LAYER_POINT)) {
            SpeciesDiscovery.taxonomySearchService.changeStatusGisLayerJob(jobId, state, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void saveTaxonomy(SaveFileFormat fileFormat) {
        String fileName = "Taxonomy";
        switch (50.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat[fileFormat.ordinal()]) {
            case 3: {
                fileName = fileName + ".zip";
            }
        }
        WorkspaceExplorerSaveDialog navigator = new WorkspaceExplorerSaveDialog("Save " + fileFormat.toString() + " As...", fileName, false);
        41 listener = new /* Unavailable Anonymous Inner Class!! */;
        int topZIndex = this.getTopZIndex();
        if (topZIndex > -1) {
            navigator.setZIndex(topZIndex);
        }
        navigator.addWorkspaceExplorerSaveNotificationListener((WorkspaceExplorerSaveNotification.WorskpaceExplorerSaveNotificationListener)listener);
        navigator.show();
    }

    public void showMap(String layerName) {
        Log.trace((String)("Obtaining public link for layer : " + layerName));
        Info.display((String)"Just moment...", (String)"Generating link to layer");
        DialogBox box = new DialogBox(true);
        box.setText("Link to Occurrence Layer (CTRL+C to copy)");
        42 form = new /* Unavailable Anonymous Inner Class!! */;
        box.setWidget((Widget)form);
        box.center();
        SpeciesDiscovery.gisInfoService.getGisLinkByLayerName(layerName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void setOnlySelected(boolean b) {
        this.showOnlySelected = b;
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().activeBtnShowOnlySelected(b);
    }

    private void updateOnlySelectedOnManager(boolean showOnlySelected) {
        this.dataSourceManager.setOnlySelected(showOnlySelected);
    }

    public void reset() {
        this.streamPagingLoader.reset();
        this.streamPagingLoader.setActiveFilterObject(null);
        this.activeFilterOnResult(false);
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().getResultRowPanel().getClassicGridView().unmask();
        this.searchBorderLayoutPanel.getSpeciesWestPanel().unmask();
        this.searchBorderLayoutPanel.getSpeciesWestPanel().resetFilters();
        this.searchBorderLayoutPanel.getSpeciesNorthPanel().enableSearch();
    }

    private void switchView(SpeciesCapability resultType) {
        Log.trace((String)"switchView ... ");
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().updateCurrentGridView(resultType);
    }

    private AsyncCallback<Void> initSearchCallback() {
        this.reset();
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().setFilterActive(false, "");
        this.setOnlySelected(false);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private AsyncCallback<SearchByQueryParameter> initSearchByQueryCallback() {
        this.reset();
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().setFilterActive(false, "");
        this.setOnlySelected(false);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void loadLastQuery(boolean isError) {
        if (isError) {
            this.searchBorderLayoutPanel.getSpeciesSouthPanel().setLastQueryAsEmpty();
            return;
        }
        SpeciesDiscovery.taxonomySearchService.getLastQuery((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void searchByQuery(String query) {
        Log.trace((String)("IN SEARCH BY QUERY..." + query));
        AsyncCallback callback = this.initSearchByQueryCallback();
        query = SearchTermValidator.replaceOccurrenceTermWithProduct((String)query);
        SpeciesDiscovery.taxonomySearchService.searchByQuery(query, callback);
        eventBus.fireEvent((GwtEvent)new SearchStartedEvent());
    }

    protected void search(SearchType type, String searchTerm, Number upperBoundLongitude, Number upperBoundLatitude, Number lowerBoundLongitude, Number lowerBoundLatitude, Date fromDate, Date toDate, List<DataSourceModel> listDataSources, String groupRank, SpeciesCapability resultType, List<DataSourceModel> listDataSourcesForSynonyms, List<DataSourceModel> listDataSourcesForUnfold) {
        GWT.log((String)"IN SEARCH..............");
        Log.trace((String)"IN SEARCH..............");
        AsyncCallback callback = this.initSearchCallback();
        Coordinate upperCoordinate = upperBoundLatitude != null && upperBoundLongitude != null ? new Coordinate(upperBoundLatitude.floatValue(), upperBoundLongitude.floatValue()) : null;
        Coordinate lowerCoordinate = lowerBoundLatitude != null && lowerBoundLongitude != null ? new Coordinate(lowerBoundLatitude.floatValue(), lowerBoundLongitude.floatValue()) : null;
        SearchFilters filters = new SearchFilters(upperCoordinate, lowerCoordinate, fromDate, toDate, listDataSources, groupRank, resultType, listDataSourcesForSynonyms, listDataSourcesForUnfold);
        Log.trace((String)("**********result type: " + filters.getResultType()));
        searchTerm = SearchTermValidator.validateQueryTerm((String)searchTerm);
        switch (50.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SearchType[type.ordinal()]) {
            case 1: {
                GWT.log((String)"search BY_SCIENTIFIC_NAME");
                SpeciesDiscovery.taxonomySearchService.searchByScientificName(searchTerm, filters, callback);
                break;
            }
            case 2: {
                GWT.log((String)"search BY_COMMON_NAME");
                SpeciesDiscovery.taxonomySearchService.searchByCommonName(searchTerm, filters, callback);
            }
        }
        Log.trace((String)("resultType " + resultType));
        this.setDataSourceType(resultType);
        this.switchView(resultType);
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().activeToolBarButtons(true);
        eventBus.fireEvent((GwtEvent)new SearchStartedEvent());
    }

    private void setDataSourceType(SpeciesCapability resultType) {
        this.switchDataSource(resultType);
    }

    protected String getCommonNamesHTML(String scientificName, String author, String credits, List<CommonName> commonNames) {
        StringBuilder html = new StringBuilder("<p><h1 style=\"color: #385F95;\">");
        html.append(scientificName);
        html.append("</h1>");
        if (commonNames.size() > 0) {
            html.append("aka : ");
        }
        html.append("<table>");
        HashSet<String> insertedLanguages = new HashSet<String>();
        for (CommonName commonName : commonNames) {
            if (insertedLanguages.contains(commonName.getLanguage())) continue;
            insertedLanguages.add(commonName.getLanguage());
            html.append("<tr><td><b>");
            html.append(commonName.getLanguage());
            html.append(":</b></td><td>");
            html.append(commonName.getName());
            html.append("</td></tr>");
        }
        html.append("<tr></tr>");
        html.append("<tr><td><b>Inserted by: </b></td><td>");
        html.append(author);
        html.append("</td></tr>");
        html.append("<tr><td><b>Credits: </b></td><td>");
        html.append(credits);
        html.append("</td></tr>");
        html.append("</table>");
        html.append("</p>");
        return html.toString();
    }

    public EventBus getEventBus() {
        return eventBus;
    }

    public SearchEvent getLastSearchEvent() {
        return this.lastSearchEvent;
    }

    public static void excecuteGetJobs(SearchResultType type, boolean resetStructures) {
        System.out.println("New rpc get list SpeciesJobs......." + type);
        if (type.equals((Object)SearchResultType.TAXONOMY_ITEM)) {
            if (resetStructures) {
                TaxonomyJobSpeciesPanel.getInstance((EventBus)eventBus).getGridJob().mask("Loading", "x-mask-loading");
            }
            SpeciesDiscovery.taxonomySearchService.getListTaxonomyJobs((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (type.equals((Object)SearchResultType.OCCURRENCE_POINT)) {
            if (resetStructures) {
                OccurrenceJobSpeciesPanel.getInstance((EventBus)eventBus).getGridJob().mask("Loading", "x-mask-loading");
            }
            SpeciesDiscovery.taxonomySearchService.getListOccurrencesJob((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (type.equals((Object)SearchResultType.GIS_LAYER_POINT)) {
            if (resetStructures) {
                GisLayerJobSpeciesPanel.getInstance((EventBus)eventBus).getGridJob().mask("Loading", "x-mask-loading");
            }
            SpeciesDiscovery.taxonomySearchService.getListGisLayerJob((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ SearchEvent access$000(SearchController x0) {
        return x0.lastSearchEvent;
    }

    static /* synthetic */ SearchBorderLayoutPanel access$100(SearchController x0) {
        return x0.searchBorderLayoutPanel;
    }

    static /* synthetic */ SearchEvent access$002(SearchController x0, SearchEvent x1) {
        x0.lastSearchEvent = x1;
        return x0.lastSearchEvent;
    }

    static /* synthetic */ void access$200(SearchController x0, JobOccurrencesModel x1, String x2, List x3) {
        x0.saveOccurencesJob(x1, x2, x3);
    }

    static /* synthetic */ void access$300(SearchController x0, JobGisLayerModel x1) {
        x0.saveGisLayerJob(x1);
    }

    static /* synthetic */ void access$400(SearchController x0, JobOccurrencesModel x1, String x2, List x3) {
        x0.saveOccurencesJobError(x1, x2, x3);
    }

    static /* synthetic */ void access$500(SearchController x0, boolean x1) {
        x0.setOnlySelected(x1);
    }

    static /* synthetic */ void access$600(SearchController x0, boolean x1) {
        x0.updateOnlySelectedOnManager(x1);
    }

    static /* synthetic */ int access$700(SearchController x0) {
        return x0.getTopZIndex();
    }

    static /* synthetic */ void access$800(SearchController x0, SpeciesCapability x1) {
        x0.setDataSourceType(x1);
    }

    static /* synthetic */ void access$900(SearchController x0, SpeciesCapability x1) {
        x0.switchView(x1);
    }
}

