/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server.persistence;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.log4j.Logger;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.AbstractSelectableDaoBuffer;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.AbstractPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.session.FilterableFetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.MainTaxonomicRankEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;
import org.gcube.portlets.user.speciesdiscovery.shared.filter.FilterCriteria;
import org.gcube.portlets.user.speciesdiscovery.shared.filter.ResultFilter;
import org.gcube.portlets.user.speciesdiscovery.shared.util.NormalizeString;

public class ResultRowBuffer
extends AbstractSelectableDaoBuffer<ResultRow>
implements FilterableFetchingBuffer<ResultRow> {
    protected Logger logger = Logger.getLogger(ResultRowBuffer.class);
    private AbstractPersistence<Taxon> taxonDao;
    private int filteredListSize = 0;

    public ResultRowBuffer(AbstractPersistence<ResultRow> dao, AbstractPersistence<Taxon> taxonDao) {
        super(dao, "id", "selected");
        this.taxonDao = taxonDao;
    }

    public void add(ResultRow row) throws Exception {
        super.add((FetchingElement)row);
    }

    public int getFilteredListSize() throws SQLException {
        return this.filteredListSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultRow> getFilteredList(FilterCriteria filterCriteria) throws SQLException {
        ResultFilter activeFiltersObject = (ResultFilter)filterCriteria;
        ArrayList<ResultRow> list = new ArrayList<ResultRow>();
        Iterator iterator = null;
        if (activeFiltersObject != null) {
            Predicate pr1;
            CriteriaQuery cq;
            String value;
            if (activeFiltersObject.isByClassification()) {
                int counter = activeFiltersObject.getNumberOfData();
                this.logger.trace((Object)("in classification filter - counter: " + counter));
                this.logger.trace((Object)("in classification filter - rank: " + activeFiltersObject.getRankClassification()));
                this.logger.trace((Object)("in classification filter - classification id: " + activeFiltersObject.getClassificationId()));
                String columName = null;
                if (activeFiltersObject.getRankClassification().compareTo(MainTaxonomicRankEnum.KINGDOM.getLabel()) == 0) {
                    columName = "kingdomID";
                } else if (activeFiltersObject.getRankClassification().compareTo(MainTaxonomicRankEnum.FAMILY.getLabel()) == 0) {
                    columName = "familyID";
                } else if (activeFiltersObject.getRankClassification().compareTo(MainTaxonomicRankEnum.GENUS.getLabel()) == 0) {
                    columName = "genusID";
                } else if (activeFiltersObject.getRankClassification().compareTo(MainTaxonomicRankEnum.CLASS.getLabel()) == 0) {
                    columName = "classID";
                } else if (activeFiltersObject.getRankClassification().compareTo(MainTaxonomicRankEnum.ORDER.getLabel()) == 0) {
                    columName = "orderID";
                } else if (activeFiltersObject.getRankClassification().compareTo(MainTaxonomicRankEnum.PHYLUM.getLabel()) == 0) {
                    columName = "phylumID";
                } else if (activeFiltersObject.getRankClassification().compareTo(MainTaxonomicRankEnum.SPECIES.getLabel()) == 0) {
                    columName = "speciesID";
                }
                try {
                    CriteriaBuilder queryBuilder = this.dao.getCriteriaBuilder();
                    Query query = this.dao.createNewManager().createQuery("select r FROM ResultRow r where r." + columName + "='" + activeFiltersObject.getClassificationId() + "'");
                    query.setMaxResults(counter);
                    iterator = query.getResultList().iterator();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error in activeFiltersObject.isByClassification(): " + e), (Throwable)e);
                }
            } else if (activeFiltersObject.isByDataProvider()) {
                try {
                    CriteriaBuilder queryBuilder = this.dao.getCriteriaBuilder();
                    value = activeFiltersObject.getDataProviderName();
                    cq = queryBuilder.createQuery();
                    pr1 = queryBuilder.equal((Expression)this.dao.rootFrom(cq).get("dataProviderName"), (Object)value);
                    cq.where((Expression)pr1);
                    this.logger.trace((Object)("FILTER BY DATA PROVIDER: " + value));
                    iterator = this.dao.executeCriteriaQuery(cq).iterator();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error in activeFiltersObject.isByDataProvider(): " + e), (Throwable)e);
                    e.printStackTrace();
                }
            } else if (activeFiltersObject.isByDataSourceName()) {
                try {
                    CriteriaBuilder queryBuilder = this.dao.getCriteriaBuilder();
                    value = activeFiltersObject.getDataSourceName();
                    cq = queryBuilder.createQuery();
                    pr1 = queryBuilder.equal((Expression)this.dao.rootFrom(cq).get("dataSourceName"), (Object)NormalizeString.validateUndefined((String)value));
                    cq.where((Expression)pr1);
                    this.logger.trace((Object)("FILTER BY DATA DATA SOURCE NAME: " + value));
                    iterator = this.dao.executeCriteriaQuery(cq).iterator();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error in activeFiltersObject.isByDataSourceName(): " + e), (Throwable)e);
                    e.printStackTrace();
                }
            } else if (activeFiltersObject.isByRank()) {
                try {
                    value = activeFiltersObject.getRankName();
                    EntityManager em = this.dao.createNewManager();
                    String queryString = "select * FROM " + ResultRow.class.getSimpleName() + " r INNER JOIN RESULTROW_TAXON rt on r.ID=rt.RESULTROW_ID INNER JOIN " + Taxon.class.getSimpleName() + " t on t.INTERNALID=rt.MATCHINGTAXON_INTERNALID where t.RANK = '" + value + "' and t.ID IN (select MIN(tax.ID) from TAXON tax)";
                    Query query = em.createNativeQuery(queryString, ResultRow.class);
                    List listResultRow = new ArrayList();
                    try {
                        listResultRow = query.getResultList();
                    }
                    catch (Exception e) {
                        this.logger.error((Object)("Error in ResultRow - executeCriteriaQuery: " + e.getMessage()), (Throwable)e);
                    }
                    finally {
                        em.close();
                    }
                    iterator = listResultRow.iterator();
                }
                catch (Exception e) {
                    this.logger.error((Object)("Error in activeFiltersObject.isByRank(): " + e), (Throwable)e);
                    e.printStackTrace();
                }
            }
            if (iterator != null) {
                while (iterator.hasNext()) {
                    ResultRow row = (ResultRow)iterator.next();
                    list.add(row);
                }
                this.filteredListSize = list.size();
            }
        }
        this.logger.trace((Object)("RETURNED List size " + list.size()));
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllSelection(boolean selection) throws Exception {
        EntityManager em = this.dao.createNewManager();
        try {
            em.getTransaction().begin();
            int updateCount = em.createQuery("UPDATE ResultRow SET selected = " + selection).executeUpdate();
            this.logger.trace((Object)("Updated " + updateCount + " item"));
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllSelectionByIds(boolean selection, List<String> listIds) throws Exception {
        EntityManager em = this.dao.createNewManager();
        String queryString = "UPDATE ResultRow t SET selected = " + selection + " where  " + "id" + " IN :inclList";
        try {
            em.getTransaction().begin();
            TypedQuery query = em.createQuery(queryString, ResultRow.class);
            query.setParameter("inclList", listIds);
            int updateCount = query.executeUpdate();
            this.logger.trace((Object)("Updated " + updateCount + " item"));
            em.getTransaction().commit();
        }
        finally {
            if (em.getTransaction().isActive()) {
                em.getTransaction().rollback();
            }
            em.close();
        }
    }
}

