/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.resultview;

import com.extjs.gxt.ui.client.data.ModelData;
import com.extjs.gxt.ui.client.store.ListStore;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.grid.ColumnConfig;
import com.extjs.gxt.ui.client.widget.grid.ColumnModel;
import com.extjs.gxt.ui.client.widget.grid.Grid;
import com.extjs.gxt.ui.client.widget.layout.AnchorData;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.extjs.gxt.ui.client.widget.layout.LayoutData;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.client.util.GridField;
import org.gcube.portlets.user.speciesdiscovery.client.util.JavascriptInjector;
import org.gcube.portlets.user.speciesdiscovery.client.util.SpeciesGridFields;
import org.gcube.portlets.user.speciesdiscovery.client.util.TaxonomyGridField;
import org.gcube.portlets.user.speciesdiscovery.client.util.Util;
import org.gcube.portlets.user.speciesdiscovery.client.view.SpeciesViewInterface;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;

public class DescriptiveTaxonomyGrid
extends ContentPanel
implements SpeciesViewInterface {
    protected static final String TOGGLE_CLASS = "SPECIES_TOGGLE";
    private Grid<ModelData> grid;

    public DescriptiveTaxonomyGrid(ListStore<ModelData> store) {
        this.setLayout((Layout)new FitLayout());
        this.setHeaderVisible(false);
        ArrayList<ColumnConfig> columns = new ArrayList<ColumnConfig>();
        ColumnConfig descriptiveName = Util.createColumnConfig((GridField)TaxonomyGridField.SCIENTIFIC_NAME, (int)250);
        columns.add(descriptiveName);
        JavascriptInjector.inject((String)Resources.INSTANCE.getToggleJavaScript().getText());
        ColumnConfig descriptiveTaxonomy = Util.createColumnConfig((GridField)TaxonomyGridField.TAXONOMY, (int)350);
        columns.add(descriptiveTaxonomy);
        ColumnConfig datasourceColumn = Util.createColumnConfig((GridField)TaxonomyGridField.PROVENANCE, (int)350);
        columns.add(datasourceColumn);
        ColumnConfig productsColumn = Util.createColumnConfig((GridField)TaxonomyGridField.PRODUCTS, (int)350);
        columns.add(productsColumn);
        ColumnModel descriptiveColumnModel = new ColumnModel(columns);
        this.grid = new Grid(store, descriptiveColumnModel);
        this.grid.setBorders(true);
        this.grid.setStripeRows(true);
        this.add((Widget)this.grid, (LayoutData)new AnchorData("100% 100%"));
    }

    protected void onShow() {
        super.onShow();
        this.reload();
    }

    public void reload() {
    }

    public List<ResultRow> getSelectedRows() {
        LinkedList<ResultRow> selectedRows = new LinkedList<ResultRow>();
        for (ModelData selected : this.grid.getSelectionModel().getSelectedItems()) {
            selectedRows.add((ResultRow)selected.get(SpeciesGridFields.ROW.getId()));
        }
        return selectedRows;
    }

    public void setBodyStyleAsFiltered(boolean isFiltered) {
        if (this.getElement("body") != null) {
            if (isFiltered) {
                this.getElement("body").getStyle().setBorderColor("#32CD32");
            } else {
                this.getElement("body").getStyle().setBorderColor("#99BBE8");
            }
        }
    }

    public ContentPanel getPanel() {
        return this;
    }
}

