/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client.job.occurrence;

import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Html;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.LayoutContainer;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.AbstractImagePrototype;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.portlets.user.speciesdiscovery.client.job.occurrence.OccurrenceGridJob;
import org.gcube.portlets.user.speciesdiscovery.client.job.occurrence.OccurrenceJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.occurrence.OccurrenceJobSpeciesProgressBar;
import org.gcube.portlets.user.speciesdiscovery.client.job.occurrence.OccurrenceWindowInfoJobsSpecies;
import org.gcube.portlets.user.speciesdiscovery.client.resources.Resources;
import org.gcube.portlets.user.speciesdiscovery.shared.JobOccurrencesModel;

public class OccurrenceJobSpeciesPanel
extends ContentPanel {
    private static OccurrenceJobSpeciesPanel instance;
    private static ContentPanel cp;
    private ContentPanel vp;
    private static HashMap<String, OccurrenceJobSpeciesProgressBar> hashProgressBars;
    private static HashMap<String, Boolean> hashLoadCompletedNotify;
    private static HashMap<String, ContentPanel> hashTableContentPanels;
    private static String LASTOPERATION;
    private Html lastOperation = new Html(LASTOPERATION);
    private LayoutContainer lc;
    private static String WINDOWTITLE;
    private static final String FAILED = "failed";
    private static final String COMPLETED = "completed";
    private static final String LOADING = "loading";
    private static final String PENDING = "pending";
    private static final String OPERATIONONE = "none";
    private static final String SAVING = "saving";
    private OccurrenceGridJob gridJob;
    private EventBus eventBus;
    protected Window speciesJobWindow = new Window();

    public static synchronized OccurrenceJobSpeciesPanel getInstance(EventBus eventBus) {
        if (instance == null) {
            instance = new OccurrenceJobSpeciesPanel(eventBus);
        }
        return instance;
    }

    private OccurrenceJobSpeciesPanel(EventBus eventBus) {
        this.eventBus = eventBus;
        this.gridJob = new OccurrenceGridJob(eventBus);
        this.setHeaderVisible(false);
        this.setLayout((Layout)new FitLayout());
        this.createSpeciesJobWindow();
    }

    private void createSpeciesJobWindow() {
        this.lc = new LayoutContainer();
        this.lc.setStyleAttribute("margin", "5px");
        cp = new ContentPanel();
        cp.setBodyBorder(true);
        cp.setStyleAttribute("padding", "5px");
        cp.setLayout((Layout)new FitLayout());
        cp.add((Widget)this.gridJob);
        cp.setHeight(550);
        cp.setHeaderVisible(false);
        hashProgressBars = new HashMap();
        hashTableContentPanels = new HashMap();
        hashLoadCompletedNotify = new HashMap();
        cp.setScrollMode(Style.Scroll.AUTO);
        this.lastOperation.setHtml(LASTOPERATION + OPERATIONONE);
        this.lc.add((Widget)this.lastOperation);
        this.lc.add((Widget)cp);
        this.speciesJobWindow.setHeading(WINDOWTITLE);
        this.speciesJobWindow.setIcon(AbstractImagePrototype.create((ImageResource)Resources.INSTANCE.getBluePlace16px()));
        this.speciesJobWindow.setSize(1020, 600);
        this.speciesJobWindow.setResizable(true);
        this.speciesJobWindow.setScrollMode(Style.Scroll.AUTOX);
        this.speciesJobWindow.add((Widget)this.lc);
    }

    public void addListJob(List<JobOccurrencesModel> jobsModel) {
        for (JobOccurrencesModel jobModel : jobsModel) {
            this.addJob(jobModel);
        }
    }

    public boolean addJob(JobOccurrencesModel jobModel) {
        boolean isLoading = false;
        OccurrenceJobSpeciesProgressBar jobsBar = (OccurrenceJobSpeciesProgressBar)hashProgressBars.get(jobModel.getJobIdentifier());
        if (jobsBar != null) {
            OccurrenceWindowInfoJobsSpecies win = (OccurrenceWindowInfoJobsSpecies)jobsBar.getData("win");
            if (win != null) {
                win.updateDescription(jobModel);
                win.layout();
                jobsBar.setData("win", (Object)win);
            }
            if (jobsBar.isCompleted()) {
                return true;
            }
            this.updateProgressBarView(jobsBar, jobModel);
            this.gridJob.updateStatus(jobModel, jobsBar);
        } else {
            OccurrenceJobSpeciesProgressBar jobProgressBar = new OccurrenceJobSpeciesProgressBar(jobModel.getJobIdentifier(), jobModel.getDownloadState().toString());
            this.gridJob.addJobIntoGrid(jobModel, jobProgressBar);
            this.updateProgressBarView(jobProgressBar, jobModel);
            hashProgressBars.put(jobModel.getJobIdentifier(), jobProgressBar);
            hashLoadCompletedNotify.put(jobModel.getJobIdentifier(), false);
        }
        this.gridJob.layout();
        cp.layout();
        return isLoading;
    }

    private boolean updateProgressBarView(OccurrenceJobSpeciesProgressBar jobsBar, JobOccurrencesModel jobModel) {
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$DownloadState[jobModel.getDownloadState().ordinal()]) {
            case 1: {
                jobsBar.setProgressText(PENDING);
                break;
            }
            case 2: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getJobName() + " saving");
                jobsBar.getElement().getStyle().setBorderColor("#7093DB");
                jobsBar.setProgressText(SAVING);
                break;
            }
            case 3: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getJobName() + " completed");
                jobsBar.getElement().getStyle().setBorderColor("#000000");
                jobsBar.updateProgressWithoutPercentage(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(COMPLETED);
                break;
            }
            case 4: {
                if (jobModel.getPercentage() < 100.0f) {
                    jobsBar.setProgressText(LOADING);
                } else {
                    jobsBar.setProgressText(SAVING);
                }
                jobsBar.updateProgressWithPercentage(jobModel.getPercentage());
                return true;
            }
            case 5: {
                this.lastOperation.setHtml(LASTOPERATION + jobModel.getJobName() + " saved");
                jobsBar.getElement().getStyle().setBorderColor("#000000");
                jobsBar.updateProgressWithoutPercentage(100.0f);
                jobsBar.setCompleted(true);
                jobsBar.updateText(COMPLETED);
                break;
            }
            case 6: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                jobsBar.updateText("loading " + jobModel.getJobName() + " with failures");
                break;
            }
            case 7: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                jobsBar.setProgressText(FAILED);
                jobsBar.updateProgressWithPercentage(jobModel.getPercentage());
                jobsBar.setCompleted(true);
                jobsBar.updateText(FAILED);
                break;
            }
            case 8: {
                jobsBar.getElement().getStyle().setBorderColor("#f00");
                jobsBar.updateText("loading " + jobModel.getJobName() + " with failures");
                jobsBar.updateProgressWithoutPercentage(100.0f);
                jobsBar.setCompleted(true);
            }
        }
        return false;
    }

    public void removeSpeciesJob(String hashHPKey) {
        ContentPanel cp = (ContentPanel)hashTableContentPanels.get(hashHPKey);
        this.vp.remove((Widget)cp);
        this.lastOperation.setHtml(LASTOPERATION + cp.getId() + " deleted");
        hashProgressBars.remove(hashHPKey);
        hashTableContentPanels.remove(hashHPKey);
        hashLoadCompletedNotify.remove(hashHPKey);
        this.vp.layout();
    }

    private void deleteProgressCompleted(List<String> progressIdFound) {
        OccurrenceJobSpeciesProgressBar bulkPB;
        ArrayList<String> progressIdNotFound = new ArrayList<String>();
        for (String key : hashTableContentPanels.keySet()) {
            if (progressIdFound.contains(key)) continue;
            bulkPB = (OccurrenceJobSpeciesProgressBar)hashProgressBars.get(key);
            this.lastOperation.setHtml(LASTOPERATION + bulkPB.getProgressText() + " uploading completed");
            progressIdNotFound.add(key);
        }
        for (String key : progressIdNotFound) {
            bulkPB = (OccurrenceJobSpeciesProgressBar)hashProgressBars.get(key);
            this.lastOperation.setHtml(LASTOPERATION + bulkPB.getProgressText() + " uploading completed");
            hashProgressBars.remove(key);
            hashTableContentPanels.remove(key);
        }
        this.vp.layout();
        cp.layout();
    }

    public Window getSpeciesJobWindow() {
        return this.speciesJobWindow;
    }

    public void resetStructures() {
        this.gridJob.resetStore();
        hashProgressBars.clear();
        this.lastOperation.setHtml(LASTOPERATION);
        hashTableContentPanels.clear();
        hashLoadCompletedNotify.clear();
    }

    public OccurrenceGridJob getGridJob() {
        return this.gridJob;
    }

    static {
        LASTOPERATION = "Last Operation: ";
        WINDOWTITLE = "Species Occurrence Jobs";
    }
}

