/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.client;

import com.allen_sauer.gwt.log.client.Log;
import com.extjs.gxt.ui.client.widget.Info;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.shared.EventBus;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.gcube.portlets.user.gcubegisviewer.client.GCubeGisViewer;
import org.gcube.portlets.user.gcubegisviewer.client.event.SaveHandler;
import org.gcube.portlets.user.gisviewer.client.GisViewerParameters;
import org.gcube.portlets.user.speciesdiscovery.client.OccurrencesWindow;
import org.gcube.portlets.user.speciesdiscovery.client.SearchBorderLayoutPanel;
import org.gcube.portlets.user.speciesdiscovery.client.SearchController;
import org.gcube.portlets.user.speciesdiscovery.client.SpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.event.ActiveButtonCheckAllRowEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ActiveFilterOnResultEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ActiveMaskLoadingGrid;
import org.gcube.portlets.user.speciesdiscovery.client.event.CapabilitySelectedEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ChangeFilterClassificationOnResultEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.CompletedLoadDataSourceEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.CreateOccurrenceJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.CreateTaxonomyJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.DisableFilterEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.LoadDataSourceEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ReLoadListJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ReSubmitJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SaveItemsEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SaveJobEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SearchStartedEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.SetCommonNamesEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ShowOccurrencesEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ShowOccurrencesMapEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ShowOnlySelectedRowEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.UpdateAllRowSelectionEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.UpdateFilterOnResultEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.UpdateRowSelectionEvent;
import org.gcube.portlets.user.speciesdiscovery.client.event.ViewDetailsOfSelectedEvent;
import org.gcube.portlets.user.speciesdiscovery.client.job.occurrence.OccurrenceJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.job.taxonomy.TaxonomyJobSpeciesPanel;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSource;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.DataSourceManager;
import org.gcube.portlets.user.speciesdiscovery.client.util.stream.StreamPagingLoader;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.Coordinate;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.JobOccurrencesModel;
import org.gcube.portlets.user.speciesdiscovery.shared.JobTaxonomyModel;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesSaveEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.SaveFileFormat;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResultType;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.SpeciesCapability;
import org.gcube.portlets.user.workspace.lighttree.client.ItemType;
import org.gcube.portlets.user.workspace.lighttree.client.event.DataLoadHandler;
import org.gcube.portlets.user.workspace.lighttree.client.event.PopupHandler;
import org.gcube.portlets.user.workspace.lighttree.client.save.WorkspaceLightTreeSavePopup;

public class SearchController {
    protected static final int PAGE_SIZE = 25;
    public static EventBus eventBus;
    protected StreamPagingLoader streamPagingLoader;
    protected boolean showOnlySelected = false;
    protected boolean isActiveFilterOnResult = false;
    protected int currentPage = 1;
    protected SearchController instance = null;
    private SearchEvent lastSearchEvent = null;
    private SearchBorderLayoutPanel searchBorderLayoutPanel;
    private DataSourceManager dataSourceManager;

    public SearchController(EventBus eventBus, SearchBorderLayoutPanel searchBorderLayoutPanel) {
        SearchController.eventBus = eventBus;
        this.searchBorderLayoutPanel = searchBorderLayoutPanel;
        this.dataSourceManager = DataSourceManager.getInstance();
        this.streamPagingLoader = new StreamPagingLoader(25);
        this.bind();
        this.instance = this;
    }

    protected void switchDataSource(SpeciesCapability resultType) {
        this.setFiltersCriteria();
        DataSource currentDataSource = this.dataSourceManager.getDataSourceByResultType(resultType);
        Log.trace((String)("current data source: " + currentDataSource.getInfo()));
        this.streamPagingLoader.setDataSource(currentDataSource);
    }

    private void setFiltersCriteria() {
        this.dataSourceManager.setActiveFilters(this.isActiveFilterOnResult);
        this.dataSourceManager.setOnlySelected(this.showOnlySelected);
    }

    public StreamPagingLoader getStreamPagingLoader() {
        return this.streamPagingLoader;
    }

    protected void bind() {
        eventBus.addHandler(UpdateFilterOnResultEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ActiveButtonCheckAllRowEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(UpdateAllRowSelectionEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ReSubmitJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ReLoadListJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SearchEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CreateOccurrenceJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ActiveMaskLoadingGrid.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SaveJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CreateTaxonomyJobEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CompletedLoadDataSourceEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ChangeFilterClassificationOnResultEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(CapabilitySelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(UpdateRowSelectionEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ShowOccurrencesEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SaveItemsEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ShowOccurrencesMapEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ShowOnlySelectedRowEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(LoadDataSourceEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ViewDetailsOfSelectedEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(ActiveFilterOnResultEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(SetCommonNamesEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
        eventBus.addHandler(DisableFilterEvent.TYPE, (EventHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void resubmitJob(SearchResultType resultType, String jobIdentifier) {
        if (jobIdentifier != null) {
            if (resultType.equals((Object)SearchResultType.OCCURRENCE_POINT)) {
                SpeciesDiscovery.taxonomySearchService.resubmitOccurrencesJob(jobIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            } else if (resultType.equals((Object)SearchResultType.TAXONOMY_ITEM)) {
                SpeciesDiscovery.taxonomySearchService.resubmitTaxonomyJob(jobIdentifier, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
            }
        } else {
            Info.display((String)"Error", (String)"job identifier is wrong");
        }
    }

    protected void activeFilterOnResult(boolean bool) {
        this.isActiveFilterOnResult = bool;
        this.dataSourceManager.setActiveFilters(this.isActiveFilterOnResult);
    }

    protected void disableFilters() {
        this.activeFilterOnResult(false);
        this.streamPagingLoader.resetFilters();
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().setFilterActive(false, "");
    }

    protected void loadDataSourceFromService() {
        SpeciesDiscovery.taxonomySearchService.loadDataSourceList((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected void doActiveMaskLoadingGridAndButtonSearch(boolean mask) {
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().setMaskGridPanel(mask);
        if (mask) {
            this.searchBorderLayoutPanel.getSpeciesWestPanel().mask();
        } else {
            this.searchBorderLayoutPanel.getSpeciesWestPanel().unmask();
        }
        this.searchBorderLayoutPanel.getSpeciesNorthPanel().activeButtonSearch(!mask);
    }

    protected void showFilterResults(boolean onlySelected) {
        Log.trace((String)("showFilterResults ******* onlySelected " + onlySelected));
        this.setOnlySelected(onlySelected);
        this.updateOnlySelectedOnManager(onlySelected);
        this.streamPagingLoader.reset();
        this.streamPagingLoader.pollingState();
        if (onlySelected) {
            this.disableFilters();
            this.streamPagingLoader.setPage(0);
        } else {
            Log.trace((String)("currentPage: " + this.currentPage));
            this.currentPage = this.streamPagingLoader.getCurrentPage();
            this.streamPagingLoader.setPage(this.currentPage);
        }
    }

    public void openOccurenceWindow() {
        OccurrencesWindow occurencesWindow = new OccurrencesWindow();
        occurencesWindow.show();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void saveOccurences(SaveFileFormat fileFormat, OccurrencesSaveEnum typeCSV) {
        String fileName = "Occurrences";
        switch (44.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat[fileFormat.ordinal()]) {
            case 1: {
                fileName = fileName + ".csv";
                break;
            }
            case 2: {
                fileName = fileName + ".xml";
            }
        }
        WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Occurrence points", true, fileName);
        popup.setModal(false);
        popup.setSelectableTypes(new ItemType[]{ItemType.FOLDER, ItemType.ROOT});
        popup.center();
        popup.addPopupHandler((PopupHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.addDataLoadHandler((DataLoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.getElement().getStyle().setZIndex(10001);
        popup.show();
    }

    public void saveTaxonomyJob(JobTaxonomyModel jobTaxonomyModel, String scientificName, List<org.gcube.portlets.user.speciesdiscovery.shared.DataSource> listDataSources, String rank) {
        String dataSourceName = listDataSources.get(0) != null ? listDataSources.get(0).getName() : "no datasource";
        String fileName = "DWCA " + rank + " -" + scientificName + "- from " + dataSourceName + ".zip";
        WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Job", true, fileName);
        popup.setModal(false);
        popup.setSelectableTypes(new ItemType[]{ItemType.FOLDER, ItemType.ROOT});
        popup.center();
        popup.addPopupHandler((PopupHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.addDataLoadHandler((DataLoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    private void saveOccurencesJob(JobOccurrencesModel jobOccurrencesModel, String scientificName, List<org.gcube.portlets.user.speciesdiscovery.shared.DataSource> dataSourceList) {
        String dataSourceName = "";
        for (org.gcube.portlets.user.speciesdiscovery.shared.DataSource dataSource : dataSourceList) {
            dataSourceName = dataSourceName + dataSource.getName() + "-";
        }
        dataSourceName = dataSourceName.substring(0, dataSourceName.lastIndexOf("-"));
        String extension = null;
        switch (44.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat[jobOccurrencesModel.getFileFormat().ordinal()]) {
            case 1: {
                extension = "csv";
                break;
            }
            case 2: {
                extension = "xml";
            }
        }
        String fileName = "Occurrences results of " + scientificName + "- from " + dataSourceName + "." + extension;
        WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Occurrence points", true, fileName);
        popup.setModal(false);
        popup.setSelectableTypes(new ItemType[]{ItemType.FOLDER, ItemType.ROOT});
        popup.center();
        String dataSources = dataSourceName;
        popup.addPopupHandler((PopupHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.addDataLoadHandler((DataLoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    public void changeStatusJob(SearchResultType jobType, String jobId, DownloadState state) {
        if (jobType.equals((Object)SearchResultType.OCCURRENCE_POINT)) {
            SpeciesDiscovery.taxonomySearchService.changeStatusOccurrenceJob(jobId, state, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (jobType.equals((Object)SearchResultType.TAXONOMY_ITEM)) {
            SpeciesDiscovery.taxonomySearchService.changeStatusTaxonomyJob(jobId, state, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void saveTaxonomy(SaveFileFormat fileFormat) {
        String fileName = "Taxonomy";
        switch (44.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat[fileFormat.ordinal()]) {
            case 3: {
                fileName = fileName + ".zip";
            }
        }
        WorkspaceLightTreeSavePopup popup = new WorkspaceLightTreeSavePopup("Select where to save the Taxonomy", true, fileName);
        popup.setModal(false);
        popup.setSelectableTypes(new ItemType[]{ItemType.FOLDER, ItemType.ROOT});
        popup.center();
        popup.addPopupHandler((PopupHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.addDataLoadHandler((DataLoadHandler)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    public void showOccurrencesMap() {
        MessageBox progress = MessageBox.wait((String)"Generating map", (String)"Calculating occurrence points", (String)"generating...");
        SpeciesDiscovery.taxonomySearchService.generateMapFromSelectedOccurrencePoints((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void showMap(String layerName) {
        Log.trace((String)("show Map layer name returned: " + layerName));
        GisViewerParameters gisViewerParameters = new GisViewerParameters();
        ArrayList<String> layers = new ArrayList<String>();
        layers.add("environments");
        layers.add("sstAnMean");
        layers.add("primProdMean");
        layers.add("salinityMean");
        layers.add("eezall");
        layers.add("faoarea");
        layers.add("lme");
        layers.add("DepthMeanAnnual");
        layers.add(layerName);
        gisViewerParameters.setOpeningLayers(layers);
        GCubeGisViewer gisViewer = new GCubeGisViewer(gisViewerParameters);
        gisViewer.addSaveHandler((SaveHandler)new /* Unavailable Anonymous Inner Class!! */);
        gisViewer.setMaskOnSaveEvents();
        gisViewer.show();
    }

    private void setOnlySelected(boolean b) {
        this.showOnlySelected = b;
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().activeBtnShowOnlySelected(b);
    }

    private void updateOnlySelectedOnManager(boolean showOnlySelected) {
        this.dataSourceManager.setOnlySelected(showOnlySelected);
    }

    public void reset() {
        this.streamPagingLoader.reset();
        this.streamPagingLoader.setActiveFilterObject(null);
        this.activeFilterOnResult(false);
    }

    private void switchView(SpeciesCapability resultType) {
        Log.trace((String)"switchView ... ");
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().updateCurrentGridView(resultType);
    }

    private AsyncCallback<Void> initSearch() {
        this.reset();
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().setFilterActive(false, "");
        this.setOnlySelected(false);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private AsyncCallback<SearchResultType> initSearchByQuery() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void searchByQuery(String query) {
        Log.trace((String)("IN SEARCH BY QUERY..." + query));
        AsyncCallback callback = this.initSearchByQuery();
        this.reset();
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().setFilterActive(false, "");
        this.setOnlySelected(false);
        SpeciesDiscovery.taxonomySearchService.searchByQuery(query, callback);
        eventBus.fireEvent((GwtEvent)new SearchStartedEvent());
    }

    protected void search(SearchType type, String searchTerm, Number upperBoundLongitude, Number upperBoundLatitude, Number lowerBoundLongitude, Number lowerBoundLatitude, Date fromDate, Date toDate, List<DataSourceModel> listDataSources, String groupRank, SpeciesCapability resultType) {
        Log.trace((String)"IN SEARCH..............");
        AsyncCallback callback = this.initSearch();
        Coordinate upperCoordinate = upperBoundLatitude != null && upperBoundLongitude != null ? new Coordinate(upperBoundLatitude.floatValue(), upperBoundLongitude.floatValue()) : null;
        Coordinate lowerCoordinate = lowerBoundLatitude != null && lowerBoundLongitude != null ? new Coordinate(lowerBoundLatitude.floatValue(), lowerBoundLongitude.floatValue()) : null;
        SearchFilters filters = new SearchFilters(upperCoordinate, lowerCoordinate, fromDate, toDate, listDataSources, groupRank, resultType);
        Log.trace((String)("**********result type: " + filters.getResultType()));
        switch (44.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SearchType[type.ordinal()]) {
            case 1: {
                SpeciesDiscovery.taxonomySearchService.searchByScientificName(searchTerm, filters, callback);
                break;
            }
            case 2: {
                SpeciesDiscovery.taxonomySearchService.searchByCommonName(searchTerm, filters, callback);
            }
        }
        Log.trace((String)("resultType " + resultType));
        this.setDataSourceType(resultType);
        this.switchView(resultType);
        this.searchBorderLayoutPanel.getSpeciesCenterPanel().activeToolBarButtons(true);
        eventBus.fireEvent((GwtEvent)new SearchStartedEvent());
    }

    private void setDataSourceType(SpeciesCapability resultType) {
        this.switchDataSource(resultType);
    }

    protected String getCommonNamesHTML(String scientificName, String author, String credits, List<CommonName> commonNames) {
        StringBuilder html = new StringBuilder("<p><h1 style=\"color: #385F95;\">");
        html.append(scientificName);
        html.append("</h1>");
        if (commonNames.size() > 0) {
            html.append("aka : ");
        }
        html.append("<table>");
        HashSet<String> insertedLanguages = new HashSet<String>();
        for (CommonName commonName : commonNames) {
            if (insertedLanguages.contains(commonName.getLanguage())) continue;
            insertedLanguages.add(commonName.getLanguage());
            html.append("<tr><td><b>");
            html.append(commonName.getLanguage());
            html.append(":</b></td><td>");
            html.append(commonName.getName());
            html.append("</td></tr>");
        }
        html.append("<tr></tr>");
        html.append("<tr><td><b>Inserted by: </b></td><td>");
        html.append(author);
        html.append("</td></tr>");
        html.append("<tr><td><b>Credits: </b></td><td>");
        html.append(credits);
        html.append("</td></tr>");
        html.append("</table>");
        html.append("</p>");
        return html.toString();
    }

    public EventBus getEventBus() {
        return eventBus;
    }

    public SearchEvent getLastSearchEvent() {
        return this.lastSearchEvent;
    }

    public static void excecuteGetJobs(SearchResultType type, boolean resetStructures) {
        System.out.println("New rpc get list SpeciesJobs......." + type);
        if (type.equals((Object)SearchResultType.TAXONOMY_ITEM)) {
            if (resetStructures) {
                TaxonomyJobSpeciesPanel.getInstance((EventBus)eventBus).getGridJob().mask("Loading", "x-mask-loading");
            }
            SpeciesDiscovery.taxonomySearchService.getListTaxonomyJobs((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        } else if (type.equals((Object)SearchResultType.OCCURRENCE_POINT)) {
            if (resetStructures) {
                OccurrenceJobSpeciesPanel.getInstance((EventBus)eventBus).getGridJob().mask("Loading", "x-mask-loading");
            }
            SpeciesDiscovery.taxonomySearchService.getListOccurrencesJob((AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ SearchEvent access$000(SearchController x0) {
        return x0.lastSearchEvent;
    }

    static /* synthetic */ SearchBorderLayoutPanel access$100(SearchController x0) {
        return x0.searchBorderLayoutPanel;
    }

    static /* synthetic */ SearchEvent access$002(SearchController x0, SearchEvent x1) {
        x0.lastSearchEvent = x1;
        return x0.lastSearchEvent;
    }

    static /* synthetic */ void access$200(SearchController x0, JobOccurrencesModel x1, String x2, List x3) {
        x0.saveOccurencesJob(x1, x2, x3);
    }

    static /* synthetic */ void access$300(SearchController x0, boolean x1) {
        x0.setOnlySelected(x1);
    }

    static /* synthetic */ void access$400(SearchController x0, boolean x1) {
        x0.updateOnlySelectedOnManager(x1);
    }

    static /* synthetic */ void access$500(SearchController x0, SpeciesCapability x1) {
        x0.setDataSourceType(x1);
    }

    static /* synthetic */ void access$600(SearchController x0, SpeciesCapability x1) {
        x0.switchView(x1);
    }
}

