/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.shared;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.SelectableElement;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyInterface;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyProvider;

@Entity
public class TaxonomyRow
implements FetchingElement,
Serializable,
TaxonomyInterface,
TaxonomyProvider,
SelectableElement {
    private static final long serialVersionUID = 1028839024130840026L;
    public static final String ID_FIELD = "id";
    public static final String DATAPROVIDER_NAME = "dataProviderName";
    public static final String BASE_TAXON_VALUE = "baseTaxonValue";
    public static final String DATAPROVIDER_ID = "dataProviderId";
    public static final String RANK = "rank";
    public static final String NAME = "name";
    public static final String STATUSREFID = "statusRefId";
    public static final String STATUSNAME = "statusName";
    public static final String DATEMODIFIED = "dateModified";
    public static final String PARENT_ID = "parentID";
    public static final String IS_PARENT = "isParent";
    public static final String DATASET_CITATION = "dataSetCitation";
    public static final String EXISTS_COMMONNAME = "existsCommonName";
    public static final String SELECTED = "selected";
    public static final String MATCHING_ACCORDING_TO = "matchingAccording";
    public static final String SERVICE_ID_FIELD = "serviceIdField";
    public static final String STATUS_REMARKS = "statusRemarks";
    public static final String AUTHOR = "author";
    public static final String CREDITS = "credits";
    public static final String LSID = "lsid";
    public static final String PROPERTIES = "properties";
    public static final String PROPERTIESASXML = "propertiesAsXml";
    public static final String KINGDOM_ID = "kingdomID";
    public static final String PHYLUM_ID = "phylumID";
    public static final String CLASS_ID = "classID";
    public static final String ORDER_ID = "orderID";
    public static final String FAMILY_ID = "familyID";
    public static final String GENUS_ID = "genusID";
    public static final String SPECIES_ID = "speciesID";
    public static final String EXISTS_PROPERTIES = "existsProperties";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    protected int id;
    protected String author;
    protected String credits;
    protected String lsid;
    protected String name;
    protected String serviceIdField;
    protected boolean selected = false;
    protected String dataProviderId;
    protected String dataProviderName;
    protected String dataSetCitation;
    protected String matchingAccording;
    protected String baseTaxonValue;
    protected String rank;
    private String statusRefId;
    private String statusName;
    private String dateModified;
    protected String kingdomID;
    protected String phylumID;
    protected String classID;
    protected String orderID;
    protected String familyID;
    protected String genusID;
    protected String speciesID;
    protected boolean existsCommonName = false;
    protected String statusRemarks;
    protected boolean existsProperties = false;
    private boolean isParent = false;
    @OneToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    protected List<CommonName> commonNames = new ArrayList();
    @OneToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    protected List<ItemParameter> properties = new ArrayList();
    @OneToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    protected List<TaxonomyRow> parents;
    protected String parentID;

    protected TaxonomyRow() {
    }

    public TaxonomyRow(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public String getIdToString() {
        return this.id + "";
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String getDataProviderId() {
        return this.dataProviderId;
    }

    public void setDataProviderId(String dataProviderId) {
        this.dataProviderId = dataProviderId;
    }

    public String getDataProviderName() {
        return this.dataProviderName;
    }

    public void setDataProviderName(String dataProviderName) {
        this.dataProviderName = dataProviderName;
    }

    public List<CommonName> getCommonNames() {
        return this.commonNames;
    }

    public void setCommonNames(List<CommonName> commonNames) {
        this.commonNames = commonNames;
    }

    public String getDataSetCitation() {
        return this.dataSetCitation;
    }

    public void setDataSetCitation(String dataSetCitation) {
        this.dataSetCitation = dataSetCitation;
    }

    public void setBaseTaxonValue(String taxonomyValue) {
        this.baseTaxonValue = taxonomyValue;
    }

    public String getBaseTaxonValue() {
        return this.baseTaxonValue;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatusRefId(String statusRefId) {
        this.statusRefId = statusRefId;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public void setDateModified(String dateModified) {
        this.dateModified = dateModified;
    }

    public void setParent(List<TaxonomyRow> parent) {
        this.parents = parent;
    }

    public List<TaxonomyRow> getParents() {
        return this.parents;
    }

    public String getStatusRefId() {
        return this.statusRefId;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public String getDateModified() {
        return this.dateModified;
    }

    public String getKingdomID() {
        return this.kingdomID;
    }

    public void setKingdomID(String kingdomID) {
        this.kingdomID = kingdomID;
    }

    public String getPhylumID() {
        return this.phylumID;
    }

    public void setPhylumID(String phylumID) {
        this.phylumID = phylumID;
    }

    public String getClassID() {
        return this.classID;
    }

    public void setClassID(String classID) {
        this.classID = classID;
    }

    public String getOrderID() {
        return this.orderID;
    }

    public void setOrderID(String orderID) {
        this.orderID = orderID;
    }

    public String getFamilyID() {
        return this.familyID;
    }

    public void setFamilyID(String familyID) {
        this.familyID = familyID;
    }

    public String getGenusID() {
        return this.genusID;
    }

    public void setGenusID(String genusID) {
        this.genusID = genusID;
    }

    public String getSpeciesID() {
        return this.speciesID;
    }

    public void setSpeciesID(String speciesID) {
        this.speciesID = speciesID;
    }

    public String getTaxonId() {
        return "" + this.id;
    }

    public String getAccordingTo() {
        return this.matchingAccording;
    }

    public boolean existsCommonName() {
        return this.existsCommonName;
    }

    public void setExistsCommonName(boolean existsCommonName) {
        this.existsCommonName = existsCommonName;
    }

    public void setMatchingAccording(String matchingAccording) {
        this.matchingAccording = matchingAccording;
    }

    public String getParentID() {
        return this.parentID;
    }

    public void setParentID(String parentID) {
        this.parentID = parentID;
    }

    public String getServiceId() {
        return this.serviceIdField;
    }

    public void setServiceId(String serviceIdField) {
        this.serviceIdField = serviceIdField;
    }

    public String getStatusRemarks() {
        return this.statusRemarks;
    }

    public void setStatusRemarks(String statusRemarks) {
        this.statusRemarks = statusRemarks;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public String getCredits() {
        return this.credits;
    }

    public void setCredits(String credits) {
        this.credits = credits;
    }

    public String getLsid() {
        return this.lsid;
    }

    public void setLsid(String lsid) {
        this.lsid = lsid;
    }

    public List<ItemParameter> getProperties() {
        return this.properties;
    }

    public void setProperties(List<ItemParameter> properties) {
        this.properties = properties;
    }

    public void setExistsProperties(boolean b) {
        this.existsProperties = b;
    }

    public boolean existsProperties() {
        return this.existsProperties;
    }

    public boolean isParent() {
        return this.isParent;
    }

    public void setParent(boolean isParent) {
        this.isParent = isParent;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TaxonomyRow [id=");
        builder.append(this.id);
        builder.append(", author=");
        builder.append(this.author);
        builder.append(", credits=");
        builder.append(this.credits);
        builder.append(", lsid=");
        builder.append(this.lsid);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", serviceIdField=");
        builder.append(this.serviceIdField);
        builder.append(", selected=");
        builder.append(this.selected);
        builder.append(", dataProviderId=");
        builder.append(this.dataProviderId);
        builder.append(", dataProviderName=");
        builder.append(this.dataProviderName);
        builder.append(", dataSetCitation=");
        builder.append(this.dataSetCitation);
        builder.append(", matchingAccording=");
        builder.append(this.matchingAccording);
        builder.append(", baseTaxonValue=");
        builder.append(this.baseTaxonValue);
        builder.append(", rank=");
        builder.append(this.rank);
        builder.append(", statusRefId=");
        builder.append(this.statusRefId);
        builder.append(", statusName=");
        builder.append(this.statusName);
        builder.append(", dateModified=");
        builder.append(this.dateModified);
        builder.append(", kingdomID=");
        builder.append(this.kingdomID);
        builder.append(", phylumID=");
        builder.append(this.phylumID);
        builder.append(", classID=");
        builder.append(this.classID);
        builder.append(", orderID=");
        builder.append(this.orderID);
        builder.append(", familyID=");
        builder.append(this.familyID);
        builder.append(", genusID=");
        builder.append(this.genusID);
        builder.append(", speciesID=");
        builder.append(this.speciesID);
        builder.append(", existsCommonName=");
        builder.append(this.existsCommonName);
        builder.append(", statusRemarks=");
        builder.append(this.statusRemarks);
        builder.append(", existsProperties=");
        builder.append(this.existsProperties);
        builder.append(", isParent=");
        builder.append(this.isParent);
        builder.append(", commonNames=");
        builder.append(this.commonNames);
        builder.append(", properties=");
        builder.append(this.properties);
        builder.append(", parents=");
        builder.append(this.parents);
        builder.append(", parentID=");
        builder.append(this.parentID);
        builder.append("]");
        return builder.toString();
    }
}

