/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.speciesdiscovery.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.servlet.http.HttpSession;
import net.sf.csv4j.CSVWriter;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.gcube.application.framework.core.session.ASLSession;
import org.gcube.data.spd.model.TaxonomyItem;
import org.gcube.data.spd.stubs.types.Status;
import org.gcube.data.streams.Stream;
import org.gcube.portlets.user.homelibrary.home.HomeLibrary;
import org.gcube.portlets.user.homelibrary.home.workspace.Workspace;
import org.gcube.portlets.user.homelibrary.home.workspace.WorkspaceFolder;
import org.gcube.portlets.user.homelibrary.util.WorkspaceUtil;
import org.gcube.portlets.user.speciesdiscovery.client.ConstantsSpeciesDiscovery;
import org.gcube.portlets.user.speciesdiscovery.client.model.ClassificationModel;
import org.gcube.portlets.user.speciesdiscovery.client.rpc.TaxonomySearchService;
import org.gcube.portlets.user.speciesdiscovery.client.util.GridField;
import org.gcube.portlets.user.speciesdiscovery.server.TaxonomySearchServiceImpl;
import org.gcube.portlets.user.speciesdiscovery.server.asl.SessionUtil;
import org.gcube.portlets.user.speciesdiscovery.server.job.OccurrenceJobUtil;
import org.gcube.portlets.user.speciesdiscovery.server.job.OccurrenceKeys;
import org.gcube.portlets.user.speciesdiscovery.server.job.TaxonomyJobUtil;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.DaoSession;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.OccurrenceJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.OccurrenceRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.ResultRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonomyJobPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.persistence.dao.TaxonomyRowPersistence;
import org.gcube.portlets.user.speciesdiscovery.server.service.IteratorChainBuilder;
import org.gcube.portlets.user.speciesdiscovery.server.service.SpeciesService;
import org.gcube.portlets.user.speciesdiscovery.server.service.StreamIterator;
import org.gcube.portlets.user.speciesdiscovery.server.service.TaxonomyItemConverter;
import org.gcube.portlets.user.speciesdiscovery.server.session.FetchingSession;
import org.gcube.portlets.user.speciesdiscovery.server.session.FetchingSessionUtil;
import org.gcube.portlets.user.speciesdiscovery.server.session.FilterableFetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.server.session.SelectableFetchingBuffer;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CSVGenerator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.CloseableIterator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.Converter;
import org.gcube.portlets.user.speciesdiscovery.server.stream.IteratorPointInfo;
import org.gcube.portlets.user.speciesdiscovery.server.stream.OccurenceCSVConverter;
import org.gcube.portlets.user.speciesdiscovery.server.stream.OccurenceCSVConverterOpenModeller;
import org.gcube.portlets.user.speciesdiscovery.server.stream.StreamExtend;
import org.gcube.portlets.user.speciesdiscovery.server.stream.aggregation.FieldAggregator;
import org.gcube.portlets.user.speciesdiscovery.server.stream.aggregation.TaxonomyClassificationAggregator;
import org.gcube.portlets.user.speciesdiscovery.server.util.DateUtil;
import org.gcube.portlets.user.speciesdiscovery.server.util.QueryUtil;
import org.gcube.portlets.user.speciesdiscovery.shared.CommonName;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSource;
import org.gcube.portlets.user.speciesdiscovery.shared.DataSourceModel;
import org.gcube.portlets.user.speciesdiscovery.shared.DatabaseServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.DownloadState;
import org.gcube.portlets.user.speciesdiscovery.shared.FetchingElement;
import org.gcube.portlets.user.speciesdiscovery.shared.ItemParameter;
import org.gcube.portlets.user.speciesdiscovery.shared.JobOccurrencesModel;
import org.gcube.portlets.user.speciesdiscovery.shared.JobTaxonomyModel;
import org.gcube.portlets.user.speciesdiscovery.shared.MainTaxonomicRankEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.Occurrence;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrenceBatch;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesJob;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesSaveEnum;
import org.gcube.portlets.user.speciesdiscovery.shared.OccurrencesStatus;
import org.gcube.portlets.user.speciesdiscovery.shared.ResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.SaveFileFormat;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchFilters;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResult;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchResultType;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchServiceException;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchStatus;
import org.gcube.portlets.user.speciesdiscovery.shared.SearchType;
import org.gcube.portlets.user.speciesdiscovery.shared.Taxon;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyJob;
import org.gcube.portlets.user.speciesdiscovery.shared.TaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.cluster.ClusterStructuresForResultRow;
import org.gcube.portlets.user.speciesdiscovery.shared.cluster.ClusterStructuresForTaxonomyRow;
import org.gcube.portlets.user.speciesdiscovery.shared.filter.FilterCriteria;
import org.gcube.portlets.user.speciesdiscovery.shared.filter.ResultFilter;

public class TaxonomySearchServiceImpl
extends RemoteServiceServlet
implements TaxonomySearchService {
    protected static final String SAVE_CHILDREN_OF = "Save children of ";
    protected static final String RESUBMIT = "Resubmit";
    private static final long serialVersionUID = -287193068445844326L;
    protected static final long MAX_BUFFERING_ELEMENTS = 1000L;
    protected static final long BUFFER_LIMIT = 10L;
    protected Logger logger = Logger.getLogger(TaxonomySearchService.class);
    public static final String TAXONOMYUNKNOWN = "Unknown";
    public static final String BASETAXONOMY = "Kingdom";
    public static final String UNK = "Unk";

    protected ASLSession getASLSession() {
        return SessionUtil.getAslSession((HttpSession)this.getThreadLocalRequest().getSession());
    }

    protected SpeciesService getSpeciesService() throws SearchServiceException {
        try {
            ASLSession session = this.getASLSession();
            return SessionUtil.getService((ASLSession)session);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"An error occurred when contacting the species service", (Throwable)e);
            throw new SearchServiceException("contacting the species service.");
        }
    }

    protected FetchingSession<? extends FetchingElement> getSearchSession() throws SearchServiceException {
        ASLSession session = this.getASLSession();
        FetchingSession searchSession = SessionUtil.getCurrentSearchSession((ASLSession)session);
        if (searchSession == null) {
            this.logger.error((Object)("No search session found for user " + session.getUsername()));
            throw new SearchServiceException("No search session found for user " + session.getUsername());
        }
        return searchSession;
    }

    protected FetchingSession<Occurrence> getOccurrenceSession() throws SearchServiceException {
        ASLSession session = this.getASLSession();
        FetchingSession occurrenceSession = SessionUtil.getCurrentOccurrenceSession((ASLSession)session);
        if (occurrenceSession == null) {
            this.logger.error((Object)("No occurrence session found for user " + session.getUsername()));
            throw new SearchServiceException("No occurrence session found for user " + session.getUsername());
        }
        return occurrenceSession;
    }

    public void searchByScientificName(String searchTerm, SearchFilters searchFilters) throws SearchServiceException {
        this.logger.trace((Object)("searchByScientificName searchTerm: " + searchTerm + " searchFilters: " + searchFilters));
        this.stopSearch();
        this.search(searchTerm, SearchType.BY_SCIENTIFIC_NAME, searchFilters);
    }

    public void searchByCommonName(String searchTerm, SearchFilters searchFilters) throws SearchServiceException {
        this.logger.trace((Object)("searchByCommonName searchTerm: " + searchTerm + " searchFilters: " + searchFilters));
        this.stopSearch();
        this.search(searchTerm, SearchType.BY_COMMON_NAME, searchFilters);
    }

    protected SearchResultType search(String searchTerm, SearchType searchType, SearchFilters searchFilters) throws SearchServiceException {
        try {
            this.deleteAllRowIntoDaoTable();
            ASLSession aslSession = this.getASLSession();
            SpeciesService taxonomyService = this.getSpeciesService();
            CloseableIterator input = taxonomyService.searchByFilters(searchTerm, searchType, searchFilters);
            this.logger.trace((Object)"returned input stream by service...");
            SearchResultType resultType = QueryUtil.getResultType((SearchFilters)searchFilters);
            CloseableIterator output = IteratorChainBuilder.buildChain((CloseableIterator)input, (SearchResultType)resultType, (ASLSession)aslSession);
            FetchingSessionUtil.createFetchingSession((CloseableIterator)output, (SearchResultType)resultType, (ASLSession)aslSession);
            return resultType;
        }
        catch (Exception e) {
            this.logger.error((Object)("Error starting search " + searchType + " for term \"" + searchTerm + "\" with filters " + searchFilters), (Throwable)e);
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
    }

    public SearchResultType searchByQuery(String query) throws SearchServiceException {
        this.logger.trace((Object)("searchByQuery - query: " + query));
        this.stopSearch();
        try {
            this.deleteAllRowIntoDaoTable();
            ASLSession aslSession = this.getASLSession();
            SpeciesService taxonomyService = this.getSpeciesService();
            CloseableIterator input = taxonomyService.searchByQuery(query);
            this.logger.trace((Object)"service return iterator searched...");
            SearchResultType resultType = QueryUtil.getQueryResultType((String)query);
            CloseableIterator output = IteratorChainBuilder.buildChain((CloseableIterator)input, (SearchResultType)resultType, (ASLSession)aslSession);
            FetchingSessionUtil.createFetchingSession((CloseableIterator)output, (SearchResultType)resultType, (ASLSession)aslSession);
            this.logger.trace((Object)"creating fetching session completed!");
            return resultType;
        }
        catch (Exception e) {
            this.logger.error((Object)"Error starting search by query", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    private void deleteAllRowIntoDaoTable() throws Exception {
        ResultRowPersistence daoResultRow = null;
        TaxonRowPersistence daoTaxon = null;
        TaxonomyRowPersistence daoTaxonomyRow = null;
        ASLSession session = this.getASLSession();
        try {
            daoResultRow = DaoSession.getResultRowDAO((ASLSession)session);
            daoTaxon = DaoSession.getTaxonDAO((ASLSession)session);
            daoTaxonomyRow = DaoSession.getTaxonomyDAO((ASLSession)session);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in delete all row -  getDao's " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in delete all row-  getDao's " + e.getMessage(), e);
        }
        try {
            if (daoResultRow != null) {
                daoResultRow.removeAll();
            }
            if (daoTaxon != null) {
                daoTaxon.removeAll();
            }
            if (daoTaxonomyRow != null) {
                daoTaxonomyRow.removeAll();
            }
            this.logger.trace((Object)"delete all row from Dao's - completed");
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in delete all row");
            throw new Exception("Error in delete all row" + e.getCause(), e);
        }
    }

    public SearchResult<ResultRow> getSearchResultRows(int start, int limit, ResultFilter activeFiltersObject, boolean onlySelected) throws SearchServiceException {
        this.logger.trace((Object)("getSearchResultRows start: " + start + " limit: " + limit + " onlySelected: " + onlySelected));
        Long startTime = System.currentTimeMillis();
        FetchingSession searchSession = this.getSearchSession();
        ArrayList<ResultRow> chunk = new ArrayList<ResultRow>();
        try {
            int end;
            SelectableFetchingBuffer buffer;
            List data = new ArrayList();
            if (onlySelected) {
                buffer = (SelectableFetchingBuffer)searchSession.getBuffer();
                data = buffer.getSelected();
                end = Math.min(start + limit, data.size());
                start = Math.min(start, end);
                this.logger.trace((Object)("chunk selected data bounds [start: " + start + " end: " + end + "]"));
                data = data.subList(start, end);
            } else if (activeFiltersObject == null || !activeFiltersObject.isActiveFilters()) {
                if (limit > 0) {
                    data = searchSession.getBuffer().getList(start, limit);
                }
            } else {
                buffer = (FilterableFetchingBuffer)searchSession.getBuffer();
                data = buffer.getFilteredList((FilterCriteria)activeFiltersObject);
                end = Math.min(start + limit, data.size());
                start = Math.min(start, end);
                this.logger.trace((Object)("chunk filtered data bounds [start: " + start + " end: " + end + "]"));
                data = data.subList(start, end);
            }
            this.logger.trace((Object)("Fetching data from search session buffer, size: " + data.size()));
            for (ResultRow resultRow : data) {
                if (activeFiltersObject == null || !activeFiltersObject.isLoadCommonName() || !resultRow.existsCommonName()) {
                    resultRow.setCommonNames(null);
                }
                if (activeFiltersObject == null || !resultRow.existsProperties() || !activeFiltersObject.isLoadAllProperties()) {
                    resultRow.setProperties(null);
                }
                chunk.add(resultRow);
                this.logger.trace((Object)("getSearchResultRows return on client result item with id: " + resultRow.getId() + " service id: " + resultRow.getServiceId()));
            }
            Long endTime = System.currentTimeMillis() - startTime;
            String time = String.format("%d msc %d sec", endTime, TimeUnit.MILLISECONDS.toSeconds(endTime));
            this.logger.trace((Object)("returning " + chunk.size() + " elements in " + time));
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in getSearchResultRows " + e.getMessage()));
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
        return new SearchResult(chunk);
    }

    private void printProperties(List<ItemParameter> properties) {
        for (ItemParameter itemParameter : properties) {
            System.out.println("Property " + itemParameter);
        }
    }

    public SearchResult<TaxonomyRow> getSearchTaxonomyRow(int start, int limit, ResultFilter activeFiltersObject, boolean onlySelected) throws SearchServiceException {
        this.logger.trace((Object)("getSearchResultRows start: " + start + " limit: " + limit + " onlySelected: " + onlySelected));
        Long startTime = System.currentTimeMillis();
        FetchingSession searchSession = this.getSearchSession();
        ArrayList<TaxonomyRow> chunk = new ArrayList<TaxonomyRow>();
        try {
            int end;
            SelectableFetchingBuffer buffer;
            this.logger.trace((Object)("current buffer size " + searchSession.getBuffer().size()));
            List data = new ArrayList();
            if (onlySelected) {
                this.logger.trace((Object)"getting only selected data");
                buffer = (SelectableFetchingBuffer)searchSession.getBuffer();
                data = buffer.getSelected();
                end = Math.min(start + limit, data.size());
                start = Math.min(start, end);
                this.logger.trace((Object)("chunk selected data bounds [start: " + start + " end: " + end + "]"));
                data = data.subList(start, end);
            } else if (activeFiltersObject == null || !activeFiltersObject.isActiveFilters()) {
                this.logger.trace((Object)"getting all available data");
                if (limit > 0) {
                    HashMap<String, String> filterAndMap = new HashMap<String, String>();
                    filterAndMap.put("isParent", "false");
                    data = searchSession.getBuffer().getList(filterAndMap, start, limit);
                }
            } else {
                this.logger.trace((Object)"getting filtered data");
                buffer = (FilterableFetchingBuffer)searchSession.getBuffer();
                data = buffer.getFilteredList((FilterCriteria)activeFiltersObject);
                end = Math.min(start + limit, data.size());
                start = Math.min(start, end);
                this.logger.trace((Object)("chunk filtered data bounds [start: " + start + " end: " + end + "]"));
                data = data.subList(start, end);
            }
            this.logger.trace((Object)("Fetching data from search session buffer, size: " + data.size()));
            for (TaxonomyRow taxonomyRow : data) {
                if (activeFiltersObject == null || !activeFiltersObject.isLoadCommonName() || !taxonomyRow.existsCommonName()) {
                    taxonomyRow.setCommonNames(null);
                }
                if (activeFiltersObject == null || !taxonomyRow.existsProperties() || !activeFiltersObject.isLoadAllProperties()) {
                    taxonomyRow.setProperties(null);
                }
                this.logger.trace((Object)("getSearchTaxonomyRow return on client taxonomy item with id: " + taxonomyRow.getId() + " service id: " + taxonomyRow.getServiceId()));
                chunk.add(taxonomyRow);
            }
            Long endTime = System.currentTimeMillis() - startTime;
            String time = String.format("%d msc %d sec", endTime, TimeUnit.MILLISECONDS.toSeconds(endTime));
            this.logger.trace((Object)("returning " + chunk.size() + " elements in " + time));
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in getSearchTaxonomyRow " + e.getMessage()), (Throwable)e);
            e.printStackTrace();
            throw new SearchServiceException(e.getMessage());
        }
        return new SearchResult(chunk);
    }

    public TaxonomyRow loadTaxonomyParentByParentId(String parentID) throws Exception {
        TaxonomyRow taxonomyRow = null;
        this.logger.trace((Object)("loadTaxonomyParentByParentId: " + parentID));
        try {
            TaxonomyRowPersistence dao = DaoSession.getTaxonomyDAO((ASLSession)this.getASLSession());
            CriteriaBuilder queryBuilder = dao.getCriteriaBuilder();
            CriteriaQuery cq = queryBuilder.createQuery();
            Predicate pr1 = queryBuilder.equal((Expression)dao.rootFrom(cq).get("parentID"), (Object)parentID);
            cq.where((Expression)pr1);
            Iterator iterator = dao.executeCriteriaQuery(cq).iterator();
            if (iterator != null && iterator.hasNext()) {
                taxonomyRow = (TaxonomyRow)iterator.next();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error in loadTaxonomyParentsByRowId", (Throwable)e);
            throw new Exception(e);
        }
        return taxonomyRow;
    }

    public HashMap<String, Integer> getFilterCounterById(GridField field) throws Exception {
        this.logger.trace((Object)("Filter Counter for: " + field));
        try {
            FetchingSession searchSession = this.getSearchSession();
            FieldAggregator aggregator = (FieldAggregator)searchSession.getAggregator(FieldAggregator.getFieldAggregatorName((GridField)field));
            if (aggregator != null) {
                return aggregator.getAggregation();
            }
            return new HashMap<String, Integer>();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in getFilterCounterById " + field.getId() + " " + field.getName()), (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    public HashMap<String, ClassificationModel> getFilterCounterForClassification(String rankLabel) throws Exception {
        this.logger.trace((Object)("Counter for classification: " + rankLabel));
        try {
            MainTaxonomicRankEnum rank = MainTaxonomicRankEnum.valueOfLabel((String)rankLabel);
            if (rank != null) {
                FetchingSession searchSession = this.getSearchSession();
                TaxonomyClassificationAggregator classificationAggregator = (TaxonomyClassificationAggregator)searchSession.getAggregator("ClassificationAggregator");
                return (HashMap)classificationAggregator.getAggregation().get(rank);
            }
            return new HashMap<String, ClassificationModel>();
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in getFilterCounterForClassification " + rankLabel), (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    public SearchStatus getSearchStatus(boolean onlySelected, boolean isActiveFilterOnResult) throws SearchServiceException {
        this.logger.trace((Object)("getSearchStatus onlySelected: " + onlySelected));
        FetchingSession searchSession = this.getSearchSession();
        SearchStatus status = new SearchStatus();
        int bufferSize = 0;
        try {
            bufferSize = isActiveFilterOnResult ? ((FilterableFetchingBuffer)searchSession.getBuffer()).getFilteredListSize() : searchSession.getBufferSize();
        }
        catch (Exception e) {
            this.logger.trace((Object)("getSearchStatus bufferSize error : " + e.getMessage()), (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
        this.logger.trace((Object)("getSearchStatus bufferSize " + bufferSize));
        if ((long)bufferSize >= 1000L) {
            this.logger.trace((Object)"getSearchStatus MAX_BUFFERING_ELEMENTS is reached -  stop search");
            this.stopSearchWithoutRemove();
            status.setResultEOF(true);
            status.setSize(bufferSize);
            status.setIsMaxSize(true);
            return status;
        }
        if (!onlySelected && !isActiveFilterOnResult) {
            status.setResultEOF(searchSession.isComplete());
            status.setSize(bufferSize);
        } else {
            if (isActiveFilterOnResult) {
                status.setResultEOF(true);
                try {
                    status.setSize(((FilterableFetchingBuffer)searchSession.getBuffer()).getFilteredListSize());
                }
                catch (Exception e) {
                    this.logger.error((Object)("isActiveFilterOnResult - An error occured in getSearchStatus " + e.getMessage()), (Throwable)e);
                    throw new SearchServiceException(e.getMessage());
                }
            }
            status.setResultEOF(true);
            try {
                status.setSize(((SelectableFetchingBuffer)searchSession.getBuffer()).getSelected().size());
            }
            catch (Exception e) {
                this.logger.error((Object)("An error occured in getSearchStatus " + e.getMessage()), (Throwable)e);
                throw new SearchServiceException(e.getMessage());
            }
        }
        this.logger.trace((Object)("getSearchStatus return status size: " + status.getSize() + " EOF: " + status.isResultEOF()));
        return status;
    }

    public void stopSearchWithoutRemove() throws SearchServiceException {
        this.logger.trace((Object)"stopSearch without Remove");
        ASLSession session = this.getASLSession();
        FetchingSession searchSession = SessionUtil.getCurrentSearchSession((ASLSession)session);
        if (searchSession != null) {
            try {
                searchSession.close();
            }
            catch (IOException e) {
                throw new SearchServiceException(e.getMessage());
            }
        } else {
            this.logger.warn((Object)"Search session not found");
        }
    }

    public void stopSearch() throws SearchServiceException {
        this.logger.trace((Object)"stopSearch");
        ASLSession session = this.getASLSession();
        FetchingSession searchSession = SessionUtil.getCurrentSearchSession((ASLSession)session);
        if (searchSession != null) {
            try {
                searchSession.close();
            }
            catch (IOException e) {
                throw new SearchServiceException(e.getMessage());
            }
            SessionUtil.setCurrentSearchSession((ASLSession)session, null);
        } else {
            this.logger.warn((Object)"Search session not found");
        }
    }

    public void updateRowSelection(int rowId, boolean selection) throws SearchServiceException {
        this.logger.trace((Object)("updateRowSelection rowId: " + rowId + " selection: " + selection));
        try {
            ASLSession session = this.getASLSession();
            FetchingSession searchSession = SessionUtil.getCurrentSearchSession((ASLSession)session);
            SelectableFetchingBuffer buffer = (SelectableFetchingBuffer)searchSession.getBuffer();
            buffer.updateSelection(rowId, selection);
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in updateRowSelection rowId: " + rowId + " selection: " + selection), (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    public Integer updateRowSelections(boolean selection, ResultFilter activeFiltersObject) throws SearchServiceException {
        this.logger.trace((Object)("updateRowSelections selection: " + selection));
        FetchingSession searchSession = this.getSearchSession();
        int size = 0;
        try {
            if (activeFiltersObject == null || !activeFiltersObject.isActiveFilters()) {
                SelectableFetchingBuffer buffer = (SelectableFetchingBuffer)searchSession.getBuffer();
                buffer.updateAllSelection(selection);
                size = buffer.size();
            } else {
                FilterableFetchingBuffer buffer = (FilterableFetchingBuffer)searchSession.getBuffer();
                List data = buffer.getFilteredList((FilterCriteria)activeFiltersObject);
                if (data != null) {
                    for (FetchingElement fetchingElement : data) {
                        this.updateRowSelection(fetchingElement.getId(), selection);
                    }
                    size = data.size();
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred in updateRowSelections", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
        return size;
    }

    public int countOfSelectedRow() throws SearchServiceException {
        this.logger.trace((Object)"countOfSelectedRow()");
        FetchingSession searchSession = this.getSearchSession();
        try {
            SelectableFetchingBuffer buffer = (SelectableFetchingBuffer)searchSession.getBuffer();
            return buffer.sizeSelected();
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred in updateRowSelections", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    public int retrieveOccurencesFromSelection() throws SearchServiceException {
        this.logger.trace((Object)"retrieveOccurencesFromSelection()");
        int count = 0;
        FetchingSession searchSession = this.getSearchSession();
        try {
            List selectedRows = ((SelectableFetchingBuffer)searchSession.getBuffer()).getSelected();
            this.logger.trace((Object)("found " + selectedRows.size() + " selected rows"));
            ArrayList<String> keys = new ArrayList<String>(selectedRows.size());
            for (ResultRow row : selectedRows) {
                if (row.getOccurencesKey() == null || row.getOccurencesKey().length() <= 0) continue;
                keys.add(row.getOccurencesKey());
                count += row.getOccurencesCount();
            }
            this.logger.trace((Object)("found " + count + " occurrence points"));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("selected keys: " + keys));
            }
            SpeciesService taxonomyService = this.getSpeciesService();
            CloseableIterator source = taxonomyService.getOccurrencesByKeys(keys);
            CloseableIterator input = IteratorChainBuilder.buildOccurrenceConverter((CloseableIterator)source);
            OccurrenceRowPersistence occurrencesDao = DaoSession.getOccurrenceDAO((ASLSession)this.getASLSession());
            occurrencesDao.removeAll();
            FetchingSessionUtil.createOccurrenceFetchingSession((CloseableIterator)input, (ASLSession)this.getASLSession());
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred getting the number of occurrence points", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
        return count;
    }

    public OccurrenceBatch getOccurrencesBatch(int start, int limit) throws SearchServiceException {
        this.logger.trace((Object)("getOccurrencesBatch: start: " + start + " limit: " + limit));
        FetchingSession occurrenceSession = this.getOccurrenceSession();
        OccurrenceBatch result = null;
        try {
            List buffer = occurrenceSession.getBuffer().getList();
            this.logger.trace((Object)("Fetching data from occurrence session buffer, size: " + buffer.size()));
            int end = Math.min(start + limit, buffer.size());
            this.logger.trace((Object)("chunk bounds[start: " + start + " end: " + end + "]"));
            ArrayList data = new ArrayList(buffer.subList(start, end));
            this.logger.trace((Object)("returning " + data.size() + " elements"));
            result = new OccurrenceBatch(data);
            result.setResultEOF(occurrenceSession.isComplete());
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred getting the occurrence points", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
        return result;
    }

    public OccurrencesStatus getCountOfOccurrencesBatch() throws SearchServiceException {
        this.logger.trace((Object)"get CountOf Occurrences Batch");
        FetchingSession occurrenceSession = this.getOccurrenceSession();
        try {
            List buffer = occurrenceSession.getBuffer().getList();
            this.logger.trace((Object)("Fetching data from occurrence session buffer, size: " + buffer.size()));
            return new OccurrencesStatus(occurrenceSession.isComplete(), buffer.size());
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred getting the occurrence points", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    public void stopRetrievingOccurrences() throws SearchServiceException {
        this.logger.trace((Object)"stop Retrieving Occurrences ");
        ASLSession session = this.getASLSession();
        FetchingSession occurrenceSearchSession = SessionUtil.getCurrentOccurrenceSession((ASLSession)session);
        if (occurrenceSearchSession != null) {
            try {
                occurrenceSearchSession.close();
                this.logger.trace((Object)"Occurrence session removed");
            }
            catch (IOException e) {
                throw new SearchServiceException(e.getMessage());
            }
            SessionUtil.setCurrentOccurrenceSession((ASLSession)session, null);
        } else {
            this.logger.warn((Object)"Occurrence session not found");
        }
    }

    public String generateMapFromSelectedOccurrencePoints() throws SearchServiceException {
        this.logger.trace((Object)"generate Map From Occurrence Points");
        Iterator iteratorOccurrences = this.getIteratorSelectedOccurrenceIds();
        IteratorPointInfo streamKey = new IteratorPointInfo(iteratorOccurrences);
        try {
            SpeciesService taxonomyService = this.getSpeciesService();
            String groupName = taxonomyService.generateMapFromOccurrencePoints(streamKey);
            this.logger.trace((Object)("generated groupName: " + groupName));
            return groupName;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred creating the map", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    protected void printId(List<String> listId) {
        for (String id : listId) {
            System.out.println("Found id : " + id);
        }
    }

    protected List<String> getSelectedOccurrenceIds() throws SearchServiceException {
        FetchingSession occurrenceSession = this.getOccurrenceSession();
        ArrayList<String> listId = new ArrayList<String>();
        try {
            List buffer = occurrenceSession.getBuffer().getList();
            for (Occurrence occurrence : buffer) {
                listId.add(occurrence.getServiceId());
            }
            return listId;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred on getSelectedOccurrenceIds", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    protected Iterator<Occurrence> getIteratorSelectedOccurrenceIds() throws SearchServiceException {
        FetchingSession occurrenceSession = this.getOccurrenceSession();
        try {
            return occurrenceSession.getBuffer().getList().iterator();
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred on getIteratorSelectedOccurrenceIds", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    public void saveSelectedOccurrencePoints(String destinationFolderId, String fileName, SaveFileFormat fileFormat, OccurrencesSaveEnum typeCSV) throws SearchServiceException {
        this.logger.trace((Object)("saveSelectedOccurrencePoints destinationFolderId: " + destinationFolderId + " fileName: " + fileName + " fileFormat: " + fileFormat + " typeCSV: " + typeCSV));
    }

    public void saveSelectedTaxonomyPoints(String destinationFolderId, String fileName, SaveFileFormat fileFormat) throws SearchServiceException {
    }

    protected List<String> getSelectedOccurrenceKeys() throws SearchServiceException {
        FetchingSession searchSession = this.getSearchSession();
        ArrayList<String> keys = null;
        try {
            List selectedRows = ((SelectableFetchingBuffer)searchSession.getBuffer()).getSelected();
            this.logger.trace((Object)("found " + selectedRows.size() + " selected rows"));
            keys = new ArrayList<String>(selectedRows.size());
            int count = 0;
            for (ResultRow row : selectedRows) {
                keys.add(row.getOccurencesKey());
                count += row.getOccurencesCount();
            }
            this.logger.trace((Object)("found " + count + " occurrence points and " + keys.size() + " keys"));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("selected keys: " + keys));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("An error occured in getSelectedOccurrenceKeys" + e.getMessage()));
            throw new SearchServiceException(e.getMessage());
        }
        return keys;
    }

    protected List<String> getSelectedResultRowId() throws SearchServiceException {
        FetchingSession searchSession = this.getSearchSession();
        ArrayList<String> listId = null;
        try {
            List selectedRows = ((SelectableFetchingBuffer)searchSession.getBuffer()).getSelected();
            this.logger.trace((Object)("found " + selectedRows.size() + " selected rows"));
            listId = new ArrayList<String>(selectedRows.size());
            for (ResultRow row : selectedRows) {
                listId.add(row.getServiceId());
            }
            this.logger.trace((Object)("found " + listId.size() + " ids"));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("selected ids: " + listId));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("An error occured in getSelectedOccurrenceKeys" + e.getMessage()));
            throw new SearchServiceException(e.getMessage());
        }
        return listId;
    }

    protected List<String> getSelectedTaxonomyId() throws SearchServiceException {
        FetchingSession searchSession = this.getSearchSession();
        ArrayList<String> listId = null;
        try {
            List selectedRows = ((SelectableFetchingBuffer)searchSession.getBuffer()).getSelected();
            this.logger.trace((Object)("found " + selectedRows.size() + " selected rows"));
            listId = new ArrayList<String>(selectedRows.size());
            for (TaxonomyRow row : selectedRows) {
                listId.add(row.getServiceId());
                this.logger.trace((Object)("add this id: " + row.getServiceId() + " to list"));
            }
            this.logger.trace((Object)("found " + listId.size() + " id"));
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("selected ids: " + listId));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("An error occured in getSelectedOccurrenceKeys" + e.getMessage()));
            throw new SearchServiceException(e.getMessage());
        }
        return listId;
    }

    protected File generateCSVFile(List<String> ids, OccurrencesSaveEnum csvType) throws Exception {
        File csvFile = File.createTempFile("test", ".csv");
        this.logger.trace((Object)("outputfile " + csvFile.getAbsolutePath()));
        FileWriter fileWriter = new FileWriter(csvFile);
        CSVWriter writer = new CSVWriter((Writer)fileWriter);
        SpeciesService taxonomyService = this.getSpeciesService();
        CloseableIterator source = taxonomyService.getOccurrencesByIds(ids);
        CloseableIterator result = IteratorChainBuilder.buildOccurrenceConverter((CloseableIterator)source);
        CSVGenerator csvGenerator = null;
        switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$OccurrencesSaveEnum[csvType.ordinal()]) {
            case 1: {
                OccurenceCSVConverterOpenModeller converterOpenModeller = new OccurenceCSVConverterOpenModeller();
                csvGenerator = new CSVGenerator(result, (Converter)converterOpenModeller, OccurenceCSVConverterOpenModeller.HEADER);
                break;
            }
            case 2: {
                OccurenceCSVConverter converter = new OccurenceCSVConverter();
                csvGenerator = new CSVGenerator(result, (Converter)converter, OccurenceCSVConverter.HEADER);
            }
        }
        while (csvGenerator.hasNext()) {
            writer.writeLine(csvGenerator.next());
        }
        fileWriter.close();
        return csvFile;
    }

    public List<DataSourceModel> loadDataSourceList() throws SearchServiceException {
        this.logger.trace((Object)"loadDataSourceList... ");
        List listDS = null;
        try {
            DaoSession.initSessionDaoObjects((ASLSession)this.getASLSession());
            this.logger.trace((Object)"DAOs OK... ");
            System.out.println("DAOs OK");
            SpeciesService taxonomyService = this.getSpeciesService();
            System.out.println("Species Services OK");
            this.logger.trace((Object)"Species Services OK... ");
            listDS = taxonomyService.getPlugins();
            System.out.println("Plugins OK");
            this.logger.trace((Object)"Plugins OK");
            this.logger.trace((Object)("Return list plugin - size: " + listDS.size()));
        }
        catch (DatabaseServiceException e) {
            throw new SearchServiceException("Sorry, an error has occurred on the server while " + e.getMessage());
        }
        catch (Exception e) {
            throw new SearchServiceException("Sorry, an error has occurred on the server while " + e.getMessage());
        }
        return listDS;
    }

    public ArrayList<CommonName> loadListCommonNameByRowId(String resultRowId) throws Exception {
        ArrayList<CommonName> listCommonName = new ArrayList<CommonName>();
        return listCommonName;
    }

    public List<Taxon> getParentsList(Taxon taxon) throws Exception {
        return null;
    }

    public ArrayList<TaxonomyRow> loadListChildByParentId(String parentId) throws Exception {
        this.logger.trace((Object)("Load List Children By ParentId: " + parentId));
        ArrayList<TaxonomyRow> listTaxonomyRow = new ArrayList<TaxonomyRow>();
        try {
            SpeciesService taxonomyService = this.getSpeciesService();
            StreamIterator streamIterator = taxonomyService.getTaxonChildrenByParentId(parentId);
            TaxonomyItemConverter converter = new TaxonomyItemConverter(this.getASLSession());
            int i = 0;
            while (streamIterator.hasNext()) {
                TaxonomyItem tax = (TaxonomyItem)streamIterator.next();
                TaxonomyRow taxonomyRow = converter.convert(tax);
                listTaxonomyRow.add(taxonomyRow);
                this.logger.trace((Object)(i + ") taxonomyRow: " + taxonomyRow));
                ++i;
            }
            streamIterator.close();
        }
        catch (Exception e) {
            this.logger.error((Object)"Error on loadListChildByParentId ", (Throwable)e);
            throw new Exception("Error on loadListChildByParentId", e);
        }
        this.logger.trace((Object)("Return list children By ParentId - size" + listTaxonomyRow.size()));
        return listTaxonomyRow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<JobTaxonomyModel> getListTaxonomyJobs() throws Exception {
        this.logger.trace((Object)"getListTaxonomyJobs... ");
        ArrayList<JobTaxonomyModel> listJobs = new ArrayList<JobTaxonomyModel>();
        try {
            TaxonomyJobPersistence taxonomyJobDao = DaoSession.getTaxonomyJobDAO((ASLSession)this.getASLSession());
            Iterator iterator = taxonomyJobDao.getList().iterator();
            SpeciesService taxonomyService = this.getSpeciesService();
            while (iterator != null && iterator.hasNext()) {
                TaxonomyJob job = (TaxonomyJob)iterator.next();
                this.logger.trace((Object)("get taxonomy job " + job.getId() + " from service"));
                try {
                    Status statusResponse = taxonomyService.getTaxonomyJobById(job.getId());
                    if (statusResponse != null) {
                        this.logger.trace((Object)("statusResponse is not null..." + job.getId()));
                        JobTaxonomyModel jobSpeciesModel = TaxonomyJobUtil.convertJob((TaxonomyJob)job, (Status)statusResponse, (TaxonomyJobPersistence)taxonomyJobDao);
                        this.logger.trace((Object)("added list jobTaxonomyId: " + job.getTaxonomyId() + " status " + job.getState()));
                        if (jobSpeciesModel == null) continue;
                        listJobs.add(jobSpeciesModel);
                        continue;
                    }
                    this.logger.trace((Object)("TaxonomyJob statusResponse is null..." + job.getId()));
                    TaxonomyJobUtil.deleteTaxonomyJobById((String)job.getId(), (TaxonomyJobPersistence)taxonomyJobDao);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error((Object)"Error on getListSpeciesJobs ", (Throwable)e);
                    throw new Exception("Error on getListSpeciesJobs", e);
                    return listJobs;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error on getListSpeciesJobs ", (Throwable)e);
            throw new Exception("Error on getListSpeciesJobs", e);
        }
    }

    public JobTaxonomyModel createTaxonomyJobByChildren(TaxonomyRow taxonomy, String dataSourceName) throws Exception {
        this.logger.trace((Object)("Create job for taxonomy id: " + taxonomy.getServiceId()));
        JobTaxonomyModel jobSpeciesModel = null;
        TaxonomyJobPersistence taxonomyJobDao = DaoSession.getTaxonomyJobDAO((ASLSession)this.getASLSession());
        SpeciesService taxonomyService = this.getSpeciesService();
        String speciesJobId = taxonomyService.createTaxonomyJobForDWCAByChildren(taxonomy.getServiceId());
        long startTime = Calendar.getInstance().getTimeInMillis();
        TaxonomyJob speciesJob = new TaxonomyJob(speciesJobId, DownloadState.PENDING.toString(), SAVE_CHILDREN_OF + taxonomy.getName(), taxonomy.getName(), dataSourceName, taxonomy.getRank(), startTime, 0L, taxonomy.getServiceId());
        taxonomyJobDao.insert((Object)speciesJob);
        jobSpeciesModel = new JobTaxonomyModel(speciesJob.getId(), speciesJob.getDescriptiveName(), DownloadState.PENDING, null, taxonomy.getName(), dataSourceName, taxonomy.getRank());
        Date start = DateUtil.millisecondsToDate((long)speciesJob.getStartTime());
        jobSpeciesModel.setStartTime(start);
        jobSpeciesModel.setEndTime(null);
        return jobSpeciesModel;
    }

    public JobTaxonomyModel createTaxonomyJobByIds(String search, List<DataSourceModel> dataSources) throws Exception {
        this.logger.trace((Object)("Create job ForDWCAByIds for: " + search));
        List listId = this.getSelectedTaxonomyId();
        JobTaxonomyModel jobSpeciesModel = null;
        TaxonomyJobPersistence taxonomyJobDao = DaoSession.getTaxonomyJobDAO((ASLSession)this.getASLSession());
        SpeciesService taxonomyService = this.getSpeciesService();
        String speciesJobId = taxonomyService.createTaxonomyJobForDWCAByIds(listId);
        long startTime = Calendar.getInstance().getTimeInMillis();
        String name = "Save DWCA with " + listId.size() + " ";
        name = name + (listId.size() > 1 ? "items" : "item");
        name = name + " " + search;
        String dataSourceName = "";
        for (DataSourceModel dataSource : dataSources) {
            dataSourceName = dataSourceName + dataSource.getName() + ", ";
        }
        TaxonomyJob speciesJob = new TaxonomyJob(speciesJobId, DownloadState.PENDING.toString(), name, name, dataSourceName, "", startTime, 0L, speciesJobId);
        taxonomyJobDao.insert((Object)speciesJob);
        jobSpeciesModel = new JobTaxonomyModel(speciesJob.getId(), speciesJob.getDescriptiveName(), DownloadState.PENDING, null, name, dataSourceName, "");
        Date start = DateUtil.millisecondsToDate((long)speciesJob.getStartTime());
        jobSpeciesModel.setStartTime(start);
        jobSpeciesModel.setEndTime(null);
        return jobSpeciesModel;
    }

    public JobTaxonomyModel resubmitTaxonomyJob(String jobIdentifier) throws Exception {
        this.logger.trace((Object)("Resubmit taxonomy job for id: " + jobIdentifier));
        JobTaxonomyModel jobSpeciesModel = null;
        TaxonomyJobPersistence taxonomyJobDao = DaoSession.getTaxonomyJobDAO((ASLSession)this.getASLSession());
        CriteriaBuilder queryBuilder = taxonomyJobDao.getCriteriaBuilder();
        CriteriaQuery cq = queryBuilder.createQuery();
        Predicate pr1 = queryBuilder.equal((Expression)taxonomyJobDao.rootFrom(cq).get("jobId"), (Object)jobIdentifier);
        cq.where((Expression)pr1);
        Iterator iterator = taxonomyJobDao.executeCriteriaQuery(cq).iterator();
        if (!iterator.hasNext()) {
            return jobSpeciesModel;
        }
        TaxonomyJob taxonomy = (TaxonomyJob)iterator.next();
        SpeciesService taxonomyService = this.getSpeciesService();
        String speciesJobId = taxonomyService.createTaxonomyJobForDWCAByChildren(taxonomy.getTaxonomyId());
        long startTime = Calendar.getInstance().getTimeInMillis();
        TaxonomyJob speciesJob = new TaxonomyJob(speciesJobId, DownloadState.PENDING.toString(), "Resubmit Save children of " + taxonomy.getDescriptiveName(), taxonomy.getDescriptiveName(), taxonomy.getDataSourceName(), taxonomy.getRank(), startTime, 0L, taxonomy.getTaxonomyId());
        taxonomyJobDao.insert((Object)speciesJob);
        jobSpeciesModel = new JobTaxonomyModel(speciesJob.getId(), speciesJob.getDescriptiveName(), DownloadState.PENDING, null, taxonomy.getDescriptiveName(), taxonomy.getDataSourceName(), taxonomy.getRank());
        Date start = DateUtil.millisecondsToDate((long)speciesJob.getStartTime());
        jobSpeciesModel.setStartTime(start);
        jobSpeciesModel.setEndTime(null);
        return jobSpeciesModel;
    }

    public boolean cancelTaxonomyJob(String jobIdentifier) throws Exception {
        try {
            SpeciesService taxonomyService = this.getSpeciesService();
            taxonomyService.cancelTaxonomyJobById(jobIdentifier);
            TaxonomyJobPersistence speciesJobDao = DaoSession.getTaxonomyJobDAO((ASLSession)this.getASLSession());
            int count = TaxonomyJobUtil.deleteTaxonomyJobById((String)jobIdentifier, (TaxonomyJobPersistence)speciesJobDao);
            if (count == 1) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error on cancel taxonomy job ", (Throwable)e);
            throw new Exception("Error on cancel taxonomy job", e);
        }
        return false;
    }

    public boolean saveTaxonomyJob(String jobIdentifier, String destinationFolderId, String fileName, String scientificName, String dataSourceName) throws Exception {
        this.logger.trace((Object)("saveSpeciesJob jobId: " + jobIdentifier + " destinationFolderId: " + destinationFolderId + " fileName: " + fileName));
        try {
            SpeciesService taxonomyService = this.getSpeciesService();
            String mimeType = "application/zip";
            InputStream inputStream = taxonomyService.getTaxonomyJobFileById(jobIdentifier);
            if (inputStream == null) {
                this.logger.trace((Object)"input stream is null");
                return false;
            }
            Workspace workspace = HomeLibrary.getUserWorkspace((ASLSession)this.getASLSession());
            this.logger.trace((Object)"input stream is not null");
            WorkspaceFolder folder = (WorkspaceFolder)workspace.getItem(destinationFolderId);
            fileName = WorkspaceUtil.getUniqueName((String)fileName, (WorkspaceFolder)folder);
            folder.createExternalFileItem(fileName, "Taxonomy job generated files", mimeType, inputStream);
            this.logger.trace((Object)"Save file with taxonomy was completed");
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred saving the generated file into the workspace", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    public List<TaxonomyRow> retrieveTaxonomyByIds(List<String> ids) throws Exception {
        this.logger.trace((Object)("retrieveTaxonomyByIds ids size: " + ids.size()));
        ArrayList<TaxonomyRow> listTaxonomyRow = new ArrayList<TaxonomyRow>();
        try {
            SpeciesService taxonomyService = this.getSpeciesService();
            StreamExtend convert = new StreamExtend(ids.iterator());
            CloseableIterator streamIterator = taxonomyService.retrieveTaxonomyById((Stream)convert);
            TaxonomyItemConverter taxonomyItemConverter = new TaxonomyItemConverter(this.getASLSession());
            int i = 1;
            while (streamIterator.hasNext()) {
                TaxonomyItem tax = (TaxonomyItem)streamIterator.next();
                TaxonomyRow taxonomyRow = taxonomyItemConverter.convert(tax);
                listTaxonomyRow.add(taxonomyRow);
                this.logger.trace((Object)(i + ") retrieveTaxonomyById: " + taxonomyRow));
                ++i;
            }
            streamIterator.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"An error retrieve taxonomy by Id", (Throwable)e);
        }
        return listTaxonomyRow;
    }

    public List<TaxonomyRow> retrieveSynonymsByRefId(String refId) throws Exception {
        this.logger.trace((Object)("retrieveSynonymsById id: " + refId));
        ArrayList<TaxonomyRow> listTaxonomyRow = new ArrayList<TaxonomyRow>();
        try {
            SpeciesService taxonomyService = this.getSpeciesService();
            CloseableIterator streamIterator = taxonomyService.retrieveSynonymsById(refId);
            TaxonomyItemConverter taxonomyItemConverter = new TaxonomyItemConverter(this.getASLSession());
            int i = 1;
            while (streamIterator.hasNext()) {
                TaxonomyItem tax = (TaxonomyItem)streamIterator.next();
                TaxonomyRow taxonomyRow = taxonomyItemConverter.convert(tax);
                listTaxonomyRow.add(taxonomyRow);
                this.logger.trace((Object)(i + ") retrieveSynonymsById: " + taxonomyRow));
                ++i;
            }
            streamIterator.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error((Object)"An error retrieve synonyms by Id", (Throwable)e);
        }
        return listTaxonomyRow;
    }

    public List<JobOccurrencesModel> createOccurrencesJob(List<JobOccurrencesModel> listJobOccurrenceModel, SaveFileFormat saveFileFormat, OccurrencesSaveEnum csvType, boolean isByDataSource, int expectedOccurrence) throws Exception {
        this.logger.trace((Object)"createOccurencesJobFromSelection...");
        ArrayList<JobOccurrencesModel> listResultJobModel = new ArrayList<JobOccurrencesModel>();
        FetchingSession searchSession = this.getSearchSession();
        SpeciesService taxonomyService = this.getSpeciesService();
        ASLSession aslSession = this.getASLSession();
        String dataSourceAsXml = "";
        try {
            List keys = null;
            OccurrenceJobPersistence occurrencesJobDao = DaoSession.getOccurrencesJobDAO((ASLSession)aslSession);
            if (!isByDataSource) {
                keys = OccurrenceJobUtil.getListOfSelectedKey((FetchingSession)searchSession);
                if (listJobOccurrenceModel != null && listJobOccurrenceModel.get(0) != null) {
                    List dataSourceList = listJobOccurrenceModel.get(0).getDataSources();
                    listResultJobModel.add(OccurrenceJobUtil.createOccurrenceJobOnServiceByKeys((JobOccurrencesModel)listJobOccurrenceModel.get(0), (SpeciesService)taxonomyService, (OccurrenceJobPersistence)occurrencesJobDao, (List)keys, (List)dataSourceList, (SaveFileFormat)saveFileFormat, (OccurrencesSaveEnum)csvType, (int)expectedOccurrence));
                }
            } else {
                for (JobOccurrencesModel jobModel : listJobOccurrenceModel) {
                    dataSourceAsXml = "";
                    if (jobModel.getDataSources() == null || jobModel.getDataSources().get(0) == null) continue;
                    DataSource dataSource = (DataSource)jobModel.getDataSources().get(0);
                    OccurrenceKeys occKey = OccurrenceJobUtil.getListOfSelectedKeyByDataSource((String)dataSource.getName(), (ASLSession)aslSession);
                    List dataSourceList = jobModel.getDataSources();
                    listResultJobModel.add(OccurrenceJobUtil.createOccurrenceJobOnServiceByKeys((JobOccurrencesModel)jobModel, (SpeciesService)taxonomyService, (OccurrenceJobPersistence)occurrencesJobDao, (List)occKey.getListKey(), (List)dataSourceList, (SaveFileFormat)saveFileFormat, (OccurrencesSaveEnum)csvType, (int)occKey.getTotalOccurrence()));
                }
            }
            return listResultJobModel;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred in createOccurencesJobFromSelection", (Throwable)e);
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    public List<JobOccurrencesModel> resubmitOccurrencesJob(String jobIdentifier) throws Exception {
        this.logger.trace((Object)"createOccurencesJobFromSelection...");
        ArrayList<JobOccurrencesModel> listResultJobModel = new ArrayList<JobOccurrencesModel>();
        SpeciesService taxonomyService = this.getSpeciesService();
        ASLSession aslSession = this.getASLSession();
        List keys = null;
        try {
            OccurrenceJobPersistence occurrencesJobDao = DaoSession.getOccurrencesJobDAO((ASLSession)aslSession);
            CriteriaBuilder queryBuilder = occurrencesJobDao.getCriteriaBuilder();
            CriteriaQuery cq = queryBuilder.createQuery();
            Predicate pr1 = queryBuilder.equal((Expression)occurrencesJobDao.rootFrom(cq).get("id"), (Object)jobIdentifier);
            cq.where((Expression)pr1);
            Iterator iterator = occurrencesJobDao.executeCriteriaQuery(cq).iterator();
            if (!iterator.hasNext()) {
                return listResultJobModel;
            }
            OccurrencesJob job = (OccurrencesJob)iterator.next();
            keys = OccurrenceJobUtil.revertListKeyFromStoredXMLString((String)job.getResultRowKeysAsXml());
            SaveFileFormat fileFormat = OccurrenceJobUtil.converFileFormat((String)job.getFileFormat());
            OccurrencesSaveEnum csvType = OccurrenceJobUtil.convertCsvType((String)job.getCsvType());
            JobOccurrencesModel jobModel = new JobOccurrencesModel("", job.getName(), job.getScientificName(), job.getDataSources(), fileFormat, csvType, job.isByDataSource());
            jobModel.setTotalOccurrences(job.getExpectedOccurrence());
            listResultJobModel.add(OccurrenceJobUtil.createOccurrenceJobOnServiceByKeys((JobOccurrencesModel)jobModel, (SpeciesService)taxonomyService, (OccurrenceJobPersistence)occurrencesJobDao, (List)keys, (List)job.getDataSources(), (SaveFileFormat)fileFormat, (OccurrencesSaveEnum)csvType, (int)jobModel.getTotalOccurrences()));
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred in createOccurencesJobFromSelection", (Throwable)e);
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return listResultJobModel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<JobOccurrencesModel> getListOccurrencesJob() throws Exception {
        this.logger.trace((Object)"getListOccurencesJob... ");
        ArrayList<JobOccurrencesModel> listJobs = new ArrayList<JobOccurrencesModel>();
        try {
            OccurrenceJobPersistence occurrencesJobDao = DaoSession.getOccurrencesJobDAO((ASLSession)this.getASLSession());
            Iterator iterator = occurrencesJobDao.getList().iterator();
            SpeciesService taxonomyService = this.getSpeciesService();
            while (iterator != null && iterator.hasNext()) {
                OccurrencesJob job = (OccurrencesJob)iterator.next();
                Status statusResponse = taxonomyService.getOccurrenceJobById(job.getId());
                this.logger.trace((Object)("get occurrence job " + job.getId() + " from service"));
                try {
                    if (statusResponse != null) {
                        this.logger.trace((Object)("statusResponse of occurrence job is not null..." + job.getId()));
                        JobOccurrencesModel jobOccurrenceModel = OccurrenceJobUtil.convertJob((OccurrencesJob)job, (Status)statusResponse, (OccurrenceJobPersistence)occurrencesJobDao);
                        if (jobOccurrenceModel == null) continue;
                        this.logger.trace((Object)("added list jobOccurrenceId: " + jobOccurrenceModel.getJobIdentifier() + " status " + jobOccurrenceModel.getDownloadState()));
                        listJobs.add(jobOccurrenceModel);
                        continue;
                    }
                    this.logger.trace((Object)("statusResponse of occurrence job is null..." + job.getId()));
                    this.logger.trace((Object)("delete job ..." + job.getId()));
                    OccurrenceJobUtil.deleteOccurrenceJobById((String)job.getId(), (OccurrenceJobPersistence)occurrencesJobDao);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.error((Object)"Error on getListOccurencesJob ", (Throwable)e);
                    throw new Exception("Error on getListOccurencesJob", e);
                    return listJobs;
                }
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error on get iterator " + e), (Throwable)e);
        }
        return listJobs;
    }

    public boolean saveOccurrenceJob(JobOccurrencesModel jobModel, String destinationFolderId, String fileName, String scientificName, String dataSourceName) throws Exception {
        this.logger.trace((Object)("saveOccurrenceJob jobId: " + jobModel.getJobIdentifier() + " destinationFolderId: " + destinationFolderId + " fileName: " + fileName + " file format: " + jobModel.getFileFormat()));
        try {
            SpeciesService taxonomyService = this.getSpeciesService();
            String mimeType = null;
            switch (1.$SwitchMap$org$gcube$portlets$user$speciesdiscovery$shared$SaveFileFormat[jobModel.getFileFormat().ordinal()]) {
                case 1: {
                    mimeType = "text/csv";
                    break;
                }
                case 2: {
                    mimeType = "application/xhtml+xml";
                }
            }
            InputStream inputStream = taxonomyService.getOccurrenceJobFileById(jobModel.getJobIdentifier());
            if (inputStream == null) {
                this.logger.trace((Object)"input stream is null");
                return false;
            }
            Workspace workspace = HomeLibrary.getUserWorkspace((ASLSession)this.getASLSession());
            this.logger.trace((Object)"input stream is not null");
            WorkspaceFolder folder = (WorkspaceFolder)workspace.getItem(destinationFolderId);
            fileName = WorkspaceUtil.getUniqueName((String)fileName, (WorkspaceFolder)folder);
            folder.createExternalFileItem(fileName, "Occurrence job generated files", mimeType, inputStream);
            this.logger.trace((Object)"Save file with occurrences was completed");
            return true;
        }
        catch (Exception e) {
            this.logger.error((Object)"An error occurred saving the generated file into the workspace", (Throwable)e);
            throw new SearchServiceException(e.getMessage());
        }
    }

    public boolean cancelOccurrenceJob(String jobIdentifier) throws Exception {
        try {
            SpeciesService taxonomyService = this.getSpeciesService();
            taxonomyService.cancelTaxonomyJobById(jobIdentifier);
            OccurrenceJobPersistence occurrenceJobDAO = DaoSession.getOccurrencesJobDAO((ASLSession)this.getASLSession());
            int count = OccurrenceJobUtil.deleteOccurrenceJobById((String)jobIdentifier, (OccurrenceJobPersistence)occurrenceJobDAO);
            if (count == 1) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Error on cancel occurrence job ", (Throwable)e);
            throw new Exception("Error on cancel occurrence job", e);
        }
        return false;
    }

    public ClusterStructuresForResultRow loadStructuresForResultRowClustering() throws Exception {
        int countSelectedRow = this.countOfSelectedRow();
        boolean isReduced = false;
        int totalRow = countSelectedRow;
        if (countSelectedRow > ConstantsSpeciesDiscovery.LIMIT_ITEM_DETAILS) {
            countSelectedRow = ConstantsSpeciesDiscovery.LIMIT_ITEM_DETAILS;
        }
        ResultFilter filter = new ResultFilter(false, true, true);
        SearchResult searchResults = this.getSearchResultRows(0, countSelectedRow, filter, true);
        return new ClusterStructuresForResultRow(searchResults, isReduced, totalRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataSource> loadDataSourceForResultRow(boolean selected, boolean distinct) throws Exception {
        ResultRowPersistence daoResultRow = null;
        ASLSession session = this.getASLSession();
        ArrayList<DataSource> listDataSource = new ArrayList<DataSource>();
        try {
            daoResultRow = DaoSession.getResultRowDAO((ASLSession)session);
            EntityManager em = daoResultRow.createNewManager();
            List listDN = new ArrayList();
            try {
                String selectString = "select ";
                if (distinct) {
                    selectString = selectString + "distinct ";
                }
                Query query = em.createQuery(selectString + "t." + "dataSourceName" + " from ResultRow t where t.selected = " + selected);
                listDN = query.getResultList();
            }
            finally {
                em.close();
            }
            for (String dataSourceName : listDN) {
                listDataSource.add(new DataSource(dataSourceName, dataSourceName));
            }
        }
        catch (Exception e) {
            this.logger.error((Object)("Error in loadDataSourceForResultRow " + e.getMessage()), (Throwable)e);
            throw new Exception("Error in loadDataSourceForResultRow " + e.getMessage(), e);
        }
        return listDataSource;
    }

    public ClusterStructuresForTaxonomyRow loadStructuresForTaxonomyClustering() throws Exception {
        int countSelectedRow = this.countOfSelectedRow();
        boolean isReduced = false;
        int totalRow = countSelectedRow;
        if (countSelectedRow > ConstantsSpeciesDiscovery.LIMIT_ITEM_DETAILS) {
            countSelectedRow = ConstantsSpeciesDiscovery.LIMIT_ITEM_DETAILS;
            isReduced = true;
        }
        ResultFilter filter = new ResultFilter(false, true, true);
        SearchResult searchResults = this.getSearchTaxonomyRow(0, countSelectedRow, filter, true);
        return new ClusterStructuresForTaxonomyRow(searchResults, isReduced, totalRow);
    }

    public boolean changeStatusOccurrenceJob(String jobIdentifier, DownloadState state) throws Exception {
        OccurrenceJobPersistence occurrenceJobDAO = DaoSession.getOccurrencesJobDAO((ASLSession)this.getASLSession());
        int count = OccurrenceJobUtil.changeStatusOccurrenceJobById((String)jobIdentifier, (DownloadState)state, (OccurrenceJobPersistence)occurrenceJobDAO);
        return count == 1;
    }

    public boolean changeStatusTaxonomyJob(String jobIdentifier, DownloadState state) throws Exception {
        TaxonomyJobPersistence taxonomyJobDAO = DaoSession.getTaxonomyJobDAO((ASLSession)this.getASLSession());
        int count = TaxonomyJobUtil.changeStatusTaxonomyJobById((String)jobIdentifier, (DownloadState)state, (TaxonomyJobPersistence)taxonomyJobDAO);
        return count == 1;
    }

    static {
        Logger root = Logger.getLogger((String)"org.gcube.portlets.user.speciesdiscovery");
        root.setLevel(Level.ALL);
    }
}

