/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.UUID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.storagehub.client.dsl.FileContainer;
import org.gcube.common.storagehub.client.dsl.FolderContainer;
import org.gcube.common.storagehub.client.dsl.OpenResolver;
import org.gcube.common.storagehub.client.dsl.StorageHubClient;
import org.gcube.common.storagehub.model.exceptions.InvalidItemException;
import org.gcube.common.storagehub.model.items.AbstractFileItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadToWorkspaceThread
implements Runnable {
    private static Logger _log = LoggerFactory.getLogger(UploadToWorkspaceThread.class);
    public static final String ATTACHMENT_FOLDER = "Shared attachments";
    private String username;
    private String fullName;
    private String fileName;
    private String fileabsolutePathOnServer;

    public UploadToWorkspaceThread(String fullName, String username, String fileName, String fileabsolutePathOnServer) {
        this.username = username;
        this.fullName = fullName;
        this.fileName = fileName;
        this.fileabsolutePathOnServer = fileabsolutePathOnServer;
    }

    @Override
    public void run() {
        try {
            String currScope = ScopeProvider.instance.get();
            StorageHubClient shc = new StorageHubClient();
            _log.info("Trying to get VRE folder for scope=" + currScope);
            FolderContainer vreFolder = shc.openVREFolder();
            _log.info("File to upload=" + this.fileabsolutePathOnServer);
            File file = new File(this.fileabsolutePathOnServer);
            FileInputStream fileData = new FileInputStream(file);
            FolderContainer attachmentFolder = null;
            try {
                OpenResolver oRes = vreFolder.openByRelativePath(ATTACHMENT_FOLDER);
                attachmentFolder = oRes.asFolder();
            }
            catch (InvalidItemException e) {
                _log.info("Shared attachments in VRE Folder does not exists, creating it for " + currScope);
                vreFolder.newFolder(ATTACHMENT_FOLDER, "Folder created automatically by the System");
            }
            String itemName = this.getUniqueName(this.fileName);
            FileContainer uploadedFile = attachmentFolder.uploadFile((InputStream)fileData, itemName, "File shared by " + this.fullName + "(" + this.username + ")");
            _log.debug("Uploaded " + ((AbstractFileItem)uploadedFile.get()).getName() + " - Returned Workspace id=" + uploadedFile.getId());
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.error("Something wrong while uploading " + this.fileName + " in Workspace VRE Folder " + ATTACHMENT_FOLDER + ": " + e.getMessage());
        }
    }

    private String getUniqueName(String filename) {
        return UUID.randomUUID().toString().substring(0, 8) + "_" + filename;
    }
}

