/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.shareupdates.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.validator.routines.UrlValidator;
import org.gcube.applicationsupportlayer.social.ApplicationNotificationsManager;
import org.gcube.applicationsupportlayer.social.NotificationsManager;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingSite;
import org.gcube.applicationsupportlayer.social.shared.SocialNetworkingUser;
import org.gcube.common.portal.PortalContext;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.common.scope.impl.ScopeBean;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.portal.databook.server.DBCassandraAstyanaxImpl;
import org.gcube.portal.databook.server.DatabookStore;
import org.gcube.portal.databook.shared.Attachment;
import org.gcube.portal.databook.shared.ClientFeed;
import org.gcube.portal.databook.shared.Feed;
import org.gcube.portal.databook.shared.FeedType;
import org.gcube.portal.databook.shared.PrivacyLevel;
import org.gcube.portal.databook.shared.UserInfo;
import org.gcube.portal.databook.shared.ex.FeedIDNotFoundException;
import org.gcube.portal.notifications.bean.GenericItemBean;
import org.gcube.portal.notifications.thread.MentionNotificationsThread;
import org.gcube.portal.notifications.thread.PostNotificationsThread;
import org.gcube.portlets.user.shareupdates.client.ShareUpdateService;
import org.gcube.portlets.user.shareupdates.server.FilePreviewer;
import org.gcube.portlets.user.shareupdates.server.TextTransfromUtils;
import org.gcube.portlets.user.shareupdates.server.UploadToStorageThread;
import org.gcube.portlets.user.shareupdates.server.UploadToWorkspaceThread;
import org.gcube.portlets.user.shareupdates.server.opengraph.OpenGraph;
import org.gcube.portlets.user.shareupdates.shared.HashTagAndOccurrence;
import org.gcube.portlets.user.shareupdates.shared.LinkPreview;
import org.gcube.portlets.user.shareupdates.shared.UploadedFile;
import org.gcube.portlets.user.shareupdates.shared.UserSettings;
import org.gcube.portlets.widgets.pickitem.shared.ItemBean;
import org.gcube.social_networking.socialutillibrary.Utils;
import org.gcube.vomanagement.usermanagement.UserManager;
import org.gcube.vomanagement.usermanagement.exception.GroupRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.TeamRetrievalFault;
import org.gcube.vomanagement.usermanagement.exception.UserManagementSystemException;
import org.gcube.vomanagement.usermanagement.exception.UserRetrievalFault;
import org.gcube.vomanagement.usermanagement.impl.LiferayGroupManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayRoleManager;
import org.gcube.vomanagement.usermanagement.impl.LiferayUserManager;
import org.gcube.vomanagement.usermanagement.model.CustomAttributeKeys;
import org.gcube.vomanagement.usermanagement.model.GCubeGroup;
import org.gcube.vomanagement.usermanagement.model.GCubeUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.https.Handler;

/*
 * Exception performing whole class analysis ignored.
 */
public class ShareUpdateServiceImpl
extends RemoteServiceServlet
implements ShareUpdateService {
    public static final String TEST_USER = "test.user";
    private static final String STORAGE_OWNER = "gCubeSocialFramework";
    public static final String UPLOAD_DIR = "/social-framework-uploads";
    private static final String NEWS_FEED_PORTLET_CLASSNAME = "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl";
    private static final Logger _log = LoggerFactory.getLogger(ShareUpdateServiceImpl.class);
    private DatabookStore store;

    public void init() {
        this.store = new DBCassandraAstyanaxImpl();
    }

    public void destroy() {
        this.store.closeConnection();
    }

    public static boolean isWithinPortal() {
        try {
            UserLocalServiceUtil.getService();
            return true;
        }
        catch (Exception ex) {
            _log.trace("Development Mode ON");
            return false;
        }
    }

    public ClientFeed sharePostWithLinkPreview(String postText, FeedType feedType, PrivacyLevel pLevel, Long vreOrgId, LinkPreview preview, String urlThumbnail, ArrayList<String> mentionedUserFullNames, boolean notifyGroup) {
        String escapedFeedText = Utils.escapeHtmlAndTransformUrl((String)postText);
        List hashtags = Utils.getHashTags((String)escapedFeedText);
        if (hashtags != null && !hashtags.isEmpty()) {
            escapedFeedText = Utils.convertHashtagsAnchorHTML((String)escapedFeedText, (List)hashtags);
        }
        ArrayList mentionedUsers = null;
        if (mentionedUserFullNames != null && !mentionedUserFullNames.isEmpty()) {
            mentionedUsers = this.getSelectedUserIds(mentionedUserFullNames);
            escapedFeedText = Utils.convertMentionPeopleAnchorHTML((String)escapedFeedText, (ArrayList)mentionedUsers, (HttpServletRequest)this.getThreadLocalRequest());
        }
        PortalContext context = PortalContext.getConfiguration();
        GCubeUser currUser = context.getCurrentUser(this.getThreadLocalRequest());
        String username = currUser.getUsername();
        String email = currUser.getEmail();
        String fullName = currUser.getFullname();
        String thumbnailAvatarURL = currUser.getUserAvatarURL();
        String linkTitle = preview.getTitle();
        String linkDesc = preview.getDescription();
        String host = preview.getHost();
        String url = preview.getUrl();
        urlThumbnail = urlThumbnail == null ? "null" : FilePreviewer.saveThumbnailOnFTPAndGetUrl((String)urlThumbnail, (String)context.getCurrentScope(this.getThreadLocalRequest()));
        Date feedDate = new Date();
        String vreScope2Set = "";
        if (pLevel == PrivacyLevel.SINGLE_VRE && vreOrgId != null) {
            vreScope2Set = context.getCurrentScope(this.getThreadLocalRequest());
        }
        Feed toShare = new Feed(UUID.randomUUID().toString(), feedType, username, feedDate, vreScope2Set, url, urlThumbnail, escapedFeedText, pLevel, fullName, email, thumbnailAvatarURL, linkTitle, linkDesc, host);
        _log.info("Attempting to save Feed with text: " + escapedFeedText + " Level: " + pLevel + " Timeline=" + vreScope2Set);
        boolean result = this.store.saveUserFeed(toShare);
        if (pLevel == PrivacyLevel.VRES) {
            _log.trace("PrivacyLevel was set to VRES attempting to write onto User's VRES Timelines");
            for (GCubeGroup vre : this.getUserVREs(username)) {
                String vreScope = "";
                try {
                    vreScope = new LiferayGroupManager().getInfrastructureScope(vre.getGroupId());
                    _log.trace("Attempting to write onto " + vreScope);
                    this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
                }
                catch (FeedIDNotFoundException e) {
                    _log.error("Error writing onto VRES Time Line" + vreScope);
                }
                catch (Exception e) {
                    _log.error("Error retrieving user VRES");
                }
                _log.trace("Success writing onto " + vreScope);
            }
        } else if (pLevel == PrivacyLevel.SINGLE_VRE && vreOrgId != null) {
            _log.trace("Attempting to write onto " + vreScope2Set);
            try {
                this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope2Set);
                if (hashtags != null && !hashtags.isEmpty()) {
                    this.store.saveHashTags(toShare.getKey(), vreScope2Set, hashtags);
                }
            }
            catch (FeedIDNotFoundException e) {
                _log.error("Error writing onto VRES Time Line" + vreScope2Set);
            }
            _log.trace("Success writing onto " + vreScope2Set);
        }
        if (!result) {
            return null;
        }
        ClientFeed cf = new ClientFeed(toShare.getKey(), toShare.getType().toString(), username, feedDate, toShare.getUri(), toShare.getDescription(), fullName, email, thumbnailAvatarURL, toShare.getLinkTitle(), toShare.getLinkDescription(), toShare.getUriThumbnail(), toShare.getLinkHost(), null);
        this.notifyPeopleGroup(pLevel, vreOrgId, notifyGroup, username, email, fullName, thumbnailAvatarURL, toShare, hashtags, vreScope2Set, escapedFeedText, mentionedUsers);
        if (mentionedUsers != null && mentionedUsers.size() > 0) {
            this.notifyMentionedUsers(vreScope2Set, mentionedUsers, username, email, fullName, thumbnailAvatarURL, toShare, escapedFeedText);
        }
        return cf;
    }

    public ClientFeed sharePostWithAttachments(String feedText, FeedType feedType, PrivacyLevel pLevel, Long vreOrgId, ArrayList<UploadedFile> uploadedFiles, ArrayList<String> mentionedUserFullNames, boolean notifyGroup, boolean saveCopyWokspace) {
        boolean result;
        String escapedFeedText = Utils.escapeHtmlAndTransformUrl((String)feedText);
        List hashtags = Utils.getHashTags((String)escapedFeedText);
        if (hashtags != null && !hashtags.isEmpty()) {
            escapedFeedText = Utils.convertHashtagsAnchorHTML((String)escapedFeedText, (List)hashtags);
        }
        ArrayList mentionedUsers = null;
        if (mentionedUserFullNames != null && !mentionedUserFullNames.isEmpty()) {
            mentionedUsers = this.getSelectedUserIds(mentionedUserFullNames);
            escapedFeedText = Utils.convertMentionPeopleAnchorHTML((String)escapedFeedText, (ArrayList)mentionedUsers, (HttpServletRequest)this.getThreadLocalRequest());
        }
        PortalContext context = PortalContext.getConfiguration();
        GCubeUser currUser = context.getCurrentUser(this.getThreadLocalRequest());
        String username = currUser.getUsername();
        String email = currUser.getEmail();
        String fullName = currUser.getFullname();
        String thumbnailAvatarURL = currUser.getUserAvatarURL();
        ArrayList<Attachment> attachments = null;
        String firstAttachmentName = "";
        String firstAttachmentDescription = "";
        String firstAttachmentFormat = "";
        String firstAttachmentDownloadUrl = "";
        String firstAttachmenturlThumbnail = "";
        if (uploadedFiles.size() > 0) {
            UploadedFile firstAttachment = uploadedFiles.get(0);
            firstAttachmentName = firstAttachment.getFileName();
            firstAttachmentDescription = firstAttachment.getDescription();
            firstAttachmentFormat = firstAttachment.getFormat();
            firstAttachmentDownloadUrl = firstAttachment.getDownloadUrl();
            String string = firstAttachmenturlThumbnail = firstAttachment.getThumbnailUrl() != null ? firstAttachment.getThumbnailUrl() : firstAttachmenturlThumbnail;
            if (uploadedFiles.size() > 1) {
                attachments = new ArrayList<Attachment>();
                for (int i = 1; i < uploadedFiles.size(); ++i) {
                    UploadedFile file = uploadedFiles.get(i);
                    attachments.add(new Attachment(UUID.randomUUID().toString(), file.getDownloadUrl(), file.getFileName(), file.getDescription(), file.getThumbnailUrl(), file.getFormat()));
                }
            }
        }
        Date feedDate = new Date();
        String textToPost = "";
        if (escapedFeedText.trim().compareTo("_N0_73X7_SH4R3_") == 0) {
            if (uploadedFiles.size() <= 1) {
                textToPost = Utils.convertFileNameAnchorHTML((String)firstAttachmentDownloadUrl);
            } else {
                StringBuilder sb = new StringBuilder();
                textToPost = sb.append("<span style=\"color:gray; font-size:12px;\">shared a set of files.</span>").toString();
            }
        } else {
            textToPost = escapedFeedText;
        }
        String vreScope2Set = "";
        if (pLevel == PrivacyLevel.SINGLE_VRE && vreOrgId != null) {
            vreScope2Set = context.getCurrentScope(this.getThreadLocalRequest());
        }
        Feed toShare = null;
        if (uploadedFiles.size() <= 1) {
            toShare = new Feed(UUID.randomUUID().toString(), feedType, username, feedDate, vreScope2Set, firstAttachmentDownloadUrl, firstAttachmenturlThumbnail, textToPost, pLevel, fullName, email, thumbnailAvatarURL, firstAttachmentName, firstAttachmentDescription, firstAttachmentFormat);
            result = this.store.saveUserFeed(toShare);
        } else {
            toShare = new Feed(UUID.randomUUID().toString(), feedType, username, feedDate, vreScope2Set, firstAttachmentDownloadUrl, firstAttachmenturlThumbnail, textToPost, pLevel, fullName, email, thumbnailAvatarURL, firstAttachmentName, firstAttachmentDescription, firstAttachmentFormat);
            toShare.setMultiFileUpload(true);
            result = this.store.saveUserFeed(toShare, attachments);
        }
        _log.info("Attempting to save Feed with text: " + textToPost + " Level: " + pLevel + " Timeline=" + vreScope2Set);
        if (pLevel == PrivacyLevel.VRES) {
            _log.trace("PrivacyLevel was set to VRES attempting to write onto User's VRES Timelines");
            for (GCubeGroup vre : this.getUserVREs(username)) {
                String vreScope = this.getScopeByGroupId(Long.valueOf(vre.getGroupId()));
                _log.trace("Attempting to write onto " + vreScope);
                try {
                    this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope);
                }
                catch (FeedIDNotFoundException e) {
                    _log.error("Error writing onto VRES Time Line" + vreScope);
                }
                _log.trace("Success writing onto " + vreScope);
            }
        } else if (pLevel == PrivacyLevel.SINGLE_VRE && vreOrgId != null) {
            _log.trace("Attempting to write onto " + vreScope2Set);
            try {
                this.store.saveFeedToVRETimeline(toShare.getKey(), vreScope2Set);
                if (hashtags != null && !hashtags.isEmpty()) {
                    this.store.saveHashTags(toShare.getKey(), vreScope2Set, hashtags);
                }
            }
            catch (FeedIDNotFoundException e) {
                _log.error("Error writing onto VRES Time Line" + vreScope2Set);
            }
            _log.trace("Success writing onto " + vreScope2Set);
        }
        if (!result) {
            return null;
        }
        ClientFeed cf = new ClientFeed(toShare.getKey(), toShare.getType().toString(), username, feedDate, toShare.getUri(), toShare.getDescription(), fullName, email, thumbnailAvatarURL, toShare.getLinkTitle(), toShare.getLinkDescription(), toShare.getUriThumbnail(), toShare.getLinkHost(), attachments);
        this.notifyPeopleGroup(pLevel, vreOrgId, notifyGroup, username, email, fullName, thumbnailAvatarURL, toShare, hashtags, vreScope2Set, textToPost, mentionedUsers);
        if (mentionedUsers != null && mentionedUsers.size() > 0) {
            this.notifyMentionedUsers(vreScope2Set, mentionedUsers, username, email, fullName, thumbnailAvatarURL, toShare, textToPost);
        }
        if (saveCopyWokspace) {
            this.saveCopyIntoWorkSpace(fullName, username, uploadedFiles);
        }
        return cf;
    }

    private void notifyPeopleGroup(PrivacyLevel pLevel, Long vreOrgId, boolean notifyGroup, String username, String email, String fullName, String thumbnailAvatarURL, Feed toShare, List<String> hashtags, String vreScope2Set, String postText, ArrayList<ItemBean> mentionedUsers) {
        if (pLevel == PrivacyLevel.SINGLE_VRE && vreOrgId != null && notifyGroup) {
            ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), vreScope2Set, new SocialNetworkingUser(username, email, fullName, thumbnailAvatarURL), "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
            Thread thread = new Thread((Runnable)new PostNotificationsThread((UserManager)new LiferayUserManager(), toShare.getKey(), postText, "" + vreOrgId, (NotificationsManager)nm, new HashSet<String>(hashtags), ShareUpdateServiceImpl.getVreGroupsNames(mentionedUsers)));
            thread.start();
        }
    }

    private void saveCopyIntoWorkSpace(String fullName, String username, ArrayList<UploadedFile> uploadedFiles) {
        for (UploadedFile file : uploadedFiles) {
            new Thread((Runnable)new UploadToWorkspaceThread(fullName, username, file.getFileName(), file.getFileAbsolutePathOnServer())).start();
        }
    }

    private static Set<String> getVreGroupsNames(ArrayList<ItemBean> mentionedUsers) {
        HashSet<String> toReturn = new HashSet<String>();
        LiferayRoleManager rManager = new LiferayRoleManager();
        if (mentionedUsers != null && !mentionedUsers.isEmpty()) {
            for (ItemBean itemBean : mentionedUsers) {
                if (!itemBean.isItemGroup()) continue;
                try {
                    toReturn.add(rManager.getTeam(Long.parseLong(itemBean.getId())).getTeamName());
                }
                catch (NumberFormatException | TeamRetrievalFault | UserManagementSystemException e) {
                    _log.warn("Unable to add this team", e);
                }
            }
        }
        return toReturn;
    }

    private void notifyMentionedUsers(String vreScope2Set, ArrayList<ItemBean> mentionedUsers, String username, String email, String fullName, String thumbnailAvatarURL, Feed toShare, String escapedFeedText) {
        ApplicationNotificationsManager nm = new ApplicationNotificationsManager(new SocialNetworkingSite(this.getThreadLocalRequest()), vreScope2Set, new SocialNetworkingUser(username, email, fullName, thumbnailAvatarURL), "org.gcube.portlets.user.newsfeed.server.NewsServiceImpl");
        ArrayList<GenericItemBean> toPass = new ArrayList<GenericItemBean>();
        HashMap<String, ItemBean> uniqueUsersToNotify = new HashMap<String, ItemBean>();
        LiferayUserManager um = new LiferayUserManager();
        for (ItemBean bean : mentionedUsers) {
            if (bean.isItemGroup()) {
                try {
                    List teamUsers = um.listUsersByTeam(Long.parseLong(bean.getId()));
                    for (GCubeUser userTeam : teamUsers) {
                        if (uniqueUsersToNotify.containsKey(userTeam.getUsername())) continue;
                        uniqueUsersToNotify.put(userTeam.getUsername(), new ItemBean(userTeam.getUserId() + "", userTeam.getUsername(), userTeam.getFullname(), userTeam.getUserAvatarURL()));
                    }
                    continue;
                }
                catch (NumberFormatException | TeamRetrievalFault | UserManagementSystemException | UserRetrievalFault e) {
                    _log.error("Unable to retrieve team information", e);
                    continue;
                }
            }
            if (uniqueUsersToNotify.containsKey(bean.getName())) continue;
            uniqueUsersToNotify.put(bean.getName(), bean);
        }
        for (Map.Entry user : uniqueUsersToNotify.entrySet()) {
            ItemBean userBean = (ItemBean)user.getValue();
            toPass.add(new GenericItemBean(userBean.getId(), userBean.getName(), userBean.getAlternativeName(), userBean.getThumbnailURL()));
        }
        Thread thread = new Thread((Runnable)new MentionNotificationsThread(toShare.getKey(), escapedFeedText, (NotificationsManager)nm, null, toPass));
        thread.start();
    }

    public UserSettings getUserSettings() {
        try {
            String profilePageURL;
            PortalContext context = PortalContext.getConfiguration();
            GCubeUser currUser = context.getCurrentUser(this.getThreadLocalRequest());
            String username = currUser.getUsername();
            _log.debug("getUserSettings() for " + username);
            String thumbnailURL = currUser.getUserAvatarURL();
            String fullName = currUser.getFullname();
            String email = currUser.getEmail();
            String accountURL = profilePageURL = "/group" + PortalContext.getConfiguration().getSiteLandingPagePath(this.getThreadLocalRequest()) + "/profile";
            try {
                accountURL = "";
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
            HashMap vreNames = this.getUserVreNames(username);
            UserInfo userInfo = new UserInfo(username, fullName, thumbnailURL, email, accountURL, true, this.isAdmin(), vreNames);
            UserSettings toReturn = new UserSettings(userInfo, 0, context.getCurrentScope(this.getThreadLocalRequest()), this.isInfrastructureScope(), this.isNotificationViaEmailEnabled());
            _log.debug("getUserSettings() return " + toReturn);
            return toReturn;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new UserSettings();
        }
    }

    private boolean isNotificationViaEmailEnabled() throws UserManagementSystemException, GroupRetrievalFault {
        if (!ShareUpdateServiceImpl.isWithinPortal()) {
            return false;
        }
        PortalContext context = PortalContext.getConfiguration();
        LiferayGroupManager gm = new LiferayGroupManager();
        return (Boolean)gm.readCustomAttr(context.getCurrentGroupId(this.getThreadLocalRequest()), CustomAttributeKeys.POST_NOTIFICATION.getKeyName());
    }

    private boolean isAdmin() throws PortalException, SystemException {
        if (!ShareUpdateServiceImpl.isWithinPortal()) {
            return false;
        }
        try {
            PortalContext context = PortalContext.getConfiguration();
            GCubeUser currUser = context.getCurrentUser(this.getThreadLocalRequest());
            return new LiferayRoleManager().isAdmin(currUser.getUserId());
        }
        catch (Exception e) {
            _log.error("Could not check if the user is an Administrator, returning false");
            return false;
        }
    }

    public LinkPreview checkUploadedFile(String fileName, String fileabsolutePathOnServer) {
        PortalContext context = PortalContext.getConfiguration();
        LinkPreview toReturn = null;
        String randomUploadFolderName = UUID.randomUUID().toString();
        String remoteFilePath = "/social-framework-uploads/" + randomUploadFolderName + "/" + fileName;
        String currScope = ScopeProvider.instance.get();
        ScopeProvider.instance.set(context.getCurrentScope(this.getThreadLocalRequest()));
        IClient storageClient = new StorageClient("gCubeSocialFramework", AccessType.SHARED, MemoryType.PERSISTENT).getClient();
        ScopeProvider.instance.set(currScope);
        String httpURL = "";
        String smpURI = "";
        String mimeType = null;
        if (ShareUpdateServiceImpl.isWithinPortal()) {
            smpURI = storageClient.getHttpUrl(true).RFile(remoteFilePath);
            try {
                mimeType = FilePreviewer.getMimeType((File)new File(fileabsolutePathOnServer), (String)fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Object thread = new Thread((Runnable)new UploadToStorageThread(storageClient, fileName, fileabsolutePathOnServer, remoteFilePath, mimeType));
            ((Thread)thread).start();
        }
        try {
            httpURL = smpURI;
            switch (mimeType) {
                case "application/pdf": {
                    toReturn = FilePreviewer.getPdfPreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType, (String)context.getCurrentScope(this.getThreadLocalRequest()));
                    break;
                }
                case "application/vnd.openxmlformats-officedocument.wordprocessingml.document": {
                    mimeType = "application/wordprocessor";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType, (String)context.getCurrentScope(this.getThreadLocalRequest()));
                }
                case "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet": {
                    mimeType = "application/spreadsheet";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType, (String)context.getCurrentScope(this.getThreadLocalRequest()));
                }
                case "application/vnd.openxmlformats-officedocument.presentationml.presentation": {
                    mimeType = "application/presentation";
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType, (String)context.getCurrentScope(this.getThreadLocalRequest()));
                }
                case "image/png": 
                case "image/gif": 
                case "image/tiff": 
                case "image/jpg": 
                case "image/jpeg": 
                case "image/bmp": {
                    toReturn = FilePreviewer.getImagePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType, (String)context.getCurrentScope(this.getThreadLocalRequest()));
                    break;
                }
                default: {
                    return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)mimeType, (String)context.getCurrentScope(this.getThreadLocalRequest()));
                }
            }
        }
        catch (Exception e) {
            _log.error("Error while resolving or previewing file");
            e.printStackTrace();
            try {
                return FilePreviewer.getUnhandledTypePreview((String)fileName, (String)fileabsolutePathOnServer, (String)httpURL, (String)"Error During upload on Server!", (String)context.getCurrentScope(this.getThreadLocalRequest()));
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        _log.debug("smpURI=" + smpURI);
        _log.debug("Returning httpURL=" + httpURL);
        return toReturn;
    }

    public LinkPreview checkLink(String linkToCheck) {
        URL pageURL;
        LinkPreview toReturn = null;
        _log.info("to check " + linkToCheck);
        linkToCheck = Utils.extractURL((String)linkToCheck);
        if (linkToCheck == null) {
            return null;
        }
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (!urlValidator.isValid(linkToCheck)) {
            _log.warn("url is NOT valid, returning nothing");
            return null;
        }
        _log.debug("url is valid");
        HttpURLConnection siteConnection = null;
        try {
            pageURL = new URL(null, linkToCheck, new Handler());
            if (pageURL.getProtocol().equalsIgnoreCase("https")) {
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                Security.addProvider((java.security.Provider)new Provider());
                TextTransfromUtils.trustAllHTTPSConnections();
                siteConnection = (HttpsURLConnection)pageURL.openConnection();
            } else {
                pageURL = new URL(linkToCheck);
                siteConnection = (HttpURLConnection)pageURL.openConnection();
            }
        }
        catch (MalformedURLException e) {
            _log.error("url is not valid");
            return null;
        }
        catch (IOException e) {
            _log.error("url is not reachable");
            return null;
        }
        siteConnection.addRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.95 Safari/537.11");
        ArrayList imageUrls = new ArrayList();
        String host = pageURL.getHost().replaceAll("www.", "");
        OpenGraph ogLink = null;
        try {
            ogLink = new OpenGraph(linkToCheck, true, (URLConnection)siteConnection);
            if (ogLink != null && ogLink.getContent("title") != null) {
                _log.info("OpenGraph Found");
                String title = ogLink.getContent("title");
                String description = ogLink.getContent("description") != null ? ogLink.getContent("description") : "";
                String string = description = description.length() > 256 ? description.substring(0, 256) + "..." : description;
                if (ogLink.getContent("image") != null) {
                    String imageUrl = TextTransfromUtils.getImageUrlFromSrcAttribute((URL)ogLink.getRealURL(), (String)ogLink.getContent("image"));
                    imageUrls.add(imageUrl);
                    _log.trace("OpenGraph getImage = " + imageUrl);
                } else {
                    _log.trace("OpenGraph No Image, trying manuale parsing");
                    ArrayList images = TextTransfromUtils.getImagesWithCleaner((URL)pageURL);
                    if (!images.isEmpty()) {
                        imageUrls = images;
                    }
                }
                toReturn = new LinkPreview(title, description, linkToCheck, host, imageUrls);
                return toReturn;
            }
            _log.info("No OpenGraph Found, going Best guess from page content");
            toReturn = TextTransfromUtils.getInfoFromHTML((URLConnection)siteConnection, (URL)pageURL, (String)linkToCheck, (String)host);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toReturn;
    }

    private HashMap<String, String> getUserVreNames(String username) {
        HashMap<String, String> toReturn = new HashMap<String, String>();
        PortalContext context = PortalContext.getConfiguration();
        String groupName = context.getCurrentGroupName(this.getThreadLocalRequest());
        if (!ShareUpdateServiceImpl.isWithinPortal()) {
            toReturn.put("" + context.getCurrentGroupId(this.getThreadLocalRequest()), groupName);
            return toReturn;
        }
        for (GCubeGroup vre : this.getUserVREs(username)) {
            if (vre.getGroupName().compareTo(groupName) != 0) continue;
            toReturn.put(vre.getGroupId() + "", vre.getGroupName());
        }
        return toReturn;
    }

    private ArrayList<GCubeGroup> getUserVREs(String username) {
        ArrayList<GCubeGroup> toReturn = new ArrayList<GCubeGroup>();
        try {
            LiferayGroupManager gm = new LiferayGroupManager();
            GCubeUser currUser = new LiferayUserManager().getUserByUsername(username);
            for (GCubeGroup group : gm.listGroupsByUser(currUser.getUserId())) {
                if (!gm.isVRE(group.getGroupId()).booleanValue()) continue;
                toReturn.add(group);
            }
        }
        catch (Exception e) {
            _log.error("Failed reading User VREs for : " + username);
            e.printStackTrace();
            return toReturn;
        }
        return toReturn;
    }

    private String getScopeByGroupId(Long vreGroupId) {
        try {
            return new LiferayGroupManager().getInfrastructureScope(vreGroupId.longValue());
        }
        catch (Exception e) {
            _log.error("Could not find a scope for this vreGroupId: " + vreGroupId);
            return null;
        }
    }

    private boolean isInfrastructureScope() {
        PortalContext context = PortalContext.getConfiguration();
        ScopeBean scope = new ScopeBean(context.getCurrentScope(this.getThreadLocalRequest()));
        return scope.is(ScopeBean.Type.INFRASTRUCTURE);
    }

    public ArrayList<ItemBean> getSelectedUserIds(ArrayList<String> fullNames) {
        if (fullNames == null) {
            return new ArrayList<ItemBean>();
        }
        ArrayList allbeans = this.getPortalItemBeans();
        ArrayList<ItemBean> toReturn = new ArrayList<ItemBean>();
        block0: for (String fullName : fullNames) {
            for (ItemBean puser : allbeans) {
                if (puser.getAlternativeName().compareTo(fullName) != 0) continue;
                toReturn.add(puser);
                continue block0;
            }
        }
        return toReturn;
    }

    public ArrayList<ItemBean> getPortalItemBeans() {
        PortalContext context = PortalContext.getConfiguration();
        context.getCurrentScope(this.getThreadLocalRequest());
        String scope = context.getCurrentScope(this.getThreadLocalRequest());
        String username = context.getCurrentUser(this.getThreadLocalRequest()).getUsername();
        boolean withinPortal = false;
        if (ShareUpdateServiceImpl.isWithinPortal() && username.compareTo("test.user") != 0) {
            withinPortal = true;
        }
        return Utils.getDisplayableItemBeans((String)scope, (String)username, (boolean)withinPortal);
    }

    public ArrayList<ItemBean> getHashtags() {
        PortalContext context = PortalContext.getConfiguration();
        context.getCurrentScope(this.getThreadLocalRequest());
        String scope = context.getCurrentScope(this.getThreadLocalRequest());
        _log.error("getting hashtags for " + scope);
        Map map = this.store.getVREHashtagsWithOccurrence(scope);
        ArrayList<HashTagAndOccurrence> toSort = new ArrayList<HashTagAndOccurrence>();
        _log.trace("Got " + map.keySet().size() + " hashtags");
        for (String hashtag : map.keySet()) {
            toSort.add(new HashTagAndOccurrence(hashtag, (Integer)map.get(hashtag)));
        }
        Collections.sort(toSort, Collections.reverseOrder());
        ArrayList<ItemBean> toReturn = new ArrayList<ItemBean>();
        for (HashTagAndOccurrence wrapper : toSort) {
            String hashtag = wrapper.getHashtag();
            toReturn.add(new ItemBean(hashtag, hashtag, hashtag, null));
        }
        return toReturn;
    }
}

